/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.LegacyPropertyAdapter;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.iso.Types;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Datatype;
import org.opengis.metadata.ExtendedElementInformation;
import org.opengis.metadata.Obligation;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.util.InternationalString;

@XmlType(name="MD_ExtendedElementInformation_Type", propOrder={"name", "shortName", "domainCode", "definition", "obligation", "condition", "dataType", "maximumOccurrence", "domainValue", "parentEntity", "rule", "rationales", "sources"})
@XmlRootElement(name="MD_ExtendedElementInformation")
public class DefaultExtendedElementInformation
extends ISOMetadata
implements ExtendedElementInformation {
    private static final long serialVersionUID = 5892811836634834434L;
    private String name;
    @Deprecated
    private String shortName;
    @Deprecated
    private Integer domainCode;
    private InternationalString definition;
    private Obligation obligation;
    private InternationalString condition;
    private Datatype dataType;
    private Integer maximumOccurrence;
    private InternationalString domainValue;
    private Collection<String> parentEntity;
    private InternationalString rule;
    private Collection<InternationalString> rationales;
    private Collection<ResponsibleParty> sources;

    public DefaultExtendedElementInformation() {
    }

    public DefaultExtendedElementInformation(String string, CharSequence charSequence, CharSequence charSequence2, Datatype datatype, String string2, CharSequence charSequence3, ResponsibleParty responsibleParty) {
        this.name = string;
        this.definition = Types.toInternationalString(charSequence);
        this.condition = Types.toInternationalString(charSequence2);
        this.dataType = datatype;
        this.parentEntity = this.singleton(string2, String.class);
        this.rule = Types.toInternationalString(charSequence3);
        this.sources = this.singleton(responsibleParty, ResponsibleParty.class);
    }

    public DefaultExtendedElementInformation(ExtendedElementInformation extendedElementInformation) {
        super(extendedElementInformation);
        if (extendedElementInformation != null) {
            this.name = extendedElementInformation.getName();
            this.shortName = extendedElementInformation.getShortName();
            this.domainCode = extendedElementInformation.getDomainCode();
            this.definition = extendedElementInformation.getDefinition();
            this.obligation = extendedElementInformation.getObligation();
            this.condition = extendedElementInformation.getCondition();
            this.dataType = extendedElementInformation.getDataType();
            this.maximumOccurrence = extendedElementInformation.getMaximumOccurrence();
            this.domainValue = extendedElementInformation.getDomainValue();
            this.parentEntity = this.copyCollection(extendedElementInformation.getParentEntity(), String.class);
            this.rule = extendedElementInformation.getRule();
            this.rationales = this.copyCollection(extendedElementInformation.getRationales(), InternationalString.class);
            this.sources = this.copyCollection(extendedElementInformation.getSources(), ResponsibleParty.class);
        }
    }

    public static DefaultExtendedElementInformation castOrCopy(ExtendedElementInformation extendedElementInformation) {
        if (extendedElementInformation == null || extendedElementInformation instanceof DefaultExtendedElementInformation) {
            return (DefaultExtendedElementInformation)extendedElementInformation;
        }
        return new DefaultExtendedElementInformation(extendedElementInformation);
    }

    @Override
    @XmlElement(name="name", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.checkWritePermission();
        this.name = string;
    }

    @Override
    @Deprecated
    @XmlElement(name="shortName")
    public String getShortName() {
        return this.shortName;
    }

    @Deprecated
    public void setShortName(String string) {
        this.checkWritePermission();
        this.shortName = string;
    }

    @Override
    @Deprecated
    @XmlElement(name="domainCode")
    public Integer getDomainCode() {
        return this.domainCode;
    }

    @Deprecated
    public void setDomainCode(Integer n) {
        this.checkWritePermission();
        this.domainCode = n;
    }

    @Override
    @XmlElement(name="definition", required=true)
    public InternationalString getDefinition() {
        return this.definition;
    }

    public void setDefinition(InternationalString internationalString) {
        this.checkWritePermission();
        this.definition = internationalString;
    }

    @Override
    @XmlElement(name="obligation")
    public Obligation getObligation() {
        return this.obligation;
    }

    public void setObligation(Obligation obligation) {
        this.checkWritePermission();
        this.obligation = obligation;
    }

    @Override
    @XmlElement(name="condition")
    public InternationalString getCondition() {
        return this.condition;
    }

    public void setCondition(InternationalString internationalString) {
        this.checkWritePermission();
        this.condition = internationalString;
    }

    @Override
    @XmlElement(name="dataType", required=true)
    public Datatype getDataType() {
        return this.dataType;
    }

    public void setDataType(Datatype datatype) {
        this.checkWritePermission();
        this.dataType = datatype;
    }

    @Override
    @ValueRange(minimum=0.0)
    @XmlElement(name="maximumOccurrence")
    public Integer getMaximumOccurrence() {
        return this.maximumOccurrence;
    }

    public void setMaximumOccurrence(Integer n) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultExtendedElementInformation.class, "maximumOccurrence", false, n)) {
            this.maximumOccurrence = n;
        }
    }

    @Override
    @XmlElement(name="domainValue")
    public InternationalString getDomainValue() {
        return this.domainValue;
    }

    public void setDomainValue(InternationalString internationalString) {
        this.checkWritePermission();
        this.domainValue = internationalString;
    }

    @Override
    @XmlElement(name="parentEntity", required=true)
    public Collection<String> getParentEntity() {
        this.parentEntity = this.nonNullCollection(this.parentEntity, String.class);
        return this.parentEntity;
    }

    public void setParentEntity(Collection<? extends String> collection) {
        this.parentEntity = this.writeCollection(collection, this.parentEntity, String.class);
    }

    @Override
    @XmlElement(name="rule", required=true)
    public InternationalString getRule() {
        return this.rule;
    }

    public void setRule(InternationalString internationalString) {
        this.checkWritePermission();
        this.rule = internationalString;
    }

    @UML(identifier="rationale", obligation=org.opengis.annotation.Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InternationalString getRationale() {
        return LegacyPropertyAdapter.getSingleton(this.rationales, InternationalString.class, null, DefaultExtendedElementInformation.class, "getRationale");
    }

    public void setRationale(InternationalString internationalString) {
        this.rationales = this.writeCollection(LegacyPropertyAdapter.asCollection(internationalString), this.rationales, InternationalString.class);
    }

    @Deprecated
    @XmlElement(name="rationale")
    public Collection<InternationalString> getRationales() {
        this.rationales = this.nonNullCollection(this.rationales, InternationalString.class);
        return this.rationales;
    }

    @Deprecated
    public void setRationales(Collection<? extends InternationalString> collection) {
        this.rationales = this.writeCollection(collection, this.rationales, InternationalString.class);
    }

    @XmlElement(name="source", required=true)
    public Collection<ResponsibleParty> getSources() {
        this.sources = this.nonNullCollection(this.sources, ResponsibleParty.class);
        return this.sources;
    }

    public void setSources(Collection<? extends ResponsibleParty> collection) {
        this.sources = this.writeCollection(collection, this.sources, ResponsibleParty.class);
    }
}

