/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.tasks;

import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.tasks.CopyTask;

public class MoveTask
extends CopyTask {
    private boolean tryRename;

    public void setTryRename(boolean tryRename) {
        this.tryRename = tryRename;
    }

    protected void handleOutOfDateFile(FileObject srcFile, FileObject destFile) throws FileSystemException {
        if (!this.tryRename || !srcFile.canRenameTo(destFile)) {
            super.handleOutOfDateFile(srcFile, destFile);
            this.log("Deleting " + srcFile);
            srcFile.delete(Selectors.SELECT_SELF);
        } else {
            this.log("Rename " + srcFile + " to " + destFile);
            srcFile.moveTo(destFile);
            if (!this.isPreserveLastModified() && destFile.getFileSystem().hasCapability(Capability.SET_LAST_MODIFIED_FILE)) {
                destFile.getContent().setLastModifiedTime(System.currentTimeMillis());
            }
        }
    }
}

