/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lept4j.util;

import com.github.jaiimageio.plugins.tiff.TIFFImageWriteParam;
import com.ochafik.lang.jnaerator.runtime.NativeSize;
import com.ochafik.lang.jnaerator.runtime.NativeSizeByReference;
import com.sun.jna.ptr.PointerByReference;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import net.sourceforge.lept4j.Leptonica1;
import net.sourceforge.lept4j.Pix;

public class LeptUtils {
    static final String JAI_IMAGE_WRITER_MESSAGE = "Need to install JAI Image I/O package.\nhttps://java.net/projects/jai-imageio/";
    static final String TIFF_FORMAT = "tiff";
    static final float deg2rad = 0.017453277f;

    public static BufferedImage convertPixToImage(Pix pix) throws IOException {
        PointerByReference pdata = new PointerByReference();
        NativeSizeByReference psize = new NativeSizeByReference();
        int format = 4;
        Leptonica1.pixWriteMem(pdata, psize, pix, format);
        byte[] b = pdata.getValue().getByteArray(0L, psize.getValue().intValue());
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        BufferedImage bi = ImageIO.read(in);
        ((InputStream)in).close();
        return bi;
    }

    public static Pix convertImageToPix(BufferedImage image) throws IOException {
        ByteBuffer buff = LeptUtils.getImageByteBuffer(image);
        Pix pix = Leptonica1.pixReadMem(buff, new NativeSize(buff.capacity()));
        return pix;
    }

    public static Pix removeLines(Pix pixs) {
        Pix pix1 = Leptonica1.pixThresholdToBinary(pixs, 170);
        FloatBuffer pangle = FloatBuffer.allocate(1);
        FloatBuffer pconf = FloatBuffer.allocate(1);
        Leptonica1.pixFindSkew(pix1, pangle, pconf);
        float angle = pangle.get();
        float conf = pconf.get();
        Pix pix2 = Leptonica1.pixRotateAMGray(pixs, 0.017453277f * angle, (byte)-1);
        Pix pix3 = Leptonica1.pixCloseGray(pix2, 51, 1);
        Pix pix4 = Leptonica1.pixErodeGray(pix3, 1, 5);
        Pix pix5 = Leptonica1.pixThresholdToValue(null, pix4, 210, 255);
        Pix pix6 = Leptonica1.pixThresholdToValue(null, pix5, 200, 0);
        Pix pix7 = Leptonica1.pixThresholdToBinary(pix6, 210);
        Leptonica1.pixInvert(pix6, pix6);
        Pix pix8 = Leptonica1.pixAddGray(null, pix2, pix6);
        Pix pix9 = Leptonica1.pixOpenGray(pix8, 1, 9);
        Leptonica1.pixCombineMasked(pix8, pix9, pix7);
        LeptUtils.disposePix(pix1);
        LeptUtils.disposePix(pix2);
        LeptUtils.disposePix(pix3);
        LeptUtils.disposePix(pix4);
        LeptUtils.disposePix(pix5);
        LeptUtils.disposePix(pix6);
        LeptUtils.disposePix(pix7);
        LeptUtils.disposePix(pix9);
        return pix8;
    }

    public static void disposePix(Pix pix) {
        if (pix == null) {
            return;
        }
        PointerByReference pRef = new PointerByReference();
        pRef.setValue(pix.getPointer());
        Leptonica1.pixDestroy(pRef);
    }

    static ByteBuffer getImageByteBuffer(RenderedImage image) throws IOException {
        TIFFImageWriteParam tiffWriteParam = new TIFFImageWriteParam(Locale.US);
        tiffWriteParam.setCompressionMode(0);
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(TIFF_FORMAT);
        if (!writers.hasNext()) {
            throw new RuntimeException(JAI_IMAGE_WRITER_MESSAGE);
        }
        ImageWriter writer = writers.next();
        IIOMetadata streamMetadata = writer.getDefaultStreamMetadata((ImageWriteParam)tiffWriteParam);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageOutputStream ios = ImageIO.createImageOutputStream(outputStream);
        writer.setOutput(ios);
        writer.write(streamMetadata, new IIOImage(image, null, null), (ImageWriteParam)tiffWriteParam);
        writer.dispose();
        ios.seek(0L);
        byte[] b = new byte[(int)ios.length()];
        ios.read(b);
        ios.close();
        ByteBuffer buf = ByteBuffer.allocateDirect(b.length);
        buf.order(ByteOrder.nativeOrder());
        buf.put(b);
        buf.flip();
        return buf;
    }
}

