/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwmf.record;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndianInputStream;

public class HwmfBitmap16 {
    final boolean isPartial;
    int type;
    int width;
    int height;
    int widthBytes;
    int planes;
    int bitsPixel;

    public HwmfBitmap16() {
        this(false);
    }

    public HwmfBitmap16(boolean isPartial) {
        this.isPartial = isPartial;
    }

    public int init(LittleEndianInputStream leis) throws IOException {
        this.type = leis.readShort();
        this.width = leis.readShort();
        this.height = leis.readShort();
        this.widthBytes = leis.readShort();
        this.planes = leis.readUByte();
        this.bitsPixel = leis.readUByte();
        int size = 10;
        if (this.isPartial) {
            long skipSize = leis.skip(4L);
            assert (skipSize == 4L);
            skipSize = leis.skip(18L);
            assert (skipSize == 18L);
            size += 22;
        }
        int length = (this.width * this.bitsPixel + 15 >> 4 << 1) * this.height;
        byte[] buf = IOUtils.toByteArray((InputStream)leis, (int)length);
        return size;
    }

    public BufferedImage getImage() {
        return new BufferedImage(this.width, this.height, 6);
    }
}

