/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwmf.record;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.poi.hwmf.draw.HwmfDrawProperties;
import org.apache.poi.hwmf.draw.HwmfGraphics;
import org.apache.poi.hwmf.record.HwmfColorRef;
import org.apache.poi.hwmf.record.HwmfFont;
import org.apache.poi.hwmf.record.HwmfObjectTableEntry;
import org.apache.poi.hwmf.record.HwmfRecord;
import org.apache.poi.hwmf.record.HwmfRecordType;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndianInputStream;
import org.apache.poi.util.LocaleUtil;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class HwmfText {
    private static final POILogger logger = POILogFactory.getLogger(HwmfText.class);

    public static class WmfCreateFontIndirect
    implements HwmfRecord,
    HwmfObjectTableEntry {
        private HwmfFont font;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.createFontIndirect;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.font = new HwmfFont();
            return this.font.init(leis);
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.addObjectTableEntry(this);
        }

        @Override
        public void applyObject(HwmfGraphics ctx) {
            ctx.getProperties().setFont(this.font);
        }
    }

    public static class WmfSetTextAlign
    implements HwmfRecord {
        private static final BitField TA_NOUPDATECP = BitFieldFactory.getInstance((int)0);
        private static final BitField TA_LEFT = BitFieldFactory.getInstance((int)0);
        private static final BitField TA_TOP = BitFieldFactory.getInstance((int)0);
        private static final BitField TA_UPDATECP = BitFieldFactory.getInstance((int)1);
        private static final BitField TA_RIGHT = BitFieldFactory.getInstance((int)2);
        private static final BitField TA_CENTER = BitFieldFactory.getInstance((int)6);
        private static final BitField TA_BOTTOM = BitFieldFactory.getInstance((int)8);
        private static final BitField TA_BASELINE = BitFieldFactory.getInstance((int)24);
        private static final BitField TA_RTLREADING = BitFieldFactory.getInstance((int)256);
        private static final BitField VTA_TOP = BitFieldFactory.getInstance((int)0);
        private static final BitField VTA_RIGHT = BitFieldFactory.getInstance((int)0);
        private static final BitField VTA_BOTTOM = BitFieldFactory.getInstance((int)2);
        private static final BitField VTA_CENTER = BitFieldFactory.getInstance((int)6);
        private static final BitField VTA_LEFT = BitFieldFactory.getInstance((int)8);
        private static final BitField VTA_BASELINE = BitFieldFactory.getInstance((int)24);
        private int textAlignmentMode;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.setTextAlign;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.textAlignmentMode = leis.readUShort();
            return 2;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            HwmfDrawProperties props = ctx.getProperties();
            if (TA_CENTER.isSet(this.textAlignmentMode)) {
                props.setTextAlignLatin(HwmfTextAlignment.CENTER);
            } else if (TA_RIGHT.isSet(this.textAlignmentMode)) {
                props.setTextAlignLatin(HwmfTextAlignment.RIGHT);
            } else {
                props.setTextAlignLatin(HwmfTextAlignment.LEFT);
            }
            if (VTA_CENTER.isSet(this.textAlignmentMode)) {
                props.setTextAlignAsian(HwmfTextAlignment.CENTER);
            } else if (VTA_LEFT.isSet(this.textAlignmentMode)) {
                props.setTextAlignAsian(HwmfTextAlignment.LEFT);
            } else {
                props.setTextAlignAsian(HwmfTextAlignment.RIGHT);
            }
            if (TA_BASELINE.isSet(this.textAlignmentMode)) {
                props.setTextVAlignLatin(HwmfTextVerticalAlignment.BASELINE);
            } else if (TA_BOTTOM.isSet(this.textAlignmentMode)) {
                props.setTextVAlignLatin(HwmfTextVerticalAlignment.BOTTOM);
            } else {
                props.setTextVAlignLatin(HwmfTextVerticalAlignment.TOP);
            }
            if (VTA_BASELINE.isSet(this.textAlignmentMode)) {
                props.setTextVAlignAsian(HwmfTextVerticalAlignment.BASELINE);
            } else if (VTA_BOTTOM.isSet(this.textAlignmentMode)) {
                props.setTextVAlignAsian(HwmfTextVerticalAlignment.BOTTOM);
            } else {
                props.setTextVAlignAsian(HwmfTextVerticalAlignment.TOP);
            }
        }
    }

    public static enum HwmfTextVerticalAlignment {
        TOP,
        BOTTOM,
        BASELINE;

    }

    public static enum HwmfTextAlignment {
        LEFT,
        RIGHT,
        CENTER;

    }

    public static class WmfExtTextOut
    implements HwmfRecord {
        private static final BitField ETO_OPAQUE = BitFieldFactory.getInstance((int)2);
        private static final BitField ETO_CLIPPED = BitFieldFactory.getInstance((int)4);
        private static final BitField ETO_GLYPH_INDEX = BitFieldFactory.getInstance((int)16);
        private static final BitField ETO_RTLREADING = BitFieldFactory.getInstance((int)128);
        private static final BitField ETO_NUMERICSLOCAL = BitFieldFactory.getInstance((int)1024);
        private static final BitField ETO_NUMERICSLATIN = BitFieldFactory.getInstance((int)2048);
        private static final BitField ETO_PDY = BitFieldFactory.getInstance((int)8192);
        private int y;
        private int x;
        private int stringLength;
        private int fwOpts;
        private int left;
        private int top;
        private int right;
        private int bottom;
        private String text;
        private int[] dx;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.extTextOut;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            int remainingRecordSize = (int)(recordSize - 6L);
            this.y = leis.readShort();
            this.x = leis.readShort();
            this.stringLength = leis.readShort();
            this.fwOpts = leis.readUShort();
            int size = 8;
            if ((ETO_OPAQUE.isSet(this.fwOpts) || ETO_CLIPPED.isSet(this.fwOpts)) && size + 8 <= remainingRecordSize) {
                this.left = leis.readShort();
                this.top = leis.readShort();
                this.right = leis.readShort();
                this.bottom = leis.readShort();
                size += 8;
            }
            byte[] buf = new byte[this.stringLength + (this.stringLength & 1)];
            leis.readFully(buf);
            this.text = new String(buf, 0, this.stringLength, LocaleUtil.CHARSET_1252);
            if ((size += buf.length) >= remainingRecordSize) {
                logger.log(3, new Object[]{"META_EXTTEXTOUT doesn't contain character tracking info"});
                return size;
            }
            int dxLen = Math.min(this.stringLength, (remainingRecordSize - size) / 2);
            if (dxLen < this.stringLength) {
                logger.log(5, new Object[]{"META_EXTTEXTOUT tracking info doesn't cover all characters"});
            }
            this.dx = new int[this.stringLength];
            for (int i = 0; i < dxLen; ++i) {
                this.dx[i] = leis.readShort();
                size += 2;
            }
            return size;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            Rectangle2D.Double bounds = new Rectangle2D.Double(this.x, this.y, 0.0, 0.0);
            ctx.drawString(this.text, bounds, this.dx);
        }
    }

    public static class WmfTextOut
    implements HwmfRecord {
        private int stringLength;
        private String text;
        private int yStart;
        private int xStart;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.textOut;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.stringLength = leis.readShort();
            byte[] buf = new byte[this.stringLength + (this.stringLength & 1)];
            leis.readFully(buf);
            this.text = new String(buf, 0, this.stringLength, LocaleUtil.CHARSET_1252).trim();
            this.yStart = leis.readShort();
            this.xStart = leis.readShort();
            return 6 + buf.length;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            Rectangle2D.Double bounds = new Rectangle2D.Double(this.xStart, this.yStart, 0.0, 0.0);
            ctx.drawString(this.text, bounds);
        }
    }

    public static class WmfSetTextJustification
    implements HwmfRecord {
        private int breakCount;
        private int breakExtra;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.setBkColor;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.breakCount = leis.readUShort();
            this.breakExtra = leis.readUShort();
            return 4;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
        }
    }

    public static class WmfSetTextColor
    implements HwmfRecord {
        private HwmfColorRef colorRef;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.setTextColor;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.colorRef = new HwmfColorRef();
            return this.colorRef.init(leis);
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.getProperties().setTextColor(this.colorRef);
        }
    }

    public static class WmfSetTextCharExtra
    implements HwmfRecord {
        private int charExtra;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.setTextCharExtra;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.charExtra = leis.readUShort();
            return 2;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
        }
    }
}

