/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import opennlp.model.Event;
import opennlp.tools.postag.DefaultPOSContextGenerator;
import opennlp.tools.postag.POSContextGenerator;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.AbstractEventStream;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POSSampleEventStream
extends AbstractEventStream<POSSample> {
    private POSContextGenerator cg;

    public POSSampleEventStream(ObjectStream<POSSample> samples, POSContextGenerator cg) {
        super(samples);
        this.cg = cg;
    }

    public POSSampleEventStream(ObjectStream<POSSample> samples) {
        this(samples, new DefaultPOSContextGenerator(null));
    }

    @Override
    protected Iterator<Event> createEvents(POSSample sample) {
        String[] sentence = sample.getSentence();
        String[] tags = sample.getTags();
        String[][] ac = sample.getAddictionalContext();
        List<Event> events = POSSampleEventStream.generateEvents(sentence, tags, (Object[])ac, this.cg);
        return events.iterator();
    }

    public static List<Event> generateEvents(String[] sentence, String[] tags, Object[] additionalContext, POSContextGenerator cg) {
        ArrayList<Event> events = new ArrayList<Event>(sentence.length);
        for (int i = 0; i < sentence.length; ++i) {
            String[] context = cg.getContext(i, sentence, tags, additionalContext);
            events.add(new Event(tags[i], context));
        }
        return events;
    }

    public static List<Event> generateEvents(String[] sentence, String[] tags, POSContextGenerator cg) {
        return POSSampleEventStream.generateEvents(sentence, tags, null, cg);
    }
}

