/*
 * Decompiled with CFR 0.152.
 */
package gnu.cajo.utils.extra;

import gnu.cajo.invoke.Remote;
import gnu.cajo.invoke.RemoteInvoke;
import gnu.cajo.utils.ItemServer;
import gnu.cajo.utils.Multicast;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.util.Enumeration;
import java.util.Hashtable;

public final class Registry {
    private final Hashtable entries = new Hashtable();

    public void multicast(Multicast multicast) {
        this.entries.put(multicast.iaddr.getHostAddress(), multicast.item);
    }

    public void post(RemoteInvoke ref) throws ServerNotActiveException {
        this.entries.put(RemoteServer.getClientHost(), ref);
    }

    public Hashtable get() {
        return this.entries;
    }

    public String getDescription() {
        return "Welcome to the cajo item registry!\n\nThere are two ways to register a remote item reference:\n\n\tFirst, Multicast hailing frequency announcements are\n\tautomatically registered.\n\n\tSecond, invocations of the 'post' method, with a remote\n\treference are also registered.\n\nAll currently registered references can be requested via the\n'get' method. It takes no arguments, and returns a\njava.util.Hashtable containing the registered remote item\nreferences, keyed by their server addresses. Additionally, it\nautomatically purges inactive references periodically.\n\nEnjoy!";
    }

    public static void main(String[] args) {
        try {
            Remote.config(null, 1099, args.length > 0 ? args[0] : null, 0);
            Registry registry = new Registry();
            Remote ref = new Remote(registry);
            Multicast multicast = new Multicast();
            ItemServer.bind(ref, "registry");
            multicast.listen(registry);
            Thread.currentThread().setPriority(1);
            block4: while (true) {
                multicast.announce(ref, 200);
                Thread.sleep(3600000L);
                Enumeration keys = registry.entries.keys();
                while (true) {
                    if (!keys.hasMoreElements()) continue block4;
                    Object key = keys.nextElement();
                    Object o = registry.entries.get(key);
                    try {
                        Remote.invoke(o, "toString", null);
                    }
                    catch (Exception x) {
                        registry.entries.remove(key);
                    }
                }
                break;
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            return;
        }
    }
}

