/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks.ttml;

import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.authoring.tracks.ttml.TtmlHelpers;
import com.mp4parser.iso14496.part30.XMLSubtitleSampleEntry;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TtmlTrackImpl
extends AbstractTrack {
    TrackMetaData trackMetaData = new TrackMetaData();
    SampleDescriptionBox sampleDescriptionBox = new SampleDescriptionBox();
    XMLSubtitleSampleEntry xmlSubtitleSampleEntry = new XMLSubtitleSampleEntry();
    List<Sample> samples = new ArrayList<Sample>();
    SubSampleInformationBox subSampleInformationBox = new SubSampleInformationBox();
    private long[] sampleDurations;

    public TtmlTrackImpl(String name, List<Document> ttmls) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException, URISyntaxException {
        super(name);
        this.extractLanguage(ttmls);
        HashSet<String> mimeTypes = new HashSet<String>();
        this.sampleDurations = new long[ttmls.size()];
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        xpath.setNamespaceContext(TtmlHelpers.NAMESPACE_CONTEXT);
        int sampleNo = 0;
        while (sampleNo < ttmls.size()) {
            Document ttml = ttmls.get(sampleNo);
            SubSampleInformationBox.SubSampleEntry subSampleEntry = new SubSampleInformationBox.SubSampleEntry();
            this.subSampleInformationBox.getEntries().add(subSampleEntry);
            subSampleEntry.setSampleDelta(1L);
            this.sampleDurations[sampleNo] = this.extractDuration(ttml);
            List<byte[]> images = TtmlTrackImpl.extractImages(ttml);
            mimeTypes.addAll(this.extractMimeTypes(ttml));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            TtmlHelpers.pretty(ttml, baos, 4);
            SubSampleInformationBox.SubSampleEntry.SubsampleEntry xmlEntry = new SubSampleInformationBox.SubSampleEntry.SubsampleEntry();
            xmlEntry.setSubsampleSize(baos.size());
            subSampleEntry.getSubsampleEntries().add(xmlEntry);
            for (byte[] image : images) {
                baos.write(image);
                SubSampleInformationBox.SubSampleEntry.SubsampleEntry imageEntry = new SubSampleInformationBox.SubSampleEntry.SubsampleEntry();
                imageEntry.setSubsampleSize(image.length);
                subSampleEntry.getSubsampleEntries().add(imageEntry);
            }
            final byte[] finalSample = baos.toByteArray();
            this.samples.add(new Sample(){

                public void writeTo(WritableByteChannel channel) throws IOException {
                    channel.write(ByteBuffer.wrap(finalSample));
                }

                public long getSize() {
                    return finalSample.length;
                }

                public ByteBuffer asByteBuffer() {
                    return ByteBuffer.wrap(finalSample);
                }
            });
            ++sampleNo;
        }
        this.xmlSubtitleSampleEntry.setNamespace(TtmlTrackImpl.join(",", TtmlHelpers.getAllNamespaces(ttmls.get(0))));
        this.xmlSubtitleSampleEntry.setSchemaLocation("");
        this.xmlSubtitleSampleEntry.setAuxiliaryMimeTypes(TtmlTrackImpl.join(",", new ArrayList(mimeTypes).toArray(new String[mimeTypes.size()])));
        this.sampleDescriptionBox.addBox(this.xmlSubtitleSampleEntry);
        this.trackMetaData.setTimescale(30000L);
        this.trackMetaData.setLayer(65535);
    }

    public static String getLanguage(Document document) {
        return document.getDocumentElement().getAttribute("xml:lang");
    }

    protected static List<byte[]> extractImages(Document ttml) throws XPathExpressionException, URISyntaxException, IOException {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        XPathExpression expr = xpath.compile("//*/@backgroundImage");
        NodeList nl = (NodeList)expr.evaluate(ttml, XPathConstants.NODESET);
        LinkedHashMap<String, String> internalNames2Original = new LinkedHashMap<String, String>();
        int p = 1;
        int i = 0;
        while (i < nl.getLength()) {
            Node bgImageNode = nl.item(i);
            String uri = bgImageNode.getNodeValue();
            String ext = uri.substring(uri.lastIndexOf("."));
            String internalName = (String)internalNames2Original.get(uri);
            if (internalName == null) {
                internalName = "urn:mp4parser:" + p++ + ext;
                internalNames2Original.put(internalName, uri);
            }
            bgImageNode.setNodeValue(internalName);
            ++i;
        }
        ArrayList<byte[]> images = new ArrayList<byte[]>();
        if (!internalNames2Original.isEmpty()) {
            for (Map.Entry internalName2Original : internalNames2Original.entrySet()) {
                URI pic = new URI(ttml.getDocumentURI()).resolve((String)internalName2Original.getValue());
                images.add(TtmlTrackImpl.streamToByteArray(pic.toURL().openStream()));
            }
        }
        return images;
    }

    private static String join(String joiner, String[] i) {
        StringBuilder result = new StringBuilder();
        String[] stringArray = i;
        int n = i.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            result.append(s).append(joiner);
            ++n2;
        }
        result.setLength(result.length() > 0 ? result.length() - 1 : 0);
        return result.toString();
    }

    private static long latestTimestamp(Document document) {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        xpath.setNamespaceContext(TtmlHelpers.NAMESPACE_CONTEXT);
        try {
            XPathExpression xp = xpath.compile("//*[name()='p']");
            NodeList timedNodes = (NodeList)xp.evaluate(document, XPathConstants.NODESET);
            long lastTimeStamp = 0L;
            int i = 0;
            while (i < timedNodes.getLength()) {
                lastTimeStamp = Math.max(TtmlHelpers.getEndTime(timedNodes.item(i)), lastTimeStamp);
                ++i;
            }
            return lastTimeStamp;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] streamToByteArray(InputStream input) throws IOException {
        byte[] buffer = new byte[8096];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    protected long firstTimestamp(Document document) {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        xpath.setNamespaceContext(TtmlHelpers.NAMESPACE_CONTEXT);
        try {
            XPathExpression xp = xpath.compile("//*[@begin]");
            NodeList timedNodes = (NodeList)xp.evaluate(document, XPathConstants.NODESET);
            long firstTimestamp = Long.MAX_VALUE;
            int i = 0;
            while (i < timedNodes.getLength()) {
                firstTimestamp = Math.min(TtmlHelpers.getStartTime(timedNodes.item(i)), firstTimestamp);
                ++i;
            }
            return firstTimestamp;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    protected long lastTimestamp(Document document) {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        xpath.setNamespaceContext(TtmlHelpers.NAMESPACE_CONTEXT);
        try {
            XPathExpression xp = xpath.compile("//*[@end]");
            NodeList timedNodes = (NodeList)xp.evaluate(document, XPathConstants.NODESET);
            long lastTimeStamp = 0L;
            int i = 0;
            while (i < timedNodes.getLength()) {
                lastTimeStamp = Math.max(TtmlHelpers.getEndTime(timedNodes.item(i)), lastTimeStamp);
                ++i;
            }
            return lastTimeStamp;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    protected void extractLanguage(List<Document> ttmls) {
        String firstLang = null;
        for (Document ttml : ttmls) {
            String lang = TtmlTrackImpl.getLanguage(ttml);
            if (firstLang == null) {
                firstLang = lang;
                this.trackMetaData.setLanguage(Locale.forLanguageTag(lang).getISO3Language());
                continue;
            }
            if (firstLang.equals(lang)) continue;
            throw new RuntimeException("Within one Track all sample documents need to have the same language");
        }
    }

    protected List<String> extractMimeTypes(Document ttml) throws XPathExpressionException {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        XPathExpression expr = xpath.compile("//*/@smpte:backgroundImage");
        NodeList nl = (NodeList)expr.evaluate(ttml, XPathConstants.NODESET);
        LinkedHashSet<String> mimeTypes = new LinkedHashSet<String>();
        int i = 0;
        while (i < nl.getLength()) {
            Node bgImageNode = nl.item(i);
            String uri = bgImageNode.getNodeValue();
            String ext = uri.substring(uri.lastIndexOf("."));
            if (ext.contains("jpg") || ext.contains("jpeg")) {
                mimeTypes.add("image/jpeg");
            } else if (ext.contains("png")) {
                mimeTypes.add("image/png");
            }
            ++i;
        }
        return new ArrayList<String>(mimeTypes);
    }

    long extractDuration(Document ttml) {
        return this.lastTimestamp(ttml) - this.firstTimestamp(ttml);
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.sampleDescriptionBox;
    }

    @Override
    public long[] getSampleDurations() {
        long[] adoptedSampleDuration = new long[this.sampleDurations.length];
        int i = 0;
        while (i < adoptedSampleDuration.length) {
            adoptedSampleDuration[i] = this.sampleDurations[i] * this.trackMetaData.getTimescale() / 1000L;
            ++i;
        }
        return adoptedSampleDuration;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    @Override
    public String getHandler() {
        return "subt";
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return this.subSampleInformationBox;
    }

    @Override
    public void close() throws IOException {
    }
}

