/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.io.Serializable;
import java.util.Formattable;
import java.util.Formatter;
import javax.measure.unit.Unit;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.util.Utilities;
import org.apache.sis.measure.RangeFormat;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Emptiable;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.collection.CheckedContainer;

public class Range<E extends Comparable<? super E>>
implements CheckedContainer<E>,
Formattable,
Emptiable,
Serializable {
    private static final long serialVersionUID = 603508245068333284L;
    final Class<E> elementType;
    final E minValue;
    final E maxValue;
    final boolean isMinIncluded;
    final boolean isMaxIncluded;

    public Range(Range<E> range) {
        this.elementType = range.elementType;
        this.minValue = range.minValue;
        this.isMinIncluded = range.isMinIncluded;
        this.maxValue = range.maxValue;
        this.isMaxIncluded = range.isMaxIncluded;
        assert (this.validate()) : this.elementType;
    }

    public Range(Class<E> clazz, E e, boolean bl, E e2, boolean bl2) {
        ArgumentChecks.ensureNonNull("elementType", clazz);
        this.elementType = clazz;
        this.minValue = e;
        this.isMinIncluded = bl && e != null;
        this.maxValue = e2;
        boolean bl3 = this.isMaxIncluded = bl2 && e2 != null;
        assert (this.validate()) : clazz;
    }

    Range<E> create(E e, boolean bl, E e2, boolean bl2) {
        return new Range<E>(this.elementType, e, bl, e2, bl2);
    }

    Range<E>[] newArray(int n) {
        return new Range[n];
    }

    Unit<?> unit() {
        return null;
    }

    private boolean validate() {
        ArgumentChecks.ensureCanCast("minValue", this.elementType, this.minValue);
        ArgumentChecks.ensureCanCast("maxValue", this.elementType, this.maxValue);
        return Comparable.class.isAssignableFrom(this.elementType);
    }

    @Override
    public Class<E> getElementType() {
        return this.elementType;
    }

    public E getMinValue() {
        return this.minValue;
    }

    public boolean isMinIncluded() {
        return this.isMinIncluded;
    }

    public E getMaxValue() {
        return this.maxValue;
    }

    public boolean isMaxIncluded() {
        return this.isMaxIncluded;
    }

    @Override
    public final boolean isEmpty() {
        if (this.minValue == null || this.maxValue == null) {
            return false;
        }
        int n = this.minValue.compareTo(this.maxValue);
        if (n < 0) {
            return false;
        }
        return n != 0 || !this.isMinIncluded || !this.isMaxIncluded;
    }

    public boolean contains(E e) {
        int n;
        if (e == null) {
            return false;
        }
        if (this.minValue != null) {
            n = this.minValue.compareTo(e);
            if (this.isMinIncluded ? n > 0 : n >= 0) {
                return false;
            }
        }
        if (this.maxValue != null) {
            n = this.maxValue.compareTo(e);
            if (this.isMaxIncluded ? n < 0 : n <= 0) {
                return false;
            }
        }
        return true;
    }

    public boolean contains(Range<? extends E> range) {
        return this.compareMinTo(range.minValue, range.isMinIncluded ? 0 : -1) <= 0 && this.compareMaxTo(range.maxValue, range.isMaxIncluded ? 0 : 1) >= 0;
    }

    public boolean intersects(Range<? extends E> range) {
        return this.compareMinTo(range.maxValue, range.isMaxIncluded ? 0 : 1) <= 0 && this.compareMaxTo(range.minValue, range.isMinIncluded ? 0 : -1) >= 0;
    }

    public Range<E> intersect(Range<E> range) {
        Range<E> range2 = this.compareMinTo(range.minValue, range.isMinIncluded ? 0 : -1) < 0 ? range : this;
        Range<E> range3 = this.compareMaxTo(range.maxValue, range.isMaxIncluded ? 0 : 1) > 0 ? range : this;
        Range<E> range4 = range2 == range3 ? range2 : this.create(range2.minValue, range2.isMinIncluded, range3.maxValue, range3.isMaxIncluded);
        assert (range4.isEmpty() == !this.intersects(range)) : range4;
        return range4;
    }

    public Range<E> union(Range<E> range) {
        Range<E> range2 = this.compareMinTo(range.minValue, range.isMinIncluded ? 0 : -1) > 0 ? range : this;
        Range<E> range3 = this.compareMaxTo(range.maxValue, range.isMaxIncluded ? 0 : 1) < 0 ? range : this;
        Range<E> range4 = range2 == range3 ? range2 : this.create(range2.minValue, range2.isMinIncluded, range3.maxValue, range3.isMaxIncluded);
        assert (range4.contains(range2)) : range2;
        assert (range4.contains(range3)) : range3;
        return range4;
    }

    public Range<E>[] subtract(Range<E> range) {
        Range<E> range2;
        if (!this.intersects(range)) {
            range2 = this;
        } else {
            boolean bl;
            boolean bl2 = this.compareMinTo(range.minValue, range.isMinIncluded ? 0 : -1) >= 0;
            boolean bl3 = bl = this.compareMaxTo(range.maxValue, range.isMaxIncluded ? 0 : 1) <= 0;
            if (bl2) {
                if (bl) {
                    assert (range.contains(this)) : range;
                    return this.newArray(0);
                }
                range2 = this.create(range.maxValue, !range.isMaxIncluded, this.maxValue, this.isMaxIncluded);
            } else {
                if (!bl) {
                    Range<E>[] rangeArray = this.newArray(2);
                    rangeArray[0] = this.create(this.minValue, this.isMinIncluded, range.minValue, !range.isMinIncluded);
                    rangeArray[1] = this.create(range.maxValue, !range.isMaxIncluded, this.maxValue, this.isMaxIncluded);
                    return rangeArray;
                }
                range2 = this.create(this.minValue, this.isMinIncluded, range.minValue, !range.isMinIncluded);
            }
        }
        assert (this.contains(range2)) : range2;
        assert (!range2.intersects(range)) : range2;
        Range<E>[] rangeArray = this.newArray(1);
        rangeArray[0] = range2;
        return rangeArray;
    }

    private int compareMinTo(E e, int n) {
        if (this.minValue == null) {
            return e == null ? 0 : -1;
        }
        if (e == null) {
            return -n;
        }
        int n2 = this.minValue.compareTo(e);
        if (n2 != 0) {
            return n2;
        }
        if (!this.isMinIncluded) {
            ++n;
        }
        return n;
    }

    private int compareMaxTo(E e, int n) {
        if (this.maxValue == null) {
            return e == null ? 0 : 1;
        }
        if (e == null) {
            return -n;
        }
        int n2 = this.maxValue.compareTo(e);
        if (n2 != 0) {
            return n2;
        }
        if (!this.isMaxIncluded) {
            --n;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            Range range = (Range)object;
            if (Objects.equals(this.elementType, range.elementType)) {
                if (this.isEmpty()) {
                    return range.isEmpty();
                }
                return Objects.equals(this.minValue, range.minValue) && Objects.equals(this.maxValue, range.maxValue) && this.isMinIncluded == range.isMinIncluded && this.isMaxIncluded == range.isMaxIncluded;
            }
        }
        return false;
    }

    public int hashCode() {
        int n = this.elementType.hashCode();
        if (!this.isEmpty()) {
            n = 13 * n + Objects.hashCode(this.minValue);
            n = 13 * n + Objects.hashCode(this.maxValue);
            n += this.isMinIncluded ? 17 : 37;
            n += this.isMaxIncluded ? 1231 : 1237;
        }
        return n ^ 0x265140E4;
    }

    private static boolean isCompact(Comparable<?> comparable, boolean bl) {
        if (comparable == null) {
            return bl;
        }
        long l = ((Number)((Object)comparable)).longValue();
        return l >= 0L && l < 10L;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(20);
        if (this.minValue != null && this.minValue.equals(this.maxValue)) {
            stringBuilder.append('{').append(this.minValue).append('}');
        } else {
            stringBuilder.append(this.isMinIncluded ? (char)'[' : '(');
            if (this.minValue == null) {
                stringBuilder.append("\u2212\u221e");
            } else {
                stringBuilder.append(this.minValue);
            }
            if (Numbers.isInteger(this.elementType) && Range.isCompact(this.minValue, false) && Range.isCompact(this.maxValue, true)) {
                stringBuilder.append('\u2026');
            } else {
                stringBuilder.append(" \u2026 ");
            }
            if (this.maxValue == null) {
                stringBuilder.append('\u221e');
            } else {
                stringBuilder.append(this.maxValue);
            }
            stringBuilder.append(this.isMaxIncluded ? (char)']' : ')');
        }
        Unit<?> unit = this.unit();
        if (unit != null) {
            stringBuilder.append(' ').append(unit);
        }
        return stringBuilder.toString();
    }

    @Override
    public void formatTo(Formatter formatter, int n, int n2, int n3) {
        String string;
        if (n3 == 0) {
            string = "";
        } else {
            RangeFormat rangeFormat = new RangeFormat(formatter.locale(), this.elementType);
            rangeFormat.setAlternateForm((n & 4) != 0);
            string = rangeFormat.format(this, new StringBuffer(), null).toString();
        }
        Utilities.formatTo(formatter, n, n2, n3, string);
    }
}

