/*
 * Decompiled with CFR 0.152.
 */
package gnu.cajo.utils.extra;

import gnu.cajo.invoke.Remote;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class Scheduler
implements Serializable {
    private static final String INDEX_INVALID = "task table index invalid";
    private transient Thread thread;
    private int syncFlags;
    private int soonFlags;
    private int wakeFlags;
    private Object[] list = new Object[32];
    private final Runnable kernel = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int next = 0;
                while (!Scheduler.this.thread.isInterrupted()) {
                    int slot = 0;
                    Scheduler scheduler = Scheduler.this;
                    synchronized (scheduler) {
                        int mask;
                        if (Scheduler.this.syncFlags != 0) {
                            mask = 1;
                            while ((Scheduler.this.syncFlags & mask) == 0) {
                                ++slot;
                                mask <<= 1;
                            }
                            Scheduler.this.syncFlags ^= mask;
                        } else if (Scheduler.this.soonFlags != 0) {
                            mask = 1;
                            while ((Scheduler.this.soonFlags & mask) == 0) {
                                ++slot;
                                mask <<= 1;
                            }
                            Scheduler.this.soonFlags ^= mask;
                        } else if (Scheduler.this.wakeFlags != 0) {
                            for (int i = 0; i < 32; ++i) {
                                if (++next == 32) {
                                    next = 0;
                                }
                                if ((1 << next & Scheduler.this.wakeFlags) == 0) continue;
                                slot = next;
                                break;
                            }
                        } else {
                            Scheduler.this.wait();
                            continue;
                        }
                    }
                    try {
                        Remote.invoke(Scheduler.this.list[slot], "slice", null);
                    }
                    catch (Exception x) {
                        Scheduler.this.drop(slot);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setEnabled(true);
    }

    public synchronized boolean setEnabled(boolean enabled) {
        if (enabled) {
            if (this.syncFlags != 0 | this.soonFlags != 0 | this.wakeFlags != 0) {
                if (this.thread == null) {
                    this.thread = new Thread(this.kernel);
                    this.thread.start();
                    return true;
                }
                this.notify();
            }
        } else if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
            return true;
        }
        return false;
    }

    public synchronized int load(Object task) {
        for (int slot = 0; slot < 32; ++slot) {
            if (this.list[slot] != null) continue;
            this.list[slot] = task;
            return slot;
        }
        throw new IllegalArgumentException("task table currently full");
    }

    public synchronized boolean sync(int task) {
        if (task >= 0 && task < 32) {
            int mask = 1 << task;
            if ((this.syncFlags & mask) == 0) {
                this.syncFlags |= mask;
                this.setEnabled(true);
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException(INDEX_INVALID);
    }

    public synchronized boolean soon(int task) {
        if (task >= 0 && task < 32) {
            int mask = 1 << task;
            if ((this.soonFlags & mask) == 0) {
                this.soonFlags |= mask;
                this.setEnabled(true);
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException(INDEX_INVALID);
    }

    public synchronized boolean wake(int task) {
        if (task >= 0 && task < 32) {
            int mask = 1 << task;
            if ((this.wakeFlags & mask) == 0) {
                this.wakeFlags |= mask;
                this.setEnabled(true);
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException(INDEX_INVALID);
    }

    public synchronized void stop(int task) {
        if (task >= 0 && task < 32) {
            int mask = ~(1 << task);
            this.syncFlags &= mask;
            this.soonFlags &= mask;
            this.wakeFlags &= mask;
        } else {
            throw new IllegalArgumentException(INDEX_INVALID);
        }
    }

    public synchronized void drop(int task) {
        if (task < 0 || task >= 32) {
            throw new IllegalArgumentException(INDEX_INVALID);
        }
        this.stop(task);
        this.list[task] = null;
    }

    public boolean pending() {
        return this.syncFlags != 0 | this.soonFlags != 0;
    }
}

