/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tess4j.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import net.sourceforge.tess4j.util.ImageIOHelper;
import net.sourceforge.tess4j.util.LoadLibs;
import net.sourceforge.tess4j.util.LoggHelper;
import org.ghost4j.Ghostscript;
import org.ghost4j.GhostscriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfUtilities {
    public static final String GS_INSTALL = "\nPlease download, install GPL Ghostscript from http://www.ghostscript.com\nand/or set the appropriate environment variable.";
    private static final Logger logger = LoggerFactory.getLogger((String)new LoggHelper().toString());
    private static final String PS_FILE = "lib/pdfpagecount.ps";
    private static final String pdfPageCountFilePath;

    public static File convertPdf2Tiff(File file) throws IOException {
        File[] fileArray = null;
        try {
            fileArray = PdfUtilities.convertPdf2Png(file);
            File file2 = File.createTempFile("multipage", ".tif");
            ImageIOHelper.mergeTiff(fileArray, file2);
            File file3 = file2;
            return file3;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new RuntimeException(PdfUtilities.getMessage(unsatisfiedLinkError.getMessage()));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new RuntimeException(PdfUtilities.getMessage(noClassDefFoundError.getMessage()));
        }
        finally {
            if (fileArray != null) {
                for (File file4 : fileArray) {
                    file4.delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File[] convertPdf2Png(File file) {
        File[] fileArray;
        Object object;
        File file2 = file.getParentFile();
        if (file2 == null) {
            object = System.getProperty("user.dir");
            file2 = new File((String)object);
        }
        object = Ghostscript.getInstance();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-gs");
        arrayList.add("-dNOPAUSE");
        arrayList.add("-dQUIET");
        arrayList.add("-dBATCH");
        arrayList.add("-dSAFER");
        arrayList.add("-sDEVICE=pnggray");
        arrayList.add("-r300");
        arrayList.add("-dGraphicsAlphaBits=4");
        arrayList.add("-dTextAlphaBits=4");
        arrayList.add("-sOutputFile=" + file2.getPath() + "/workingimage%03d.png");
        arrayList.add(file.getPath());
        try {
            fileArray = object;
            synchronized (fileArray) {
                object.initialize(arrayList.toArray(new String[0]));
                object.exit();
            }
        }
        catch (GhostscriptException ghostscriptException) {
            logger.error(ghostscriptException.getCause() != null ? ghostscriptException.getCause().toString() : ghostscriptException.getMessage(), (Throwable)ghostscriptException);
        }
        finally {
            try {
                Ghostscript.deleteInstance();
            }
            catch (GhostscriptException ghostscriptException) {}
        }
        fileArray = file2.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.toLowerCase().matches("workingimage\\d{3}\\.png$");
            }
        });
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                return file.getName().compareTo(file2.getName());
            }
        });
        return fileArray;
    }

    public static void splitPdf(String string, String string2, String string3, String string4) {
        if (string3.trim().isEmpty()) {
            string3 = "0";
        }
        if (string4.trim().isEmpty()) {
            string4 = "0";
        }
        PdfUtilities.splitPdf(new File(string), new File(string2), Integer.parseInt(string3), Integer.parseInt(string4));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splitPdf(File file, File file2, int n, int n2) {
        Ghostscript ghostscript = Ghostscript.getInstance();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-gs");
        arrayList.add("-dNOPAUSE");
        arrayList.add("-dQUIET");
        arrayList.add("-dBATCH");
        arrayList.add("-sDEVICE=pdfwrite");
        if (n > 0) {
            arrayList.add("-dFirstPage=" + n);
        }
        if (n2 > 0) {
            arrayList.add("-dLastPage=" + n2);
        }
        arrayList.add("-sOutputFile=" + file2.getPath());
        arrayList.add(file.getPath());
        try {
            Ghostscript ghostscript2 = ghostscript;
            synchronized (ghostscript2) {
                ghostscript.initialize(arrayList.toArray(new String[0]));
                ghostscript.exit();
            }
        }
        catch (GhostscriptException ghostscriptException) {
            logger.error(ghostscriptException.getCause() != null ? ghostscriptException.getCause().toString() : ghostscriptException.getMessage(), (Throwable)ghostscriptException);
            throw new RuntimeException(ghostscriptException.getMessage());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new RuntimeException(PdfUtilities.getMessage(unsatisfiedLinkError.getMessage()));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new RuntimeException(PdfUtilities.getMessage(noClassDefFoundError.getMessage()));
        }
        finally {
            try {
                Ghostscript.deleteInstance();
            }
            catch (GhostscriptException ghostscriptException) {}
        }
    }

    public static int getPdfPageCount(String string) {
        return PdfUtilities.getPdfPageCount(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPdfPageCount(File file) {
        Ghostscript ghostscript = Ghostscript.getInstance();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-gs");
        arrayList.add("-dNOPAUSE");
        arrayList.add("-dQUIET");
        arrayList.add("-dBATCH");
        arrayList.add("-sPDFname=" + file.getPath());
        arrayList.add(pdfPageCountFilePath);
        int n = 0;
        try {
            Ghostscript ghostscript2 = ghostscript;
            synchronized (ghostscript2) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ghostscript.setStdOut((OutputStream)byteArrayOutputStream);
                ghostscript.initialize(arrayList.toArray(new String[0]));
                n = Integer.parseInt(byteArrayOutputStream.toString().replace("%%Pages: ", ""));
                byteArrayOutputStream.close();
            }
        }
        catch (GhostscriptException ghostscriptException) {
            logger.error(ghostscriptException.getCause() != null ? ghostscriptException.getCause().toString() : ghostscriptException.getMessage(), (Throwable)ghostscriptException);
        }
        catch (Exception exception) {
            logger.error(exception.getCause() != null ? exception.getCause().toString() : exception.getMessage(), (Throwable)exception);
        }
        finally {
            try {
                Ghostscript.deleteInstance();
            }
            catch (GhostscriptException ghostscriptException) {}
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergePdf(File[] ghostscript, File file) {
        Ghostscript ghostscript2 = Ghostscript.getInstance();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-gs");
        arrayList.add("-dNOPAUSE");
        arrayList.add("-dQUIET");
        arrayList.add("-dBATCH");
        arrayList.add("-sDEVICE=pdfwrite");
        arrayList.add("-sOutputFile=" + file.getPath());
        for (File file2 : ghostscript) {
            arrayList.add(file2.getPath());
        }
        try {
            Ghostscript ghostscript3 = ghostscript2;
            synchronized (ghostscript3) {
                ghostscript2.initialize(arrayList.toArray(new String[0]));
                ghostscript2.exit();
            }
        }
        catch (GhostscriptException ghostscriptException) {
            logger.error(ghostscriptException.getCause() != null ? ghostscriptException.getCause().toString() : ghostscriptException.getMessage(), (Throwable)ghostscriptException);
            throw new RuntimeException(ghostscriptException.getMessage());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new RuntimeException(PdfUtilities.getMessage(unsatisfiedLinkError.getMessage()));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new RuntimeException(PdfUtilities.getMessage(noClassDefFoundError.getMessage()));
        }
        finally {
            try {
                Ghostscript.deleteInstance();
            }
            catch (GhostscriptException ghostscriptException) {}
        }
    }

    static String getMessage(String string) {
        if (string.contains("library 'gs") || string.contains("ghost4j")) {
            return string + GS_INSTALL;
        }
        return string;
    }

    static {
        File file = LoadLibs.extractTessResources(PS_FILE);
        pdfPageCountFilePath = file != null && file.exists() ? file.getPath() : PS_FILE;
    }
}

