/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.DecoderUtil;
import org.apache.poi.hmef.attribute.MAPIRtfAttribute;
import org.apache.poi.hsmf.MAPIMessage;
import org.apache.poi.hsmf.datatypes.AttachmentChunks;
import org.apache.poi.hsmf.datatypes.ByteChunk;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.Chunks;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.hsmf.datatypes.PropertyValue;
import org.apache.poi.hsmf.datatypes.RecipientChunks;
import org.apache.poi.hsmf.datatypes.StringChunk;
import org.apache.poi.hsmf.datatypes.Types;
import org.apache.poi.hsmf.exceptions.ChunkNotFoundException;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.util.CodePageUtil;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Message;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.html.HtmlEncodingDetector;
import org.apache.tika.parser.html.HtmlParser;
import org.apache.tika.parser.mbox.MboxParser;
import org.apache.tika.parser.microsoft.AbstractPOIFSExtractor;
import org.apache.tika.parser.rtf.RTFParser;
import org.apache.tika.parser.txt.CharsetDetector;
import org.apache.tika.parser.txt.CharsetMatch;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class OutlookExtractor
extends AbstractPOIFSExtractor {
    private static Pattern HEADER_KEY_PAT = Pattern.compile("\\A([\\x21-\\x39\\x3B-\\x7E]+):(.*?)\\Z");
    private static final Metadata EMPTY_METADATA = new Metadata();
    HtmlEncodingDetector detector = new HtmlEncodingDetector();
    private final MAPIMessage msg;
    private final ParseContext parseContext;

    public OutlookExtractor(NPOIFSFileSystem filesystem, ParseContext context) throws TikaException {
        this(filesystem.getRoot(), context);
    }

    public OutlookExtractor(DirectoryNode root, ParseContext context) throws TikaException {
        super(context);
        this.parseContext = context;
        try {
            this.msg = new MAPIMessage(root);
        }
        catch (IOException e) {
            throw new TikaException("Failed to parse Outlook message", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void parse(XHTMLContentHandler xhtml, Metadata metadata) throws TikaException, SAXException, IOException {
        try {
            boolean bl;
            void var7_15;
            boolean bl2;
            this.msg.setReturnNullOnMissingChunk(true);
            try {
                metadata.set(Office.MAPI_MESSAGE_CLASS, OutlookExtractor.getMessageClass(this.msg.getMessageClass()));
            }
            catch (ChunkNotFoundException chunkNotFoundException) {
                // empty catch block
            }
            if (this.msg.has7BitEncodingStrings()) {
                this.guess7BitEncoding(this.msg);
            }
            String subject = this.msg.getSubject();
            Map<String, String[]> headers = this.normalizeHeaders(this.msg.getHeaders());
            String from = this.msg.getDisplayFrom();
            this.handleFromTo(headers, metadata);
            metadata.set(TikaCoreProperties.TITLE, subject);
            metadata.set(TikaCoreProperties.TRANSITION_SUBJECT_TO_DC_DESCRIPTION, this.msg.getConversationTopic());
            try {
                for (String string : this.msg.getRecipientEmailAddressList()) {
                    if (string == null) continue;
                    metadata.add("Message-Recipient-Address", string);
                }
            }
            catch (ChunkNotFoundException chunkNotFoundException) {
                // empty catch block
            }
            for (Map.Entry entry : headers.entrySet()) {
                String headerKey = (String)entry.getKey();
                String[] stringArray = (String[])entry.getValue();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String headerValue = stringArray[i];
                    metadata.add("Message:Raw-Header:" + headerKey, headerValue);
                }
            }
            if (this.msg.getMessageDate() != null) {
                metadata.set(TikaCoreProperties.CREATED, this.msg.getMessageDate().getTime());
                metadata.set(TikaCoreProperties.MODIFIED, this.msg.getMessageDate().getTime());
            } else if (headers != null && headers.size() > 0) {
                for (Map.Entry entry : headers.entrySet()) {
                    String headerKey = (String)entry.getKey();
                    if (!headerKey.toLowerCase(Locale.ROOT).startsWith("date:")) continue;
                    String string = headerKey.substring(headerKey.indexOf(58) + 1).trim();
                    try {
                        Date d = MboxParser.parseDate(string);
                        metadata.set(TikaCoreProperties.CREATED, d);
                        metadata.set(TikaCoreProperties.MODIFIED, d);
                    }
                    catch (ParseException e) {
                        metadata.set(TikaCoreProperties.CREATED, string);
                        metadata.set(TikaCoreProperties.MODIFIED, string);
                    }
                    break;
                }
            }
            xhtml.element("h1", subject);
            xhtml.startElement("dl");
            if (from != null) {
                this.header(xhtml, "From", from);
            }
            this.header(xhtml, "To", this.msg.getDisplayTo());
            this.header(xhtml, "Cc", this.msg.getDisplayCC());
            this.header(xhtml, "Bcc", this.msg.getDisplayBCC());
            try {
                this.header(xhtml, "Recipients", this.msg.getRecipientEmailAddress());
            }
            catch (ChunkNotFoundException chunkNotFoundException) {
                // empty catch block
            }
            xhtml.endElement("dl");
            Chunk htmlChunk = null;
            Object var7_14 = null;
            Chunk textChunk = null;
            for (Chunk chunk : this.msg.getMainChunks().getChunks()) {
                if (chunk.getChunkId() == MAPIProperty.BODY_HTML.id) {
                    htmlChunk = chunk;
                }
                if (chunk.getChunkId() == MAPIProperty.RTF_COMPRESSED.id) {
                    Chunk chunk2 = chunk;
                }
                if (chunk.getChunkId() != MAPIProperty.BODY.id) continue;
                textChunk = chunk;
            }
            boolean bl3 = false;
            xhtml.startElement("div", "class", "message-body");
            if (htmlChunk != null) {
                byte[] data = null;
                if (htmlChunk instanceof ByteChunk) {
                    data = ((ByteChunk)htmlChunk).getValue();
                } else if (htmlChunk instanceof StringChunk) {
                    data = ((StringChunk)htmlChunk).getRawValue();
                }
                if (data != null) {
                    Object htmlParser = EmbeddedDocumentUtil.tryToFindExistingLeafParser(HtmlParser.class, (ParseContext)this.parseContext);
                    if (htmlParser == null) {
                        htmlParser = new HtmlParser();
                    }
                    htmlParser.parse((InputStream)new ByteArrayInputStream(data), (ContentHandler)new EmbeddedContentHandler((ContentHandler)new BodyContentHandler((ContentHandler)xhtml)), new Metadata(), this.parseContext);
                    bl2 = true;
                }
            }
            if (var7_15 != null && !bl2) {
                ByteChunk chunk = (ByteChunk)var7_15;
                MAPIRtfAttribute rtf = new MAPIRtfAttribute(MAPIProperty.RTF_COMPRESSED, Types.BINARY.getId(), chunk.getValue());
                Object rtfParser = EmbeddedDocumentUtil.tryToFindExistingLeafParser(RTFParser.class, (ParseContext)this.parseContext);
                if (rtfParser == null) {
                    rtfParser = new RTFParser();
                }
                rtfParser.parse((InputStream)new ByteArrayInputStream(rtf.getData()), (ContentHandler)new EmbeddedContentHandler((ContentHandler)new BodyContentHandler((ContentHandler)xhtml)), new Metadata(), this.parseContext);
                bl = true;
            }
            if (textChunk != null && !bl) {
                xhtml.element("p", ((StringChunk)textChunk).getValue());
            }
            xhtml.endElement("div");
            for (AttachmentChunks attachment : this.msg.getAttachmentFiles()) {
                xhtml.startElement("div", "class", "attachment-entry");
                String filename = null;
                if (attachment.getAttachLongFileName() != null) {
                    filename = attachment.getAttachLongFileName().getValue();
                } else if (attachment.getAttachFileName() != null) {
                    filename = attachment.getAttachFileName().getValue();
                }
                if (filename != null && filename.length() > 0) {
                    xhtml.element("h1", filename);
                }
                if (attachment.getAttachData() != null) {
                    this.handleEmbeddedResource(TikaInputStream.get((byte[])attachment.getAttachData().getValue()), filename, null, null, xhtml, true);
                }
                if (attachment.getAttachmentDirectory() != null) {
                    this.handleEmbeddedOfficeDoc((DirectoryEntry)attachment.getAttachmentDirectory().getDirectory(), xhtml);
                }
                xhtml.endElement("div");
            }
        }
        catch (ChunkNotFoundException e) {
            throw new TikaException("POI MAPIMessage broken - didn't return null on missing chunk", (Throwable)e);
        }
    }

    private void handleFromTo(Map<String, String[]> headers, Metadata metadata) throws ChunkNotFoundException {
        String from = this.msg.getDisplayFrom();
        metadata.set(TikaCoreProperties.CREATOR, from);
        metadata.set("Message-From", from);
        metadata.set("Message-To", this.msg.getDisplayTo());
        metadata.set("Message-Cc", this.msg.getDisplayCC());
        metadata.set("Message-Bcc", this.msg.getDisplayBCC());
        Chunks chunks = this.msg.getMainChunks();
        StringChunk sentByServerType = chunks.getSentByServerType();
        if (sentByServerType != null) {
            metadata.set(Office.MAPI_SENT_BY_SERVER_TYPE, sentByServerType.getValue());
        }
        Map mainChunks = this.msg.getMainChunks().getAll();
        List senderAddresType = (List)mainChunks.get(MAPIProperty.SENDER_ADDRTYPE);
        String senderAddressTypeString = "";
        if (senderAddresType != null && senderAddresType.size() > 0) {
            senderAddressTypeString = ((Chunk)senderAddresType.get(0)).toString();
        }
        OutlookExtractor.setFirstChunk((List)mainChunks.get(MAPIProperty.SENDER_NAME), Message.MESSAGE_FROM_NAME, metadata);
        OutlookExtractor.setFirstChunk((List)mainChunks.get(MAPIProperty.SENT_REPRESENTING_NAME), Office.MAPI_FROM_REPRESENTING_NAME, metadata);
        OutlookExtractor.setFirstChunk((List)mainChunks.get(MAPIProperty.SENDER_EMAIL_ADDRESS), Message.MESSAGE_FROM_EMAIL, metadata);
        OutlookExtractor.setFirstChunk((List)mainChunks.get(MAPIProperty.SENT_REPRESENTING_EMAIL_ADDRESS), Office.MAPI_FROM_REPRESENTING_EMAIL, metadata);
        for (Recipient recipient : this.buildRecipients()) {
            switch (recipient.recipientType) {
                case TO: {
                    OutlookExtractor.addEvenIfNull(Message.MESSAGE_TO_NAME, recipient.name, metadata);
                    OutlookExtractor.addEvenIfNull(Message.MESSAGE_TO_DISPLAY_NAME, recipient.displayName, metadata);
                    OutlookExtractor.addEvenIfNull(Message.MESSAGE_TO_EMAIL, recipient.emailAddress, metadata);
                    break;
                }
                case CC: {
                    OutlookExtractor.addEvenIfNull(Message.MESSAGE_CC_NAME, recipient.name, metadata);
                    OutlookExtractor.addEvenIfNull(Message.MESSAGE_CC_DISPLAY_NAME, recipient.displayName, metadata);
                    OutlookExtractor.addEvenIfNull(Message.MESSAGE_CC_EMAIL, recipient.emailAddress, metadata);
                    break;
                }
                case BCC: {
                    OutlookExtractor.addEvenIfNull(Message.MESSAGE_BCC_NAME, recipient.name, metadata);
                    OutlookExtractor.addEvenIfNull(Message.MESSAGE_BCC_DISPLAY_NAME, recipient.displayName, metadata);
                    OutlookExtractor.addEvenIfNull(Message.MESSAGE_BCC_EMAIL, recipient.emailAddress, metadata);
                    break;
                }
            }
        }
    }

    public static void addEvenIfNull(Property property, String value, Metadata metadata) {
        if (value == null) {
            value = "";
        }
        metadata.add(property, value);
    }

    private static void setFirstChunk(List<Chunk> chunks, Property property, Metadata metadata) {
        if (chunks == null || chunks.size() < 1 || chunks.get(0) == null) {
            return;
        }
        metadata.set(property, chunks.get(0).toString());
    }

    private static void addFirstChunk(List<Chunk> chunks, Property property, Metadata metadata) {
        if (chunks == null || chunks.size() < 1 || chunks.get(0) == null) {
            return;
        }
        metadata.add(property, chunks.get(0).toString());
    }

    public static String getMessageClass(String messageClass) {
        if (messageClass == null || messageClass.trim().length() == 0) {
            return "UNSPECIFIED";
        }
        if (messageClass.equalsIgnoreCase("IPM.Note")) {
            return "NOTE";
        }
        if (messageClass.equalsIgnoreCase("IPM.Contact")) {
            return "CONTACT";
        }
        if (messageClass.equalsIgnoreCase("IPM.Appointment")) {
            return "APPOINTMENT";
        }
        if (messageClass.equalsIgnoreCase("IPM.StickyNote")) {
            return "STICKY_NOTE";
        }
        if (messageClass.equalsIgnoreCase("IPM.Task")) {
            return "TASK";
        }
        if (messageClass.equalsIgnoreCase("IPM.Post")) {
            return "POST";
        }
        return "UNKNOWN";
    }

    private Map<String, String[]> normalizeHeaders(String[] rows) {
        LinkedHashMap<String, String[]> ret = new LinkedHashMap<String, String[]>();
        if (rows == null) {
            return ret;
        }
        StringBuilder sb = new StringBuilder();
        LinkedHashMap<String, List> headers = new LinkedHashMap<String, List>();
        Matcher headerKeyMatcher = HEADER_KEY_PAT.matcher("");
        String lastKey = null;
        int consec = 0;
        for (String row : rows) {
            headerKeyMatcher.reset(row);
            if (headerKeyMatcher.find()) {
                if (lastKey != null) {
                    List vals = (List)headers.get(lastKey);
                    vals = vals == null ? new ArrayList() : vals;
                    vals.add(this.decodeHeader(sb.toString()));
                    headers.put(lastKey, vals);
                }
                sb.setLength(0);
                lastKey = headerKeyMatcher.group(1).trim();
                sb.append(headerKeyMatcher.group(2).trim());
                consec = 0;
            } else {
                if (consec > 0) {
                    sb.append("\n");
                }
                sb.append(row);
            }
            ++consec;
        }
        if (sb.length() > 0 && lastKey != null) {
            List vals = (List)headers.get(lastKey);
            vals = vals == null ? new ArrayList() : vals;
            vals.add(this.decodeHeader(sb.toString()));
            headers.put(lastKey, vals);
        }
        for (Map.Entry entry : headers.entrySet()) {
            ret.put((String)entry.getKey(), ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]));
        }
        return ret;
    }

    private String decodeHeader(String header) {
        return DecoderUtil.decodeEncodedWords((String)header, (DecodeMonitor)DecodeMonitor.SILENT);
    }

    private void header(XHTMLContentHandler xhtml, String key, String value) throws SAXException {
        if (value != null && value.length() > 0) {
            xhtml.element("dt", key);
            xhtml.element("dd", value);
        }
    }

    private void guess7BitEncoding(MAPIMessage msg) {
        Chunks mainChunks;
        block16: {
            mainChunks = msg.getMainChunks();
            if (mainChunks == null) {
                return;
            }
            Map props = mainChunks.getProperties();
            if (props != null) {
                for (MAPIProperty prop : new MAPIProperty[]{MAPIProperty.MESSAGE_CODEPAGE, MAPIProperty.INTERNET_CPID}) {
                    List val = (List)props.get(prop);
                    if (val == null || val.size() <= 0) continue;
                    int codepage = ((PropertyValue.LongPropertyValue)val.get(0)).getValue();
                    String encoding = null;
                    try {
                        encoding = CodePageUtil.codepageToEncoding((int)codepage, (boolean)true);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    if (!this.tryToSet7BitEncoding(msg, encoding)) continue;
                    return;
                }
            }
            try {
                String[] headers = msg.getHeaders();
                if (headers != null && headers.length > 0) {
                    Pattern p = Pattern.compile("Content-Type:.*?charset=[\"']?([^;'\"]+)[\"']?", 2);
                    for (String header : headers) {
                        String charset;
                        Matcher m;
                        if (!header.startsWith("Content-Type") || !(m = p.matcher(header)).matches() || !this.tryToSet7BitEncoding(msg, charset = m.group(1))) continue;
                        return;
                    }
                }
            }
            catch (ChunkNotFoundException headers) {
                // empty catch block
            }
            try {
                String html = msg.getHtmlBody();
                if (html == null || html.length() <= 0) break block16;
                Charset charset = null;
                try {
                    charset = this.detector.detect(new ByteArrayInputStream(html.getBytes(StandardCharsets.UTF_8)), EMPTY_METADATA);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (charset != null && this.tryToSet7BitEncoding(msg, charset.name())) {
                    return;
                }
            }
            catch (ChunkNotFoundException html) {
                // empty catch block
            }
        }
        StringChunk text = mainChunks.getTextBodyChunk();
        if (text != null) {
            CharsetDetector detector = new CharsetDetector();
            detector.setText(text.getRawValue());
            CharsetMatch match = detector.detect();
            if (match != null && match.getConfidence() > 35 && this.tryToSet7BitEncoding(msg, match.getName())) {
                return;
            }
        }
    }

    private boolean tryToSet7BitEncoding(MAPIMessage msg, String charsetName) {
        if (charsetName == null) {
            return false;
        }
        if (charsetName.equalsIgnoreCase("utf-8")) {
            return false;
        }
        try {
            if (Charset.isSupported(charsetName)) {
                msg.set7BitEncoding(charsetName);
                return true;
            }
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    private List<Recipient> buildRecipients() {
        RecipientChunks[] recipientChunks = this.msg.getRecipientDetailsChunks();
        if (recipientChunks == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<Recipient> recipients = new LinkedList<Recipient>();
        for (RecipientChunks chunks : recipientChunks) {
            Object val;
            Recipient r = new Recipient();
            r.displayName = chunks.recipientDisplayNameChunk != null ? chunks.recipientDisplayNameChunk.toString() : null;
            r.name = chunks.recipientNameChunk != null ? chunks.recipientNameChunk.toString() : null;
            r.emailAddress = chunks.getRecipientEmailAddress();
            List vals = (List)chunks.getProperties().get(MAPIProperty.RECIPIENT_TYPE);
            RECIPIENT_TYPE recipientType = RECIPIENT_TYPE.UNSPECIFIED;
            if (vals != null && vals.size() > 0 && (val = ((PropertyValue)vals.get(0)).getValue()) instanceof Integer) {
                recipientType = RECIPIENT_TYPE.getTypeFromVal((Integer)val);
            }
            r.recipientType = recipientType;
            vals = (List)chunks.getProperties().get(MAPIProperty.ADDRTYPE);
            if (vals != null && vals.size() > 0 && (val = ((PropertyValue)vals.get(0)).toString()) != null) {
                if (((String)(val = ((String)val).toLowerCase(Locale.US))).equals("ex")) {
                    r.addressType = ADDRESS_TYPE.EX;
                } else if (((String)val).equals("smtp")) {
                    r.addressType = ADDRESS_TYPE.SMTP;
                }
            }
            recipients.add(r);
        }
        return recipients;
    }

    private static class Recipient {
        String name;
        String displayName;
        RECIPIENT_TYPE recipientType;
        String emailAddress;
        ADDRESS_TYPE addressType;

        private Recipient() {
        }
    }

    private static enum ADDRESS_TYPE {
        EX,
        SMTP;

    }

    public static enum RECIPIENT_TYPE {
        TO(1),
        CC(2),
        BCC(3),
        UNRECOGNIZED(-1),
        UNSPECIFIED(-1);

        private final int val;

        private RECIPIENT_TYPE(int val) {
            this.val = val;
        }

        public static RECIPIENT_TYPE getTypeFromVal(int val) {
            if (val > 0 && val < 4) {
                return RECIPIENT_TYPE.values()[val - 1];
            }
            return UNRECOGNIZED;
        }
    }
}

