/*
 * Decompiled with CFR 0.152.
 */
package org.ghost4j.modifier;

import gnu.cajo.invoke.Remote;
import gnu.cajo.utils.ItemServer;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.ghost4j.AbstractRemoteComponent;
import org.ghost4j.document.Document;
import org.ghost4j.document.DocumentException;
import org.ghost4j.modifier.ModifierException;
import org.ghost4j.modifier.RemoteModifier;
import org.ghost4j.util.JavaFork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRemoteModifier
extends AbstractRemoteComponent
implements RemoteModifier {
    protected abstract Document run(Document var1, Map<String, Serializable> var2) throws ModifierException, DocumentException, IOException;

    protected static void startRemoteModifier(RemoteModifier remoteModifier) throws ModifierException {
        try {
            if (System.getenv("cajo.port") == null) {
                throw new ModifierException("No Cajo port defined for remote converter");
            }
            int cajoPort = Integer.parseInt(System.getenv("cajo.port"));
            RemoteModifier modifierCopy = (RemoteModifier)remoteModifier.getClass().newInstance();
            remoteModifier.setMaxProcessCount(0);
            Remote.config(null, cajoPort, null, 0);
            ItemServer.bind(modifierCopy, RemoteModifier.class.getCanonicalName());
        }
        catch (Exception e) {
            throw new ModifierException(e);
        }
    }

    public Document remoteModify(Document source, Map<String, Serializable> parameters) throws ModifierException, DocumentException, IOException {
        return this.run(source, parameters);
    }

    @Override
    public Document modify(Document source, Map<String, Serializable> parameters) throws ModifierException, DocumentException, IOException {
        if (this.maxProcessCount == 0) {
            return this.run(source, parameters);
        }
        this.waitForFreeProcess();
        ++this.processCount;
        if (!this.isStandAloneModeSupported()) {
            throw new ModifierException("Standalone mode is not supported by this modifier: no 'main' method found");
        }
        JavaFork fork = this.buildJavaFork();
        int documentMbSize = (source.getSize() / 1024 / 1024 + 1) * 2;
        int xmxValue = 64 + documentMbSize;
        fork.setXmx(xmxValue + "m");
        int cajoPort = 0;
        try {
            Document result;
            cajoPort = this.startRemoteServer(fork);
            Object remote = this.getRemoteComponent(cajoPort, RemoteModifier.class);
            Remote.invoke(remote, "copySettings", this.extractSettings());
            Object[] args = new Object[]{source, parameters};
            Document document = result = (Document)Remote.invoke(remote, "remoteModify", args);
            Object var12_12 = null;
            --this.processCount;
            fork.stop();
            return document;
        }
        catch (Exception e) {
            try {
                throw new ModifierException(e);
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                --this.processCount;
                fork.stop();
                throw throwable;
            }
        }
    }
}

