/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import com.google.protobuf.ByteString;
import java.io.IOException;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateEns;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateTime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTimeIntv;
import ucar.coord.CoordinateVert;
import ucar.nc2.grib.EnsCoord;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.collection.GribCollection;
import ucar.nc2.grib.collection.GribCollectionProto;
import ucar.nc2.time.CalendarDate;

public class GribCollectionWriter {
    protected GribCollectionProto.Gds writeGdsProto(GribCollection.HorizCoordSys hcs) throws IOException {
        return this.writeGdsProto(hcs.getGdsHash(), hcs.getRawGds(), hcs.getNameOverride(), hcs.getPredefinedGridDefinition());
    }

    protected GribCollectionProto.Gds writeGdsProto(int gdsHash, byte[] rawGds, String nameOverride, int predefinedGridDefinition) throws IOException {
        GribCollectionProto.Gds.Builder b = GribCollectionProto.Gds.newBuilder();
        if (predefinedGridDefinition >= 0) {
            b.setPredefinedGridDefinition(predefinedGridDefinition);
        } else {
            b.setGds(ByteString.copyFrom((byte[])rawGds));
            b.setGdsHash(gdsHash);
        }
        if (nameOverride != null) {
            b.setNameOverride(nameOverride);
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(CoordinateRuntime coord) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setType(coord.getType().ordinal());
        b.setCode(coord.getCode());
        if (coord.getUnit() != null) {
            b.setUnit(coord.getUnit());
        }
        for (CalendarDate cd : coord.getRuntimesSorted()) {
            b.addMsecs(cd.getMillis());
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(CoordinateTime coord) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setType(coord.getType().ordinal());
        b.setCode(coord.getCode());
        b.setUnit(coord.getTimeUnit().toString());
        b.addMsecs(coord.getRefDate().getMillis());
        for (Integer offset : coord.getOffsetSorted()) {
            b.addValues(offset.intValue());
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(CoordinateTimeIntv coord) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setType(coord.getType().ordinal());
        b.setCode(coord.getCode());
        b.setUnit(coord.getTimeUnit().toString());
        b.addMsecs(coord.getRefDate().getMillis());
        for (TimeCoord.Tinv tinv : coord.getTimeIntervals()) {
            b.addValues(tinv.getBounds1());
            b.addBound(tinv.getBounds2());
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(CoordinateVert coord) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setType(coord.getType().ordinal());
        b.setCode(coord.getCode());
        if (coord.getUnit() != null) {
            b.setUnit(coord.getUnit());
        }
        for (VertCoord.Level level : coord.getLevelSorted()) {
            if (coord.isLayer()) {
                b.addValues((float)level.getValue1());
                b.addBound((float)level.getValue2());
                continue;
            }
            b.addValues((float)level.getValue1());
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(CoordinateEns coord) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setType(coord.getType().ordinal());
        b.setCode(coord.getCode());
        if (coord.getUnit() != null) {
            b.setUnit(coord.getUnit());
        }
        for (EnsCoord.Coord level : coord.getEnsSorted()) {
            b.addValues(level.getCode());
            b.addBound(level.getEnsMember());
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(CoordinateTime2D coord) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setType(coord.getType().ordinal());
        b.setCode(coord.getCode());
        b.setUnit(coord.getTimeUnit().toString());
        CoordinateRuntime runtime = coord.getRuntimeCoordinate();
        for (CalendarDate calendarDate : runtime.getRuntimesSorted()) {
            b.addMsecs(calendarDate.getMillis());
        }
        b.setIsOrthogonal(coord.isOrthogonal());
        b.setIsRegular(coord.isRegular());
        for (Coordinate coordinate : coord.getTimesForSerialization()) {
            if (coordinate.getType() == Coordinate.Type.time) {
                b.addTimes(this.writeCoordProto((CoordinateTime)coordinate));
                continue;
            }
            b.addTimes(this.writeCoordProto((CoordinateTimeIntv)coordinate));
        }
        return b.build();
    }
}

