/*
 * Decompiled with CFR 0.152.
 */
package org.ghost4j.document;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.dsc.DSCException;
import org.apache.xmlgraphics.ps.dsc.DSCFilter;
import org.apache.xmlgraphics.ps.dsc.DSCListener;
import org.apache.xmlgraphics.ps.dsc.DSCParser;
import org.apache.xmlgraphics.ps.dsc.DefaultNestedDocumentHandler;
import org.apache.xmlgraphics.ps.dsc.events.DSCAtend;
import org.apache.xmlgraphics.ps.dsc.events.DSCComment;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentPage;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentPages;
import org.apache.xmlgraphics.ps.dsc.events.DSCEvent;
import org.apache.xmlgraphics.ps.dsc.events.DSCHeaderComment;
import org.apache.xmlgraphics.ps.dsc.tools.DSCTools;
import org.apache.xmlgraphics.ps.dsc.tools.PageExtractor;
import org.ghost4j.document.AbstractDocument;
import org.ghost4j.document.Document;
import org.ghost4j.document.DocumentException;

public class PSDocument
extends AbstractDocument {
    private static final long serialVersionUID = 7225098893496658222L;

    public void load(InputStream inputStream) throws IOException {
        super.load(inputStream);
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(this.content);
            DSCParser parser = new DSCParser((InputStream)bais);
            if (parser.nextDSCComment("EndComments") == null) {
                throw new IOException("PostScript document is not valid");
            }
        }
        catch (DSCException e) {
            try {
                throw new IOException(e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bais);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)bais);
    }

    public int getPageCount() throws DocumentException {
        int pageCount = 0;
        if (this.content == null) {
            return pageCount;
        }
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(this.content);
            DSCParser parser = new DSCParser((InputStream)bais);
            DSCComment tP = parser.nextDSCComment("Pages");
            while (tP instanceof DSCAtend) {
                tP = parser.nextDSCComment("Pages");
            }
            DSCCommentPages pages = (DSCCommentPages)tP;
            pageCount = pages.getPageCount();
        }
        catch (Exception e) {
            try {
                throw new DocumentException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bais);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)bais);
        return pageCount;
    }

    public Document extract(int begin, int end) throws DocumentException {
        this.assertValidPageRange(begin, end);
        PSDocument result = new PSDocument();
        ByteArrayInputStream bais = null;
        ByteArrayOutputStream baos = null;
        if (this.content != null) {
            try {
                bais = new ByteArrayInputStream(this.content);
                baos = new ByteArrayOutputStream();
                PageExtractor.extractPages((InputStream)bais, (OutputStream)baos, (int)begin, (int)end);
                result.load(new ByteArrayInputStream(baos.toByteArray()));
            }
            catch (Exception e) {
                try {
                    throw new DocumentException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bais);
                    IOUtils.closeQuietly(baos);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)bais);
            IOUtils.closeQuietly((OutputStream)baos);
        }
        return result;
    }

    public void append(Document document) throws DocumentException {
        super.append(document);
        ByteArrayInputStream baisCurrent = null;
        ByteArrayInputStream baisNew = null;
        ByteArrayOutputStream baos = null;
        int currentPageCount = this.getPageCount();
        int totalPageCount = currentPageCount + document.getPageCount();
        try {
            baisCurrent = new ByteArrayInputStream(this.content);
            baos = new ByteArrayOutputStream();
            DSCParser currentParser = new DSCParser((InputStream)baisCurrent);
            PSGenerator gen = new PSGenerator((OutputStream)baos);
            currentParser.addListener((DSCListener)new DefaultNestedDocumentHandler(gen));
            DSCHeaderComment header = DSCTools.checkAndSkipDSC30Header((DSCParser)currentParser);
            header.generate(gen);
            DSCCommentPages pages = new DSCCommentPages(totalPageCount);
            pages.generate(gen);
            currentParser.setFilter(new DSCFilter(){

                public boolean accept(DSCEvent event) {
                    if (event.isDSCComment()) {
                        return !event.asDSCComment().getName().equals("Pages");
                    }
                    return true;
                }
            });
            DSCComment pageOrTrailer = currentParser.nextDSCComment("Page", gen);
            if (pageOrTrailer == null) {
                throw new DSCException("Page expected, but none found");
            }
            currentParser.setFilter(null);
            do {
                DSCCommentPage page = (DSCCommentPage)pageOrTrailer;
                page.setPagePosition(page.getPagePosition());
                page.generate(gen);
                pageOrTrailer = DSCTools.nextPageOrTrailer((DSCParser)currentParser, (PSGenerator)gen);
                if (pageOrTrailer != null) continue;
                throw new DSCException("File is not DSC-compliant: Unexpected end of file");
            } while ("Page".equals(pageOrTrailer.getName()));
            baisNew = new ByteArrayInputStream(document.getContent());
            DSCParser newParser = new DSCParser((InputStream)baisNew);
            header = DSCTools.checkAndSkipDSC30Header((DSCParser)newParser);
            pageOrTrailer = newParser.nextDSCComment("Page");
            if (pageOrTrailer == null) {
                throw new DSCException("Page expected, but none found");
            }
            int i = 1;
            while (true) {
                DSCCommentPage page = (DSCCommentPage)pageOrTrailer;
                page.setPageName(String.valueOf(currentPageCount + i));
                page.setPagePosition(currentPageCount + i);
                page.generate(gen);
                pageOrTrailer = DSCTools.nextPageOrTrailer((DSCParser)newParser, (PSGenerator)gen);
                if (pageOrTrailer == null) {
                    throw new DSCException("File is not DSC-compliant: Unexpected end of file");
                }
                if (!"Page".equals(pageOrTrailer.getName())) break;
                ++i;
            }
            pageOrTrailer.generate(gen);
            currentParser.setFilter(new DSCFilter(){

                public boolean accept(DSCEvent event) {
                    if (event.isDSCComment()) {
                        return !event.asDSCComment().getName().equals("Pages");
                    }
                    return true;
                }
            });
            while (currentParser.hasNext()) {
                DSCEvent event = currentParser.nextEvent();
                event.generate(gen);
            }
            this.content = baos.toByteArray();
        }
        catch (Exception e) {
            try {
                throw new DocumentException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(baisCurrent);
                IOUtils.closeQuietly(baisNew);
                IOUtils.closeQuietly(baos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)baisCurrent);
        IOUtils.closeQuietly((InputStream)baisNew);
        IOUtils.closeQuietly((OutputStream)baos);
    }

    public String getType() {
        return "PostScript";
    }
}

