/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.fontencodingpane;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.LinkedHashMap;
import javax.swing.JPanel;
import org.apache.pdfbox.debugger.fontencodingpane.FontEncodingView;
import org.apache.pdfbox.debugger.fontencodingpane.FontPane;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDType3CharProc;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.util.Charsets;
import org.apache.pdfbox.util.Matrix;

class Type3Font
extends FontPane {
    public static final String NO_GLYPH = "No glyph";
    private final FontEncodingView view;
    private int totalAvailableGlyph = 0;
    private PDRectangle fontBBox;
    private final PDResources resources;

    Type3Font(PDType3Font font, PDResources resources) throws IOException {
        this.resources = resources;
        this.calcBBox(font);
        Object[][] tableData = this.getGlyphs(font);
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        attributes.put("Font", font.getName());
        attributes.put("Encoding", this.getEncodingName((PDSimpleFont)font));
        attributes.put("Glyphs", Integer.toString(this.totalAvailableGlyph));
        this.view = new FontEncodingView(tableData, attributes, new String[]{"Code", "Glyph Name", "Unicode Character", "Glyph"}, null);
    }

    private void calcBBox(PDType3Font font) throws IOException {
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        for (int index = 0; index <= 255; ++index) {
            PDRectangle glyphBBox;
            PDType3CharProc charProc = font.getCharProc(index);
            if (charProc == null || (glyphBBox = charProc.getGlyphBBox()) == null) continue;
            minX = Math.min(minX, (double)glyphBBox.getLowerLeftX());
            maxX = Math.max(maxX, (double)glyphBBox.getUpperRightX());
            minY = Math.min(minY, (double)glyphBBox.getLowerLeftY());
            maxY = Math.max(maxY, (double)glyphBBox.getUpperRightY());
        }
        this.fontBBox = new PDRectangle((float)minX, (float)minY, (float)(maxX - minX), (float)(maxY - minY));
    }

    private Object[][] getGlyphs(PDType3Font font) throws IOException {
        Object[][] glyphs = new Object[256][4];
        for (int index = 0; index <= 255; ++index) {
            glyphs[index][0] = index;
            if (font.getEncoding().contains(index)) {
                glyphs[index][1] = font.getEncoding().getName(index);
                glyphs[index][2] = font.toUnicode(index);
                glyphs[index][3] = this.fontBBox.toGeneralPath().getBounds2D().isEmpty() ? NO_GLYPH : this.renderType3Glyph(font, index);
                ++this.totalAvailableGlyph;
                continue;
            }
            glyphs[index][1] = NO_GLYPH;
            glyphs[index][2] = NO_GLYPH;
            glyphs[index][3] = NO_GLYPH;
        }
        return glyphs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage renderType3Glyph(PDType3Font font, int index) throws IOException {
        PDDocument doc = new PDDocument();
        int scale = 1;
        if (this.fontBBox.getWidth() < 72.0f || this.fontBBox.getHeight() < 72.0f) {
            scale = (int)(72.0f / Math.min(this.fontBBox.getWidth(), this.fontBBox.getHeight()));
        }
        PDPage page = new PDPage(new PDRectangle(this.fontBBox.getWidth() * (float)scale, this.fontBBox.getHeight() * (float)scale));
        page.setResources(this.resources);
        try {
            PDPageContentStream cs = new PDPageContentStream(doc, page);
            cs.transform(Matrix.getTranslateInstance((float)(-this.fontBBox.getLowerLeftX()), (float)(-this.fontBBox.getLowerLeftY())));
            try {
                AffineTransform at = font.getFontMatrix().createAffineTransform();
                if (!at.isIdentity()) {
                    at.invert();
                    cs.transform(new Matrix(at));
                }
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
            cs.beginText();
            cs.setFont((PDFont)font, (float)scale);
            cs.appendRawCommands(String.format("<%02X> Tj\n", index).getBytes(Charsets.ISO_8859_1));
            cs.endText();
            cs.close();
            doc.addPage(page);
            BufferedImage bufferedImage = new PDFRenderer(doc).renderImage(0);
            return bufferedImage;
        }
        finally {
            doc.close();
        }
    }

    private String getEncodingName(PDSimpleFont font) {
        return font.getEncoding().getClass().getSimpleName();
    }

    @Override
    public JPanel getPanel() {
        return this.view.getPanel();
    }
}

