/*
 * Decompiled with CFR 0.152.
 */
package org.ghost4j.analyzer;

import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.ghost4j.Ghostscript;
import org.ghost4j.GhostscriptException;
import org.ghost4j.analyzer.AbstractRemoteAnalyzer;
import org.ghost4j.analyzer.AnalysisItem;
import org.ghost4j.analyzer.Analyzer;
import org.ghost4j.analyzer.AnalyzerException;
import org.ghost4j.analyzer.InkAnalysisItem;
import org.ghost4j.document.Document;
import org.ghost4j.document.DocumentException;
import org.ghost4j.document.PDFDocument;
import org.ghost4j.document.PSDocument;
import org.ghost4j.util.DiskStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InkAnalyzer
extends AbstractRemoteAnalyzer
implements Analyzer {
    public InkAnalyzer() {
        this.supportedDocumentClasses = new Class[2];
        this.supportedDocumentClasses[0] = PDFDocument.class;
        this.supportedDocumentClasses[1] = PSDocument.class;
    }

    public static void main(String[] args) throws AnalyzerException {
        InkAnalyzer.startRemoteAnalyzer(new InkAnalyzer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InkAnalysisItem analyzeSinglePage(Document page) throws IOException, AnalyzerException, DocumentException {
        InkAnalysisItem inkAnalysisItem;
        Ghostscript gs = Ghostscript.getInstance();
        DiskStore diskStore = DiskStore.getInstance();
        String inputDiskStoreKey = diskStore.generateUniqueKey();
        String outputDiskStoreKey = diskStore.generateUniqueKey();
        page.write(diskStore.addFile(inputDiskStoreKey));
        String[] gsArgs = new String[]{"-inkcov", "-dBATCH", "-dNOPAUSE", "-dQUIET", "-sDEVICE=inkcov", "-sOutputFile=" + diskStore.addFile(outputDiskStoreKey), "-f", diskStore.getFile(inputDiskStoreKey).getAbsolutePath()};
        FileReader fr = null;
        try {
            try {
                String[] components;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Ghostscript ghostscript = gs;
                synchronized (ghostscript) {
                    gs.initialize(gsArgs);
                    gs.exit();
                }
                fr = new FileReader(diskStore.getFile(outputDiskStoreKey));
                char[] chars = new char[100];
                fr.read(chars);
                String output = new String(chars).trim();
                InkAnalysisItem item = new InkAnalysisItem();
                if (output.endsWith("CMYK OK") && (components = output.split("CMYK")[0].split("  ")).length == 4) {
                    item.setC(this.parseValue(components[0]));
                    item.setM(this.parseValue(components[1]));
                    item.setY(this.parseValue(components[2]));
                    item.setK(this.parseValue(components[3]));
                }
                baos.close();
                inkAnalysisItem = item;
                Object var14_14 = null;
            }
            catch (Exception e) {
                throw new AnalyzerException(e);
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            IOUtils.closeQuietly(fr);
            try {
                Ghostscript.deleteInstance();
            }
            catch (GhostscriptException e2) {
                throw new AnalyzerException(e2);
            }
            diskStore.removeFile(inputDiskStoreKey);
            diskStore.removeFile(outputDiskStoreKey);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)fr);
        try {}
        catch (GhostscriptException e2) {
            throw new AnalyzerException(e2);
        }
        Ghostscript.deleteInstance();
        diskStore.removeFile(inputDiskStoreKey);
        diskStore.removeFile(outputDiskStoreKey);
        return inkAnalysisItem;
    }

    private double parseValue(String value) throws ParseException {
        return Double.parseDouble(value.trim().replace(",", "."));
    }

    @Override
    public List<AnalysisItem> run(Document document) throws IOException, AnalyzerException, DocumentException {
        this.assertDocumentSupported(document);
        try {
            this.assertDeviceSupported("inkcov");
        }
        catch (GhostscriptException e) {
            throw new AnalyzerException(e);
        }
        ArrayList<AnalysisItem> result = new ArrayList<AnalysisItem>();
        List<Document> pages = document.explode();
        int i = 1;
        for (Document page : pages) {
            InkAnalysisItem item = this.analyzeSinglePage(page);
            item.setPageIndex(i);
            result.add(item);
            ++i;
        }
        return result;
    }
}

