/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tess4j;

import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.ptr.PointerByReference;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.sourceforge.lept4j.Boxa;
import net.sourceforge.lept4j.Leptonica;
import net.sourceforge.tess4j.ITessAPI;
import net.sourceforge.tess4j.ITesseract;
import net.sourceforge.tess4j.OCRResult;
import net.sourceforge.tess4j.TessAPI;
import net.sourceforge.tess4j.TesseractException;
import net.sourceforge.tess4j.Word;
import net.sourceforge.tess4j.util.ImageIOHelper;
import net.sourceforge.tess4j.util.LoggHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tesseract
implements ITesseract {
    private String language = "eng";
    private String datapath;
    private ITesseract.RenderedFormat renderedFormat = ITesseract.RenderedFormat.TEXT;
    private int psm = -1;
    private int ocrEngineMode = 3;
    private final Properties prop = new Properties();
    private final List<String> configList = new ArrayList<String>();
    private TessAPI api;
    private ITessAPI.TessBaseAPI handle;
    private static final Logger logger = LoggerFactory.getLogger((String)new LoggHelper().toString());

    public Tesseract() {
        try {
            this.datapath = System.getenv("TESSDATA_PREFIX");
        }
        catch (Exception exception) {
        }
        finally {
            if (this.datapath == null) {
                this.datapath = "./";
            }
        }
    }

    protected TessAPI getAPI() {
        return this.api;
    }

    protected ITessAPI.TessBaseAPI getHandle() {
        return this.handle;
    }

    @Override
    public void setDatapath(String string) {
        this.datapath = string;
    }

    @Override
    public void setLanguage(String string) {
        this.language = string;
    }

    @Override
    public void setOcrEngineMode(int n) {
        this.ocrEngineMode = n;
    }

    @Override
    public void setPageSegMode(int n) {
        this.psm = n;
    }

    public void setHocr(boolean bl) {
        this.renderedFormat = bl ? ITesseract.RenderedFormat.HOCR : ITesseract.RenderedFormat.TEXT;
        this.prop.setProperty("tessedit_create_hocr", bl ? "1" : "0");
    }

    @Override
    public void setTessVariable(String string, String string2) {
        this.prop.setProperty(string, string2);
    }

    @Override
    public void setConfigs(List<String> list) {
        this.configList.clear();
        if (list != null) {
            this.configList.addAll(list);
        }
    }

    @Override
    public String doOCR(File file) throws TesseractException {
        return this.doOCR(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doOCR(File file, Rectangle rectangle) throws TesseractException {
        try {
            File file2 = ImageIOHelper.getImageFile(file);
            String string = ImageIOHelper.getImageFileFormat(file2);
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string);
            if (!iterator.hasNext()) {
                throw new RuntimeException("Unsupported image format. May need to install JAI Image I/O package.\nhttps://github.com/jai-imageio/jai-imageio-core");
            }
            ImageReader imageReader = iterator.next();
            StringBuilder stringBuilder = new StringBuilder();
            try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(file2);){
                imageReader.setInput(imageInputStream);
                int n = imageReader.getNumImages(true);
                this.init();
                this.setTessVariables();
                for (int i = 0; i < n; ++i) {
                    IIOImage iIOImage = imageReader.readAll(i, imageReader.getDefaultReadParam());
                    stringBuilder.append(this.doOCR(iIOImage, file.getPath(), rectangle, i + 1));
                }
                if (this.renderedFormat == ITesseract.RenderedFormat.HOCR) {
                    stringBuilder.insert(0, "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n<title></title>\n<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\" />\n<meta name='ocr-system' content='tesseract'/>\n</head>\n<body>\n").append("</body>\n</html>\n");
                }
            }
            finally {
                if (file2 != null && file2.exists() && file2 != file && file2.getName().startsWith("multipage") && file2.getName().endsWith(".tif")) {
                    file2.delete();
                }
                imageReader.dispose();
                this.dispose();
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), (Throwable)exception);
            throw new TesseractException(exception);
        }
    }

    @Override
    public String doOCR(BufferedImage bufferedImage) throws TesseractException {
        return this.doOCR(bufferedImage, null);
    }

    @Override
    public String doOCR(BufferedImage bufferedImage, Rectangle rectangle) throws TesseractException {
        try {
            return this.doOCR(ImageIOHelper.getIIOImageList(bufferedImage), rectangle);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), (Throwable)exception);
            throw new TesseractException(exception);
        }
    }

    @Override
    public String doOCR(List<IIOImage> list, Rectangle rectangle) throws TesseractException {
        return this.doOCR(list, null, rectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doOCR(List<IIOImage> list, String string, Rectangle rectangle) throws TesseractException {
        this.init();
        this.setTessVariables();
        try {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            for (IIOImage iIOImage : list) {
                ++n;
                try {
                    this.setImage(iIOImage.getRenderedImage(), rectangle);
                    stringBuilder.append(this.getOCRText(string, n));
                }
                catch (IOException iOException) {
                    logger.error(iOException.getMessage(), (Throwable)iOException);
                }
            }
            if (this.renderedFormat == ITesseract.RenderedFormat.HOCR) {
                stringBuilder.insert(0, "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n<title></title>\n<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\" />\n<meta name='ocr-system' content='tesseract'/>\n</head>\n<body>\n").append("</body>\n</html>\n");
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        finally {
            this.dispose();
        }
    }

    private String doOCR(IIOImage iIOImage, String string, Rectangle rectangle, int n) throws TesseractException {
        String string2 = "";
        try {
            this.setImage(iIOImage.getRenderedImage(), rectangle);
            string2 = this.getOCRText(string, n);
        }
        catch (IOException iOException) {
            logger.warn(iOException.getMessage(), (Throwable)iOException);
        }
        return string2;
    }

    @Override
    public String doOCR(int n, int n2, ByteBuffer byteBuffer, Rectangle rectangle, int n3) throws TesseractException {
        return this.doOCR(n, n2, byteBuffer, null, rectangle, n3);
    }

    @Override
    public String doOCR(int n, int n2, ByteBuffer byteBuffer, String string, Rectangle rectangle, int n3) throws TesseractException {
        this.init();
        this.setTessVariables();
        try {
            this.setImage(n, n2, byteBuffer, rectangle, n3);
            String string2 = this.getOCRText(string, 1);
            return string2;
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), (Throwable)exception);
            throw new TesseractException(exception);
        }
        finally {
            this.dispose();
        }
    }

    protected void init() {
        this.api = TessAPI.INSTANCE;
        this.handle = this.api.TessBaseAPICreate();
        StringArray stringArray = new StringArray(this.configList.toArray(new String[0]));
        PointerByReference pointerByReference = new PointerByReference();
        pointerByReference.setPointer((Pointer)stringArray);
        this.api.TessBaseAPIInit1(this.handle, this.datapath, this.language, this.ocrEngineMode, pointerByReference, this.configList.size());
        if (this.psm > -1) {
            this.api.TessBaseAPISetPageSegMode(this.handle, this.psm);
        }
    }

    protected void setTessVariables() {
        Enumeration<?> enumeration = this.prop.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.api.TessBaseAPISetVariable(this.handle, string, this.prop.getProperty(string));
        }
    }

    protected void setImage(RenderedImage renderedImage, Rectangle rectangle) throws IOException {
        ByteBuffer byteBuffer = ImageIOHelper.getImageByteBuffer(renderedImage);
        DataBuffer dataBuffer = renderedImage.getData(new Rectangle(1, 1)).getDataBuffer();
        int n = dataBuffer instanceof DataBufferByte ? renderedImage.getColorModel().getPixelSize() : 8;
        this.setImage(renderedImage.getWidth(), renderedImage.getHeight(), byteBuffer, rectangle, n);
    }

    protected void setImage(int n, int n2, ByteBuffer byteBuffer, Rectangle rectangle, int n3) {
        int n4 = n3 / 8;
        int n5 = (int)Math.ceil((double)(n * n3) / 8.0);
        this.api.TessBaseAPISetImage(this.handle, byteBuffer, n, n2, n4, n5);
        if (rectangle != null && !rectangle.isEmpty()) {
            this.api.TessBaseAPISetRectangle(this.handle, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected String getOCRText(String string, int n) {
        if (string != null && !string.isEmpty()) {
            this.api.TessBaseAPISetInputName(this.handle, string);
        }
        Pointer pointer = this.renderedFormat == ITesseract.RenderedFormat.HOCR ? this.api.TessBaseAPIGetHOCRText(this.handle, n - 1) : this.api.TessBaseAPIGetUTF8Text(this.handle);
        String string2 = pointer.getString(0L);
        this.api.TessDeleteText(pointer);
        return string2;
    }

    private ITessAPI.TessResultRenderer createRenderers(String string, List<ITesseract.RenderedFormat> list) {
        ITessAPI.TessResultRenderer tessResultRenderer = null;
        for (ITesseract.RenderedFormat renderedFormat : list) {
            switch (renderedFormat) {
                case TEXT: {
                    if (tessResultRenderer == null) {
                        tessResultRenderer = this.api.TessTextRendererCreate(string);
                        break;
                    }
                    this.api.TessResultRendererInsert(tessResultRenderer, this.api.TessTextRendererCreate(string));
                    break;
                }
                case HOCR: {
                    if (tessResultRenderer == null) {
                        tessResultRenderer = this.api.TessHOcrRendererCreate(string);
                        break;
                    }
                    this.api.TessResultRendererInsert(tessResultRenderer, this.api.TessHOcrRendererCreate(string));
                    break;
                }
                case PDF: {
                    String string2 = this.api.TessBaseAPIGetDatapath(this.handle);
                    boolean bl = String.valueOf(1).equals(this.prop.getProperty("textonly_pdf"));
                    if (tessResultRenderer == null) {
                        tessResultRenderer = this.api.TessPDFRendererCreate(string, string2, bl ? 1 : 0);
                        break;
                    }
                    this.api.TessResultRendererInsert(tessResultRenderer, this.api.TessPDFRendererCreate(string, string2, bl ? 1 : 0));
                    break;
                }
                case BOX: {
                    if (tessResultRenderer == null) {
                        tessResultRenderer = this.api.TessBoxTextRendererCreate(string);
                        break;
                    }
                    this.api.TessResultRendererInsert(tessResultRenderer, this.api.TessBoxTextRendererCreate(string));
                    break;
                }
                case UNLV: {
                    if (tessResultRenderer == null) {
                        tessResultRenderer = this.api.TessUnlvRendererCreate(string);
                        break;
                    }
                    this.api.TessResultRendererInsert(tessResultRenderer, this.api.TessUnlvRendererCreate(string));
                }
            }
        }
        return tessResultRenderer;
    }

    @Override
    public void createDocuments(String string, String string2, List<ITesseract.RenderedFormat> list) throws TesseractException {
        this.createDocuments(new String[]{string}, new String[]{string2}, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDocuments(String[] stringArray, String[] stringArray2, List<ITesseract.RenderedFormat> list) throws TesseractException {
        if (stringArray.length != stringArray2.length) {
            throw new RuntimeException("The two arrays must match in length.");
        }
        this.init();
        this.setTessVariables();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(stringArray[i]);
                File file2 = null;
                try {
                    file2 = ImageIOHelper.getImageFile(file);
                    ITessAPI.TessResultRenderer tessResultRenderer = this.createRenderers(stringArray2[i], list);
                    this.createDocuments(file2.getPath(), tessResultRenderer);
                    this.api.TessDeleteResultRenderer(tessResultRenderer);
                    continue;
                }
                catch (Exception exception) {
                    logger.warn(exception.getMessage(), (Throwable)exception);
                    continue;
                }
                finally {
                    if (file2 != null && file2.exists() && file2 != file && file2.getName().startsWith("multipage") && file2.getName().endsWith(".tif")) {
                        file2.delete();
                    }
                }
            }
        }
        finally {
            this.dispose();
        }
    }

    private int createDocuments(String string, ITessAPI.TessResultRenderer tessResultRenderer) throws TesseractException {
        this.api.TessBaseAPISetInputName(this.handle, string);
        int n = this.api.TessBaseAPIProcessPages(this.handle, string, null, 0, tessResultRenderer);
        if (n == 0) {
            throw new TesseractException("Error during processing page.");
        }
        return this.api.TessBaseAPIMeanTextConf(this.handle);
    }

    @Override
    public List<Rectangle> getSegmentedRegions(BufferedImage bufferedImage, int n) throws TesseractException {
        this.init();
        this.setTessVariables();
        try {
            Object object;
            ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
            this.setImage(bufferedImage, null);
            Boxa boxa = this.api.TessBaseAPIGetComponentImages(this.handle, n, 1, null, null);
            Leptonica leptonica = Leptonica.INSTANCE;
            int n2 = leptonica.boxaGetCount(boxa);
            for (int i = 0; i < n2; ++i) {
                object = leptonica.boxaGetBox(boxa, i, 2);
                if (object == null) continue;
                arrayList.add(new Rectangle(object.x, object.y, object.w, object.h));
                PointerByReference pointerByReference = new PointerByReference();
                pointerByReference.setValue(object.getPointer());
                leptonica.boxDestroy(pointerByReference);
            }
            PointerByReference pointerByReference = new PointerByReference();
            pointerByReference.setValue(boxa.getPointer());
            leptonica.boxaDestroy(pointerByReference);
            object = arrayList;
            return object;
        }
        catch (IOException iOException) {
            logger.warn(iOException.getMessage(), (Throwable)iOException);
            throw new TesseractException(iOException);
        }
        finally {
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Word> getWords(BufferedImage bufferedImage, int n) {
        this.init();
        this.setTessVariables();
        ArrayList<Word> arrayList = new ArrayList<Word>();
        try {
            this.setImage(bufferedImage, null);
            this.api.TessBaseAPIRecognize(this.handle, null);
            ITessAPI.TessResultIterator tessResultIterator = this.api.TessBaseAPIGetIterator(this.handle);
            ITessAPI.TessPageIterator tessPageIterator = this.api.TessResultIteratorGetPageIterator(tessResultIterator);
            this.api.TessPageIteratorBegin(tessPageIterator);
            do {
                Pointer pointer = this.api.TessResultIteratorGetUTF8Text(tessResultIterator, n);
                String string = pointer.getString(0L);
                this.api.TessDeleteText(pointer);
                float f = this.api.TessResultIteratorConfidence(tessResultIterator, n);
                IntBuffer intBuffer = IntBuffer.allocate(1);
                IntBuffer intBuffer2 = IntBuffer.allocate(1);
                IntBuffer intBuffer3 = IntBuffer.allocate(1);
                IntBuffer intBuffer4 = IntBuffer.allocate(1);
                this.api.TessPageIteratorBoundingBox(tessPageIterator, n, intBuffer, intBuffer2, intBuffer3, intBuffer4);
                int n2 = intBuffer.get();
                int n3 = intBuffer2.get();
                int n4 = intBuffer3.get();
                int n5 = intBuffer4.get();
                Word word = new Word(string, f, new Rectangle(n2, n3, n4 - n2, n5 - n3));
                arrayList.add(word);
            } while (this.api.TessPageIteratorNext(tessPageIterator, n) == 1);
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage(), (Throwable)exception);
        }
        finally {
            this.dispose();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OCRResult> createDocumentsWithResults(String[] stringArray, String[] stringArray2, List<ITesseract.RenderedFormat> list, int n) throws TesseractException {
        if (stringArray.length != stringArray2.length) {
            throw new RuntimeException("The two arrays must match in length.");
        }
        this.init();
        this.setTessVariables();
        ArrayList<OCRResult> arrayList = new ArrayList<OCRResult>();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(stringArray[i]);
                File file2 = null;
                try {
                    file2 = ImageIOHelper.getImageFile(file);
                    ITessAPI.TessResultRenderer tessResultRenderer = this.createRenderers(stringArray2[i], list);
                    int n2 = this.createDocuments(file2.getPath(), tessResultRenderer);
                    ArrayList<Word> arrayList2 = n2 > 0 ? this.getRecognizedWords(n) : new ArrayList();
                    arrayList.add(new OCRResult(n2, arrayList2));
                    this.api.TessDeleteResultRenderer(tessResultRenderer);
                    continue;
                }
                catch (Exception exception) {
                    logger.warn(exception.getMessage(), (Throwable)exception);
                    continue;
                }
                finally {
                    if (file2 != null && file2.exists() && file2 != file && file2.getName().startsWith("multipage") && file2.getName().endsWith(".tif")) {
                        file2.delete();
                    }
                }
            }
        }
        finally {
            this.dispose();
        }
        return arrayList;
    }

    private List<Word> getRecognizedWords(int n) {
        ArrayList<Word> arrayList = new ArrayList<Word>();
        try {
            ITessAPI.TessResultIterator tessResultIterator = this.api.TessBaseAPIGetIterator(this.handle);
            ITessAPI.TessPageIterator tessPageIterator = this.api.TessResultIteratorGetPageIterator(tessResultIterator);
            this.api.TessPageIteratorBegin(tessPageIterator);
            do {
                Pointer pointer = this.api.TessResultIteratorGetUTF8Text(tessResultIterator, n);
                String string = pointer.getString(0L);
                this.api.TessDeleteText(pointer);
                float f = this.api.TessResultIteratorConfidence(tessResultIterator, n);
                IntBuffer intBuffer = IntBuffer.allocate(1);
                IntBuffer intBuffer2 = IntBuffer.allocate(1);
                IntBuffer intBuffer3 = IntBuffer.allocate(1);
                IntBuffer intBuffer4 = IntBuffer.allocate(1);
                this.api.TessPageIteratorBoundingBox(tessPageIterator, n, intBuffer, intBuffer2, intBuffer3, intBuffer4);
                int n2 = intBuffer.get();
                int n3 = intBuffer2.get();
                int n4 = intBuffer3.get();
                int n5 = intBuffer4.get();
                Word word = new Word(string, f, new Rectangle(n2, n3, n4 - n2, n5 - n3));
                arrayList.add(word);
            } while (this.api.TessPageIteratorNext(tessPageIterator, n) == 1);
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage(), (Throwable)exception);
        }
        return arrayList;
    }

    protected void dispose() {
        this.api.TessBaseAPIDelete(this.handle);
    }
}

