/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tess4j.util;

import com.github.jaiimageio.plugins.tiff.BaselineTIFFTagSet;
import com.github.jaiimageio.plugins.tiff.TIFFDirectory;
import com.github.jaiimageio.plugins.tiff.TIFFField;
import com.github.jaiimageio.plugins.tiff.TIFFImageWriteParam;
import com.github.jaiimageio.plugins.tiff.TIFFTag;
import com.recognition.software.jdeskew.ImageDeskew;
import com.recognition.software.jdeskew.ImageUtil;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import net.sourceforge.tess4j.util.ImageHelper;
import net.sourceforge.tess4j.util.PdfUtilities;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.NodeList;

public class ImageIOHelper {
    static final String OUTPUT_FILE_NAME = "Tesstmp";
    public static final String TIFF_EXT = ".tif";
    static final String TIFF_FORMAT = "tiff";
    public static final String JAI_IMAGE_WRITER_MESSAGE = "Need to install JAI Image I/O package.\nhttps://github.com/jai-imageio/jai-imageio-core";
    public static final String JAI_IMAGE_READER_MESSAGE = "Unsupported image format. May need to install JAI Image I/O package.\nhttps://github.com/jai-imageio/jai-imageio-core";

    public static List<File> createTiffFiles(File file, int n) throws IOException {
        return ImageIOHelper.createTiffFiles(file, n, false);
    }

    /*
     * Loose catch block
     */
    public static List<File> createTiffFiles(File file, int n, boolean bl) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        String string = ImageIOHelper.getImageFileFormat(file);
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string);
        if (!iterator.hasNext()) {
            throw new RuntimeException(JAI_IMAGE_READER_MESSAGE);
        }
        ImageReader imageReader = iterator.next();
        Iterator<ImageWriter> iterator2 = ImageIO.getImageWritersByFormatName(TIFF_FORMAT);
        if (!iterator2.hasNext()) {
            throw new RuntimeException(JAI_IMAGE_WRITER_MESSAGE);
        }
        ImageWriter imageWriter = iterator2.next();
        try {
            try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);){
                imageReader.setInput(imageInputStream);
                TIFFImageWriteParam tIFFImageWriteParam = new TIFFImageWriteParam(Locale.US);
                if (!bl) {
                    tIFFImageWriteParam.setCompressionMode(0);
                }
                IIOMetadata iIOMetadata = imageWriter.getDefaultStreamMetadata((ImageWriteParam)tIFFImageWriteParam);
                int n2 = imageReader.getNumImages(true);
                for (int i = 0; i < n2; ++i) {
                    if (n != -1 && i != n) continue;
                    IIOImage iIOImage = imageReader.readAll(i, imageReader.getDefaultReadParam());
                    File file2 = File.createTempFile(OUTPUT_FILE_NAME, TIFF_EXT);
                    try (ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file2);){
                        imageWriter.setOutput(imageOutputStream);
                        imageWriter.write(iIOMetadata, iIOImage, (ImageWriteParam)tIFFImageWriteParam);
                        arrayList.add(file2);
                        continue;
                    }
                }
                ArrayList<File> arrayList2 = arrayList;
                return arrayList2;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (imageReader != null) {
                imageReader.dispose();
            }
            if (imageWriter != null) {
                imageWriter.dispose();
            }
        }
    }

    public static List<File> createTiffFiles(List<IIOImage> list, int n) throws IOException {
        return ImageIOHelper.createTiffFiles(list, n, 0, 0);
    }

    public static List<File> createTiffFiles(List<IIOImage> list, int n, int n2, int n3) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        TIFFImageWriteParam tIFFImageWriteParam = new TIFFImageWriteParam(Locale.US);
        tIFFImageWriteParam.setCompressionMode(0);
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(TIFF_FORMAT);
        if (!iterator.hasNext()) {
            throw new RuntimeException(JAI_IMAGE_WRITER_MESSAGE);
        }
        ImageWriter imageWriter = iterator.next();
        IIOMetadata iIOMetadata = imageWriter.getDefaultStreamMetadata((ImageWriteParam)tIFFImageWriteParam);
        for (IIOImage iIOImage : n == -1 ? list : list.subList(n, n + 1)) {
            Object object;
            Object object2;
            Object object3;
            if (n2 != 0 && n3 != 0) {
                object3 = ImageTypeSpecifier.createFromRenderedImage(iIOImage.getRenderedImage());
                object2 = imageWriter.getDefaultWriteParam();
                object = imageWriter.getDefaultImageMetadata((ImageTypeSpecifier)object3, (ImageWriteParam)object2);
                object = ImageIOHelper.setDPIViaAPI((IIOMetadata)object, n2, n3);
                iIOImage.setMetadata((IIOMetadata)object);
            }
            object3 = File.createTempFile(OUTPUT_FILE_NAME, TIFF_EXT);
            object2 = ImageIO.createImageOutputStream(object3);
            object = null;
            try {
                imageWriter.setOutput(object2);
                imageWriter.write(iIOMetadata, iIOImage, (ImageWriteParam)tIFFImageWriteParam);
                arrayList.add((File)object3);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 == null) continue;
                if (object != null) {
                    try {
                        object2.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    continue;
                }
                object2.close();
            }
        }
        imageWriter.dispose();
        return arrayList;
    }

    private static IIOMetadata setDPIViaAPI(IIOMetadata iIOMetadata, int n, int n2) throws IIOInvalidTreeException {
        TIFFDirectory tIFFDirectory = TIFFDirectory.createFromMetadata((IIOMetadata)iIOMetadata);
        BaselineTIFFTagSet baselineTIFFTagSet = BaselineTIFFTagSet.getInstance();
        TIFFTag tIFFTag = baselineTIFFTagSet.getTag(282);
        TIFFTag tIFFTag2 = baselineTIFFTagSet.getTag(283);
        TIFFField tIFFField = new TIFFField(tIFFTag, 5, 1, (Object)new long[][]{{n, 1L}});
        TIFFField tIFFField2 = new TIFFField(tIFFTag2, 5, 1, (Object)new long[][]{{n2, 1L}});
        tIFFDirectory.addTIFFField(tIFFField);
        tIFFDirectory.addTIFFField(tIFFField2);
        IIOMetadata iIOMetadata2 = tIFFDirectory.getAsMetadata();
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("javax_imageio_1.0");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("HorizontalPixelSize");
        iIOMetadataNode2.setAttribute("value", Double.toString(25.4f / (float)n));
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("VerticalPixelSize");
        iIOMetadataNode3.setAttribute("value", Double.toString(25.4f / (float)n2));
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("Dimension");
        iIOMetadataNode4.appendChild(iIOMetadataNode2);
        iIOMetadataNode4.appendChild(iIOMetadataNode3);
        iIOMetadataNode.appendChild(iIOMetadataNode4);
        iIOMetadata2.mergeTree("javax_imageio_1.0", iIOMetadataNode);
        return iIOMetadata2;
    }

    public static ByteBuffer getImageByteBuffer(IIOImage iIOImage) throws IOException {
        return ImageIOHelper.getImageByteBuffer(iIOImage.getRenderedImage());
    }

    public static ByteBuffer getImageByteBuffer(RenderedImage renderedImage) throws IOException {
        TIFFImageWriteParam tIFFImageWriteParam = new TIFFImageWriteParam(Locale.US);
        tIFFImageWriteParam.setCompressionMode(0);
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(TIFF_FORMAT);
        if (!iterator.hasNext()) {
            throw new RuntimeException(JAI_IMAGE_WRITER_MESSAGE);
        }
        ImageWriter imageWriter = iterator.next();
        IIOMetadata iIOMetadata = imageWriter.getDefaultStreamMetadata((ImageWriteParam)tIFFImageWriteParam);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
        imageWriter.setOutput(imageOutputStream);
        imageWriter.write(iIOMetadata, new IIOImage(renderedImage, null, null), (ImageWriteParam)tIFFImageWriteParam);
        imageWriter.dispose();
        imageOutputStream.seek(0L);
        BufferedImage bufferedImage = ImageIO.read(imageOutputStream);
        return ImageIOHelper.convertImageData(bufferedImage);
    }

    public static ByteBuffer convertImageData(BufferedImage bufferedImage) {
        Object object;
        DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
        if (!(dataBuffer instanceof DataBufferByte)) {
            object = ImageHelper.convertImageToGrayscale(bufferedImage);
            dataBuffer = ((BufferedImage)object).getRaster().getDataBuffer();
        }
        object = ((DataBufferByte)dataBuffer).getData();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(((Object)object).length);
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.put((byte[])object);
        ((Buffer)byteBuffer).flip();
        return byteBuffer;
    }

    public static String getImageFileFormat(File file) {
        String string = file.getName();
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        if (string2.matches("(pbm|pgm|ppm)")) {
            string2 = "pnm";
        } else if (string2.matches("(jp2|j2k|jpf|jpx|jpm)")) {
            string2 = "jpeg2000";
        }
        return string2;
    }

    public static File getImageFile(File file) throws IOException {
        File file2 = file;
        if (file.getName().toLowerCase().endsWith(".pdf")) {
            file2 = PdfUtilities.convertPdf2Tiff(file);
        }
        return file2;
    }

    /*
     * Loose catch block
     */
    public static List<BufferedImage> getImageList(File file) throws IOException {
        File file2 = ImageIOHelper.getImageFile(file);
        ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>();
        String string = ImageIOHelper.getImageFileFormat(file2);
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string);
        if (!iterator.hasNext()) {
            throw new RuntimeException(JAI_IMAGE_READER_MESSAGE);
        }
        ImageReader imageReader = iterator.next();
        try {
            try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(file2);){
                imageReader.setInput(imageInputStream);
                int n = imageReader.getNumImages(true);
                for (int i = 0; i < n; ++i) {
                    BufferedImage bufferedImage = imageReader.read(i);
                    arrayList.add(bufferedImage);
                }
                ArrayList<BufferedImage> arrayList2 = arrayList;
                return arrayList2;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (imageReader != null) {
                imageReader.dispose();
            }
            if (file2 != null && file2.exists() && file2 != file && file2.getName().startsWith("multipage") && file2.getName().endsWith(TIFF_EXT)) {
                file2.delete();
            }
        }
    }

    /*
     * Loose catch block
     */
    public static List<IIOImage> getIIOImageList(File file) throws IOException {
        File file2 = ImageIOHelper.getImageFile(file);
        ArrayList<IIOImage> arrayList = new ArrayList<IIOImage>();
        String string = ImageIOHelper.getImageFileFormat(file2);
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string);
        if (!iterator.hasNext()) {
            throw new RuntimeException(JAI_IMAGE_READER_MESSAGE);
        }
        ImageReader imageReader = iterator.next();
        try {
            try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(file2);){
                imageReader.setInput(imageInputStream);
                int n = imageReader.getNumImages(true);
                for (int i = 0; i < n; ++i) {
                    IIOImage iIOImage = imageReader.readAll(i, imageReader.getDefaultReadParam());
                    arrayList.add(iIOImage);
                }
                ArrayList<IIOImage> arrayList2 = arrayList;
                return arrayList2;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (imageReader != null) {
                imageReader.dispose();
            }
            if (file2 != null && file2.exists() && file2 != file && file2.getName().startsWith("multipage") && file2.getName().endsWith(TIFF_EXT)) {
                file2.delete();
            }
        }
    }

    public static List<IIOImage> getIIOImageList(BufferedImage bufferedImage) throws IOException {
        ArrayList<IIOImage> arrayList = new ArrayList<IIOImage>();
        IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
        arrayList.add(iIOImage);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeTiff(File[] fileArray, File file) throws IOException {
        if (fileArray.length == 0) {
            return;
        }
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(TIFF_FORMAT);
        if (!iterator.hasNext()) {
            throw new RuntimeException(JAI_IMAGE_WRITER_MESSAGE);
        }
        ImageWriter imageWriter = iterator.next();
        TIFFImageWriteParam tIFFImageWriteParam = new TIFFImageWriteParam(Locale.US);
        IIOMetadata iIOMetadata = imageWriter.getDefaultStreamMetadata((ImageWriteParam)tIFFImageWriteParam);
        try (ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file);){
            imageWriter.setOutput(imageOutputStream);
            boolean bl = true;
            int n = 1;
            for (File file2 : fileArray) {
                String string = ImageIOHelper.getImageFileFormat(file2);
                Iterator<ImageReader> iterator2 = ImageIO.getImageReadersByFormatName(string);
                if (!iterator2.hasNext()) {
                    throw new RuntimeException(JAI_IMAGE_READER_MESSAGE);
                }
                ImageReader imageReader = iterator2.next();
                try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(file2);){
                    imageReader.setInput(imageInputStream);
                    int n2 = imageReader.getNumImages(true);
                    for (int i = 0; i < n2; ++i) {
                        IIOImage iIOImage = imageReader.readAll(i, imageReader.getDefaultReadParam());
                        if (bl) {
                            imageWriter.write(iIOMetadata, iIOImage, (ImageWriteParam)tIFFImageWriteParam);
                            bl = false;
                            continue;
                        }
                        imageWriter.writeInsert(n++, iIOImage, (ImageWriteParam)tIFFImageWriteParam);
                    }
                }
                finally {
                    if (imageReader != null) {
                        imageReader.dispose();
                    }
                }
            }
        }
        finally {
            imageWriter.dispose();
        }
    }

    public static void mergeTiff(BufferedImage[] bufferedImageArray, File file) throws IOException {
        ImageIOHelper.mergeTiff(bufferedImageArray, file, null);
    }

    public static void mergeTiff(BufferedImage[] bufferedImageArray, File file, String string) throws IOException {
        ArrayList<IIOImage> arrayList = new ArrayList<IIOImage>();
        for (BufferedImage bufferedImage : bufferedImageArray) {
            arrayList.add(new IIOImage(bufferedImage, null, null));
        }
        ImageIOHelper.mergeTiff(arrayList, file, string);
    }

    public static void mergeTiff(List<IIOImage> list, File file) throws IOException {
        ImageIOHelper.mergeTiff(list, file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeTiff(List<IIOImage> list, File file, String string) throws IOException {
        if (list == null || list.isEmpty()) {
            return;
        }
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(TIFF_FORMAT);
        if (!iterator.hasNext()) {
            throw new RuntimeException(JAI_IMAGE_WRITER_MESSAGE);
        }
        ImageWriter imageWriter = iterator.next();
        TIFFImageWriteParam tIFFImageWriteParam = new TIFFImageWriteParam(Locale.US);
        if (string != null) {
            tIFFImageWriteParam.setCompressionMode(2);
            tIFFImageWriteParam.setCompressionType(string);
        }
        IIOMetadata iIOMetadata = imageWriter.getDefaultStreamMetadata((ImageWriteParam)tIFFImageWriteParam);
        try (ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file);){
            imageWriter.setOutput(imageOutputStream);
            int n = 300;
            int n2 = 300;
            for (IIOImage iIOImage : list) {
                ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromRenderedImage(iIOImage.getRenderedImage());
                ImageWriteParam object = imageWriter.getDefaultWriteParam();
                IIOMetadata iIOMetadata2 = imageWriter.getDefaultImageMetadata(imageTypeSpecifier, object);
                iIOMetadata2 = ImageIOHelper.setDPIViaAPI(iIOMetadata2, n, n2);
                iIOImage.setMetadata(iIOMetadata2);
            }
            IIOImage iIOImage = list.remove(0);
            imageWriter.write(iIOMetadata, iIOImage, (ImageWriteParam)tIFFImageWriteParam);
            int n3 = 1;
            for (IIOImage iIOImage2 : list) {
                imageWriter.writeInsert(n3++, iIOImage2, (ImageWriteParam)tIFFImageWriteParam);
            }
        }
        finally {
            imageWriter.dispose();
        }
    }

    public static File deskewImage(File file, double d) throws IOException {
        List<BufferedImage> list = ImageIOHelper.getImageList(file);
        for (int i = 0; i < list.size(); ++i) {
            BufferedImage bufferedImage = list.get(i);
            ImageDeskew imageDeskew = new ImageDeskew(bufferedImage);
            double d2 = imageDeskew.getSkewAngle();
            if (!(d2 > d) && !(d2 < -d)) continue;
            bufferedImage = ImageUtil.rotate(bufferedImage, -d2, bufferedImage.getWidth() / 2, bufferedImage.getHeight() / 2);
            list.set(i, bufferedImage);
        }
        File file2 = File.createTempFile(FilenameUtils.getBaseName((String)file.getName()), TIFF_EXT);
        ImageIOHelper.mergeTiff(list.toArray(new BufferedImage[0]), file2);
        return file2;
    }

    public static Map<String, String> readImageData(IIOImage iIOImage) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        IIOMetadata iIOMetadata = iIOImage.getMetadata();
        if (iIOMetadata != null) {
            int n;
            int n2;
            IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)iIOMetadata.getAsTree("javax_imageio_1.0");
            NodeList nodeList = iIOMetadataNode.getElementsByTagName("HorizontalPixelSize");
            if (nodeList.getLength() > 0) {
                float f = Float.parseFloat(nodeList.item(0).getAttributes().item(0).getNodeValue());
                n2 = Math.round(25.4f / f);
            } else {
                n2 = Toolkit.getDefaultToolkit().getScreenResolution();
            }
            hashMap.put("dpiX", String.valueOf(n2));
            nodeList = iIOMetadataNode.getElementsByTagName("VerticalPixelSize");
            if (nodeList.getLength() > 0) {
                float f = Float.parseFloat(nodeList.item(0).getAttributes().item(0).getNodeValue());
                n = Math.round(25.4f / f);
            } else {
                n = Toolkit.getDefaultToolkit().getScreenResolution();
            }
            hashMap.put("dpiY", String.valueOf(n));
        }
        return hashMap;
    }
}

