/*
 * Decompiled with CFR 0.152.
 */
package org.ghost4j.renderer;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.ghost4j.Ghostscript;
import org.ghost4j.GhostscriptException;
import org.ghost4j.display.PageRaster;
import org.ghost4j.display.PageRasterDisplayCallback;
import org.ghost4j.document.Document;
import org.ghost4j.document.DocumentException;
import org.ghost4j.document.PDFDocument;
import org.ghost4j.document.PSDocument;
import org.ghost4j.renderer.AbstractRemoteRenderer;
import org.ghost4j.renderer.RendererException;
import org.ghost4j.util.DiskStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRenderer
extends AbstractRemoteRenderer {
    public static final int OPTION_ANTIALIASING_NONE = 0;
    public static final int OPTION_ANTIALIASING_LOW = 1;
    public static final int OPTION_ANTIALIASING_MEDIUM = 2;
    public static final int OPTION_ANTIALIASING_HIGH = 4;
    private int antialiasing = 4;
    private int resolution = 75;

    public SimpleRenderer() {
        this.supportedDocumentClasses = new Class[2];
        this.supportedDocumentClasses[0] = PDFDocument.class;
        this.supportedDocumentClasses[1] = PSDocument.class;
    }

    public static void main(String[] args) throws RendererException {
        SimpleRenderer.startRemoteRenderer(new SimpleRenderer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<PageRaster> run(Document document, int begin, int end) throws IOException, RendererException, DocumentException {
        this.assertDocumentSupported(document);
        Ghostscript gs = Ghostscript.getInstance();
        DiskStore diskStore = DiskStore.getInstance();
        String inputDiskStoreKey = diskStore.generateUniqueKey();
        document.write(diskStore.addFile(inputDiskStoreKey));
        PageRasterDisplayCallback displayCallback = new PageRasterDisplayCallback();
        String[] gsArgs = new String[]{"-dQUIET", "-dNOPAUSE", "-dBATCH", "-dSAFER", "-dFirstPage=" + (begin + 1), "-dLastPage=" + (end + 1), "-sDEVICE=display", "-sDisplayHandle=0", "-dDisplayFormat=16#804", "-r" + this.getResolution()};
        if (this.antialiasing != 0) {
            gsArgs = Arrays.copyOf(gsArgs, gsArgs.length + 2);
            gsArgs[gsArgs.length - 2] = "-dTextAlphaBits=" + this.antialiasing;
            gsArgs[gsArgs.length - 1] = "-dGraphicsAlphaBits=" + this.antialiasing;
        }
        gsArgs = Arrays.copyOf(gsArgs, gsArgs.length + 2);
        gsArgs[gsArgs.length - 2] = "-f";
        gsArgs[gsArgs.length - 1] = diskStore.getFile(inputDiskStoreKey).getAbsolutePath();
        try {
            try {
                Ghostscript ghostscript = gs;
                synchronized (ghostscript) {
                    gs.setDisplayCallback(displayCallback);
                    gs.initialize(gsArgs);
                    gs.exit();
                }
            }
            catch (GhostscriptException e) {
                throw new RendererException(e);
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            try {
                Ghostscript.deleteInstance();
            }
            catch (GhostscriptException e) {
                throw new RendererException(e);
            }
            diskStore.removeFile(inputDiskStoreKey);
            throw throwable;
        }
        try {}
        catch (GhostscriptException e) {
            throw new RendererException(e);
        }
        Ghostscript.deleteInstance();
        diskStore.removeFile(inputDiskStoreKey);
        return displayCallback.getRasters();
    }

    public int getAntialiasing() {
        return this.antialiasing;
    }

    public void setAntialiasing(int antialiasing) {
        this.antialiasing = antialiasing;
    }

    public int getResolution() {
        return this.resolution;
    }

    public void setResolution(int resolution) {
        this.resolution = resolution;
    }
}

