/*
 * Decompiled with CFR 0.152.
 */
package org.ghost4j.modifier;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.ghost4j.Ghostscript;
import org.ghost4j.GhostscriptException;
import org.ghost4j.document.AbstractDocument;
import org.ghost4j.document.Document;
import org.ghost4j.document.DocumentException;
import org.ghost4j.document.PDFDocument;
import org.ghost4j.document.PSDocument;
import org.ghost4j.modifier.AbstractRemoteModifier;
import org.ghost4j.modifier.ModifierException;
import org.ghost4j.util.DiskStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SafeAppenderModifier
extends AbstractRemoteModifier {
    public static final String PARAMETER_APPEND_DOCUMENT = "APPEND_DOCUMENT";

    public SafeAppenderModifier() {
        this.supportedDocumentClasses = new Class[]{PSDocument.class, PDFDocument.class};
    }

    public static void main(String[] args) throws ModifierException {
        SafeAppenderModifier.startRemoteModifier(new SafeAppenderModifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected Document run(Document source, Map<String, Serializable> parameters) throws ModifierException, DocumentException, IOException {
        Document append = (Document)((Object)parameters.get(PARAMETER_APPEND_DOCUMENT));
        if (append == null) {
            throw new ModifierException("No document to append found in parameters map");
        }
        Ghostscript gs = Ghostscript.getInstance();
        DiskStore diskStore = DiskStore.getInstance();
        String sourceDiskStoreKey = diskStore.generateUniqueKey();
        String appendDiskStoreKey = diskStore.generateUniqueKey();
        String outputDiskStoreKey = diskStore.generateUniqueKey();
        source.write(diskStore.addFile(sourceDiskStoreKey));
        append.write(diskStore.addFile(appendDiskStoreKey));
        String deviceName = "pswrite";
        try {
            deviceName = source.getType().equals("PDF") ? "pdfwrite" : (this.isDeviceSupported("ps2write") ? "ps2write" : "pswrite");
        }
        catch (GhostscriptException e) {
            throw new ModifierException(e);
        }
        String[] gsArgs = new String[]{"-psconv", "-dNOPAUSE", "-dSAFER", "-dBATCH", "-sDEVICE=" + deviceName, "-sOutputFile=" + diskStore.addFile(outputDiskStoreKey).getAbsolutePath(), "-q", "-f", diskStore.getFile(sourceDiskStoreKey).getAbsolutePath(), diskStore.getFile(appendDiskStoreKey).getAbsolutePath()};
        AbstractDocument result = null;
        try {
            try {
                Ghostscript ghostscript = gs;
                // MONITORENTER : ghostscript
                gs.initialize(gsArgs);
                gs.exit();
                // MONITOREXIT : ghostscript
                if (source.getType().equals("PDF")) {
                    result = new PDFDocument();
                } else if (source.getType().equals("PostScript")) {
                    result = new PSDocument();
                }
                result.load(diskStore.getFile(outputDiskStoreKey));
            }
            catch (GhostscriptException e) {
                throw new ModifierException(e);
            }
            Object var15_15 = null;
            try {
                Ghostscript.deleteInstance();
            }
            catch (GhostscriptException e) {
                throw new ModifierException(e);
            }
            diskStore.removeFile(outputDiskStoreKey);
            diskStore.removeFile(sourceDiskStoreKey);
            diskStore.removeFile(appendDiskStoreKey);
            return result;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            try {}
            catch (GhostscriptException e) {
                throw new ModifierException(e);
            }
            Ghostscript.deleteInstance();
            diskStore.removeFile(outputDiskStoreKey);
            diskStore.removeFile(sourceDiskStoreKey);
            diskStore.removeFile(appendDiskStoreKey);
            throw throwable;
        }
    }
}

