/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.spatial;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.gco.GO_Measure;
import org.apache.sis.internal.jaxb.gco.InternationalStringAdapter;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.spatial.Dimension;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.util.InternationalString;

@TitleProperty(name="dimensionName")
@XmlType(name="MD_Dimension_Type", propOrder={"dimensionName", "dimensionSize", "resolution", "dimensionTitle", "dimensionDescription"})
@XmlRootElement(name="MD_Dimension")
public class DefaultDimension
extends ISOMetadata
implements Dimension {
    private static final long serialVersionUID = 1104542984724265236L;
    private DimensionNameType dimensionName;
    private Integer dimensionSize;
    private Double resolution;
    private InternationalString dimensionTitle;
    private InternationalString dimensionDescription;

    public DefaultDimension() {
    }

    public DefaultDimension(DimensionNameType dimensionNameType, int n) {
        ArgumentChecks.ensurePositive("dimensionSize", n);
        this.dimensionName = dimensionNameType;
        this.dimensionSize = n;
    }

    public DefaultDimension(Dimension dimension) {
        super(dimension);
        if (dimension != null) {
            this.dimensionName = dimension.getDimensionName();
            this.dimensionSize = dimension.getDimensionSize();
            this.resolution = dimension.getResolution();
            if (dimension instanceof DefaultDimension) {
                this.dimensionTitle = ((DefaultDimension)dimension).getDimensionTitle();
                this.dimensionDescription = ((DefaultDimension)dimension).getDimensionDescription();
            }
        }
    }

    public static DefaultDimension castOrCopy(Dimension dimension) {
        if (dimension == null || dimension instanceof DefaultDimension) {
            return (DefaultDimension)dimension;
        }
        return new DefaultDimension(dimension);
    }

    @XmlElement(name="dimensionName", required=true)
    public DimensionNameType getDimensionName() {
        return this.dimensionName;
    }

    public void setDimensionName(DimensionNameType dimensionNameType) {
        this.checkWritePermission(this.dimensionName);
        this.dimensionName = dimensionNameType;
    }

    @ValueRange(minimum=0.0)
    @XmlElement(name="dimensionSize", required=true)
    public Integer getDimensionSize() {
        return this.dimensionSize;
    }

    public void setDimensionSize(Integer n) {
        this.checkWritePermission(this.dimensionSize);
        if (MetadataUtilities.ensurePositive(DefaultDimension.class, "dimensionSize", false, n)) {
            this.dimensionSize = n;
        }
    }

    @ValueRange(minimum=0.0, isMinIncluded=false)
    @XmlJavaTypeAdapter(value=GO_Measure.class)
    @XmlElement(name="resolution")
    public Double getResolution() {
        return this.resolution;
    }

    public void setResolution(Double d) {
        this.checkWritePermission(this.resolution);
        if (MetadataUtilities.ensurePositive(DefaultDimension.class, "resolution", true, d)) {
            this.resolution = d;
        }
    }

    @XmlElement(name="dimensionTitle")
    @XmlJavaTypeAdapter(value=InternationalStringAdapter.Since2014.class)
    @UML(identifier="dimensionTitle", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InternationalString getDimensionTitle() {
        return this.dimensionTitle;
    }

    public void setDimensionTitle(InternationalString internationalString) {
        this.checkWritePermission(this.dimensionTitle);
        this.dimensionTitle = internationalString;
    }

    @XmlElement(name="dimensionDescription")
    @XmlJavaTypeAdapter(value=InternationalStringAdapter.Since2014.class)
    @UML(identifier="dimensionDescription", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InternationalString getDimensionDescription() {
        return this.dimensionDescription;
    }

    public void setDimensionDescription(InternationalString internationalString) {
        this.checkWritePermission(this.dimensionDescription);
        this.dimensionDescription = internationalString;
    }
}

