/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.iso14496.part12;

import java.util.ArrayList;
import java.util.List;
import org.mp4parser.boxes.iso14496.part12.SampleDependencyTypeBox;
import org.mp4parser.boxes.iso14496.part12.TrackFragmentBox;
import org.mp4parser.boxes.iso14496.part12.TrackFragmentHeaderBox;
import org.mp4parser.boxes.iso14496.part12.TrackRunBox;
import org.mp4parser.support.AbstractContainerBox;
import org.mp4parser.tools.Path;

public class MovieFragmentBox
extends AbstractContainerBox {
    public static final String TYPE = "moof";

    public MovieFragmentBox() {
        super(TYPE);
    }

    public List<Long> getSyncSamples(SampleDependencyTypeBox sdtp) {
        ArrayList<Long> result = new ArrayList<Long>();
        List<SampleDependencyTypeBox.Entry> sampleEntries = sdtp.getEntries();
        long i = 1L;
        for (SampleDependencyTypeBox.Entry sampleEntry : sampleEntries) {
            if (sampleEntry.getSampleDependsOn() == 2) {
                result.add(i);
            }
            ++i;
        }
        return result;
    }

    public int getTrackCount() {
        return this.getBoxes(TrackFragmentBox.class, false).size();
    }

    public long[] getTrackNumbers() {
        List<TrackFragmentBox> trackBoxes = this.getBoxes(TrackFragmentBox.class, false);
        long[] trackNumbers = new long[trackBoxes.size()];
        int trackCounter = 0;
        while (trackCounter < trackBoxes.size()) {
            TrackFragmentBox trackBoxe = trackBoxes.get(trackCounter);
            trackNumbers[trackCounter] = trackBoxe.getTrackFragmentHeaderBox().getTrackId();
            ++trackCounter;
        }
        return trackNumbers;
    }

    public List<TrackFragmentHeaderBox> getTrackFragmentHeaderBoxes() {
        return Path.getPaths(this, "tfhd");
    }

    public List<TrackRunBox> getTrackRunBoxes() {
        return this.getBoxes(TrackRunBox.class, true);
    }
}

