/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.converter;

import java.util.EnumSet;
import java.util.Set;
import org.apache.sis.internal.converter.SystemConverter;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.ObjectConverter;

public final class IdentityConverter<S extends T, T>
extends SystemConverter<S, T> {
    private static final long serialVersionUID = -4410848323263094741L;
    private final ObjectConverter<T, S> inverse;

    public IdentityConverter(Class<S> clazz, Class<T> clazz2, ObjectConverter<T, S> identityConverter) {
        super(clazz, clazz2);
        if (identityConverter == null && clazz == clazz2) {
            identityConverter = this;
        }
        this.inverse = identityConverter;
    }

    @Override
    public Set<FunctionProperty> properties() {
        EnumSet<FunctionProperty> enumSet = EnumSet.allOf(FunctionProperty.class);
        if (this.inverse == null) {
            enumSet.remove((Object)FunctionProperty.INVERTIBLE);
        }
        return enumSet;
    }

    @Override
    public ObjectConverter<T, S> inverse() throws UnsupportedOperationException {
        return this.inverse != null ? this.inverse : super.inverse();
    }

    @Override
    public T apply(S s) {
        return (T)s;
    }
}

