/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.apache.sis.xml.NilObject;
import org.apache.sis.xml.NilReason;

public enum ValueExistencePolicy {
    ALL{

        @Override
        boolean isSkipped(Object object) {
            return false;
        }

        @Override
        boolean substituteByNullElement(Collection<?> collection) {
            return collection == null || collection.isEmpty();
        }
    }
    ,
    NON_NULL{

        @Override
        boolean isSkipped(Object object) {
            return object == null;
        }

        @Override
        boolean substituteByNullElement(Collection<?> collection) {
            return collection != null && collection.isEmpty();
        }
    }
    ,
    NON_NIL{

        @Override
        boolean isSkipped(Object object) {
            return object == null || object instanceof NilObject || NilReason.forObject(object) != null;
        }

        @Override
        boolean substituteByNullElement(Collection<?> collection) {
            return collection != null && collection.isEmpty();
        }
    }
    ,
    NON_EMPTY{

        @Override
        boolean isSkipped(Object object) {
            return 4.isNullOrEmpty(object);
        }

        @Override
        boolean substituteByNullElement(Collection<?> collection) {
            return false;
        }
    }
    ,
    COMPACT{

        @Override
        boolean isSkipped(Object object) {
            return 5.isNullOrEmpty(object);
        }

        @Override
        boolean substituteByNullElement(Collection<?> collection) {
            return false;
        }
    };


    abstract boolean isSkipped(Object var1);

    abstract boolean substituteByNullElement(Collection<?> var1);

    static boolean isNullOrEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof NilObject) {
            return true;
        }
        if (object instanceof CharSequence) {
            return ValueExistencePolicy.isEmpty((CharSequence)object);
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object) == 0;
        }
        return NilReason.forObject(object) != null;
    }

    private static boolean isEmpty(CharSequence charSequence) {
        int n;
        int n2 = charSequence.length();
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = Character.codePointAt(charSequence, i);
            if (Character.isWhitespace(n)) continue;
            return false;
        }
        return true;
    }
}

