/*
 * Decompiled with CFR 0.152.
 */
package gnu.cajo.utils;

import gnu.cajo.invoke.Invoke;
import gnu.cajo.invoke.Remote;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.MarshalledObject;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;

public class MonitorItem
implements Invoke {
    private final OutputStream os;
    private long count;
    private long oldtime = System.currentTimeMillis();
    public static boolean CLASSOFF;
    public boolean LOCALOFF;
    public final Object item;

    public MonitorItem(Object item) {
        this(item, System.out);
    }

    public MonitorItem(Object item, OutputStream os) {
        this.item = item;
        this.os = os instanceof PrintStream ? os : new PrintStream(os);
    }

    public MonitorItem(Object item, ObjectOutputStream os) {
        this.item = item;
        this.os = os;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object invoke(String method, Object args) throws Exception {
        if (CLASSOFF || this.LOCALOFF) {
            return Remote.invoke(this.item, method, args);
        }
        long time = System.currentTimeMillis();
        Object result = null;
        Object object = result = Remote.invoke(this.item, method, args);
        Object var8_7 = null;
        int run = (int)(System.currentTimeMillis() - time);
        String clientHost = null;
        try {
            clientHost = RemoteServer.getClientHost();
        }
        catch (ServerNotActiveException x2) {
            StackTraceElement[] stes = x2.getStackTrace();
            StringBuffer sb = new StringBuffer("localhost <trace>");
            for (int i = 4; i < stes.length; ++i) {
                sb.append("\n     method = ").append(stes[i].getClassName());
                sb.append('.').append(stes[i].getMethodName());
                if (stes[i].getLineNumber() < 0) continue;
                sb.append("\n     file   = ");
                sb.append(stes[i].getFileName());
                sb.append(" line ").append(stes[i].getLineNumber());
            }
            clientHost = sb.toString();
        }
        Runtime rt = Runtime.getRuntime();
        int freeMemory = (int)(rt.freeMemory() * 100L / rt.totalMemory());
        ObjectOutputStream oos = this.os instanceof ObjectOutputStream ? (ObjectOutputStream)this.os : null;
        PrintStream ps = this.os instanceof PrintStream ? (PrintStream)this.os : null;
        OutputStream outputStream = this.os;
        synchronized (outputStream) {
            try {
                if (oos != null) {
                    oos.writeObject(new MarshalledObject<Object[]>(new Object[]{clientHost, this.item.getClass().getName() + " hashcode " + this.item.hashCode(), method, args, result, new Long(++this.count), new Long(time), new Long(time - this.oldtime), new Integer(run), new Integer(freeMemory)}));
                    oos.flush();
                } else if (ps != null) {
                    int i;
                    ps.print("Caller host = ");
                    ps.print(clientHost);
                    ps.print("\nObject call = ");
                    ps.print(this.item.getClass().getName() + " hashcode " + this.item.hashCode());
                    ps.print("\nMethod call = ");
                    ps.print(method);
                    ps.print("\nMethod args = ");
                    if (args instanceof MarshalledObject) {
                        args = ((MarshalledObject)args).get();
                    }
                    if (args instanceof Object[]) {
                        ps.print("array");
                        for (i = 0; i < ((Object[])args).length; ++i) {
                            ps.print("\n\t[");
                            ps.print(i);
                            ps.print("] = ");
                            ps.print(((Object[])args)[i] != null ? ((Object[])args)[i].toString() : "null");
                        }
                    } else {
                        ps.print(args != null ? args.toString() : "none");
                    }
                    ps.print("\nResult data = ");
                    if (result instanceof MarshalledObject) {
                        result = ((MarshalledObject)result).get();
                    }
                    if (result instanceof Exception) {
                        ((Exception)result).printStackTrace(ps);
                    } else if (result instanceof Object[]) {
                        ps.print("array");
                        for (i = 0; i < ((Object[])result).length; ++i) {
                            ps.print("\n\t[");
                            ps.print(i);
                            ps.print("] = ");
                            if (((Object[])result)[i] != null) {
                                ps.print(((Object[])result)[i].toString());
                                continue;
                            }
                            ps.print("null");
                        }
                        ps.println();
                    } else {
                        ps.println(result != null ? result.toString() : "void");
                    }
                    ps.print("Call count  = ");
                    ps.print(++this.count);
                    ps.print("\nTime stamp  = ");
                    ps.print(time);
                    ps.print("\nIdle time   = ");
                    ps.print(time - this.oldtime);
                    ps.print(" ms");
                    ps.print("\nBusy time   = ");
                    ps.print(run);
                    ps.print(" ms");
                    ps.print("\nFree memory = ");
                    ps.print(freeMemory);
                    ps.print("%\n\n");
                }
            }
            catch (Exception x3) {
                x3.printStackTrace();
            }
            this.oldtime = time;
        }
        return object;
        catch (Exception x) {
            try {
                result = x;
                throw x;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                run = (int)(System.currentTimeMillis() - time);
                clientHost = null;
                try {
                    clientHost = RemoteServer.getClientHost();
                }
                catch (ServerNotActiveException x2) {
                    StackTraceElement[] stes = x2.getStackTrace();
                    StringBuffer sb = new StringBuffer("localhost <trace>");
                    for (int i = 4; i < stes.length; ++i) {
                        sb.append("\n     method = ").append(stes[i].getClassName());
                        sb.append('.').append(stes[i].getMethodName());
                        if (stes[i].getLineNumber() < 0) continue;
                        sb.append("\n     file   = ");
                        sb.append(stes[i].getFileName());
                        sb.append(" line ").append(stes[i].getLineNumber());
                    }
                    clientHost = sb.toString();
                }
                rt = Runtime.getRuntime();
                freeMemory = (int)(rt.freeMemory() * 100L / rt.totalMemory());
                oos = this.os instanceof ObjectOutputStream ? (ObjectOutputStream)this.os : null;
                ps = this.os instanceof PrintStream ? (PrintStream)this.os : null;
                OutputStream outputStream2 = this.os;
                synchronized (outputStream2) {
                    try {
                        if (oos != null) {
                            oos.writeObject(new MarshalledObject<Object[]>(new Object[]{clientHost, this.item.getClass().getName() + " hashcode " + this.item.hashCode(), method, args, result, new Long(++this.count), new Long(time), new Long(time - this.oldtime), new Integer(run), new Integer(freeMemory)}));
                            oos.flush();
                        } else if (ps != null) {
                            int i;
                            ps.print("Caller host = ");
                            ps.print(clientHost);
                            ps.print("\nObject call = ");
                            ps.print(this.item.getClass().getName() + " hashcode " + this.item.hashCode());
                            ps.print("\nMethod call = ");
                            ps.print(method);
                            ps.print("\nMethod args = ");
                            if (args instanceof MarshalledObject) {
                                args = ((MarshalledObject)args).get();
                            }
                            if (args instanceof Object[]) {
                                ps.print("array");
                                for (i = 0; i < ((Object[])args).length; ++i) {
                                    ps.print("\n\t[");
                                    ps.print(i);
                                    ps.print("] = ");
                                    ps.print(((Object[])args)[i] != null ? ((Object[])args)[i].toString() : "null");
                                }
                            } else {
                                ps.print(args != null ? args.toString() : "none");
                            }
                            ps.print("\nResult data = ");
                            if (result instanceof MarshalledObject) {
                                result = ((MarshalledObject)result).get();
                            }
                            if (result instanceof Exception) {
                                ((Exception)result).printStackTrace(ps);
                            } else if (result instanceof Object[]) {
                                ps.print("array");
                                for (i = 0; i < ((Object[])result).length; ++i) {
                                    ps.print("\n\t[");
                                    ps.print(i);
                                    ps.print("] = ");
                                    if (((Object[])result)[i] != null) {
                                        ps.print(((Object[])result)[i].toString());
                                        continue;
                                    }
                                    ps.print("null");
                                }
                                ps.println();
                            } else {
                                ps.println(result != null ? result.toString() : "void");
                            }
                            ps.print("Call count  = ");
                            ps.print(++this.count);
                            ps.print("\nTime stamp  = ");
                            ps.print(time);
                            ps.print("\nIdle time   = ");
                            ps.print(time - this.oldtime);
                            ps.print(" ms");
                            ps.print("\nBusy time   = ");
                            ps.print(run);
                            ps.print(" ms");
                            ps.print("\nFree memory = ");
                            ps.print(freeMemory);
                            ps.print("%\n\n");
                        }
                    }
                    catch (Exception x3) {
                        x3.printStackTrace();
                    }
                    this.oldtime = time;
                }
                throw throwable;
            }
        }
    }
}

