/*
 * Decompiled with CFR 0.152.
 */
package org.ghost4j.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Map;
import org.ghost4j.util.StreamGobbler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFork
implements Runnable {
    private static final String JAVA_COMMAND;
    private static final String PATH_SEPARATOR;
    private Class<?> startClass;
    private Process process;
    private boolean redirectStreams;
    private boolean waitBeforeExiting = false;
    private Map<String, String> environment;
    private String xmx = "128m";
    private String xms = "64m";

    public void start(Class<?> startClass) {
        this.setStartClass(startClass);
        this.start();
    }

    public void start() {
        final Thread thread = new Thread(this);
        thread.setDaemon(false);
        thread.start();
        if (this.waitBeforeExiting) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public void stop() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    @Override
    public void run() {
        if (this.process != null) {
            throw new RuntimeException("Fork is already running");
        }
        if (this.startClass == null) {
            throw new RuntimeException("No start class defined");
        }
        String classPath = this.getCurrentClasspath();
        String ghost4JEncoding = System.getProperty("ghost4j.encoding");
        String fileEncoding = "-Dfile.encoding=";
        fileEncoding = ghost4JEncoding != null ? fileEncoding + ghost4JEncoding : fileEncoding + System.getProperty("file.encoding");
        ProcessBuilder processBuilder = new ProcessBuilder(JAVA_COMMAND, fileEncoding, "-Xms" + this.xms, "-Xmx" + this.xmx, "-cp", classPath, this.startClass.getName());
        if (System.getProperty("jna.library.path") != null) {
            String jnaLibraryPath = "-Djna.library.path=" + System.getProperty("jna.library.path");
            processBuilder = new ProcessBuilder(JAVA_COMMAND, fileEncoding, jnaLibraryPath, "-Xms" + this.xms, "-Xmx" + this.xmx, "-cp", classPath, this.startClass.getName());
        }
        processBuilder.directory(new File(System.getProperty("user.dir")));
        processBuilder.environment().putAll(System.getenv());
        if (this.getEnvironment() != null) {
            processBuilder.environment().putAll(this.getEnvironment());
        }
        try {
            this.process = processBuilder.start();
            if (this.redirectStreams) {
                processBuilder.redirectErrorStream(true);
                StreamGobbler outputStreamGobbler = new StreamGobbler(this.process.getInputStream(), System.out);
                outputStreamGobbler.start();
            }
            this.process.waitFor();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getCurrentClasspath() {
        StringBuilder cpBuilder = new StringBuilder();
        URL[] urls = ((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs();
        for (int i = 0; i < urls.length; ++i) {
            String s = urls[i].toExternalForm();
            try {
                s = URLDecoder.decode(s, "UTF-8");
                urls[i] = new URL(s);
                s = new File(urls[i].getFile()).getAbsolutePath();
                cpBuilder.append(s);
                if (i >= urls.length - 1) continue;
                cpBuilder.append(PATH_SEPARATOR);
                continue;
            }
            catch (UnsupportedEncodingException e) {
                continue;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        String cp = cpBuilder.toString();
        if (cp.isEmpty() || cp.contains("surefirebooter")) {
            return System.getProperty("java.class.path");
        }
        return cp;
    }

    public Class<?> getStartClass() {
        return this.startClass;
    }

    public void setStartClass(Class<?> startClass) {
        this.startClass = startClass;
    }

    public boolean getRedirectStreams() {
        return this.redirectStreams;
    }

    public void setRedirectStreams(boolean redirectStreams) {
        this.redirectStreams = redirectStreams;
    }

    public boolean getWaitBeforeExiting() {
        return this.waitBeforeExiting;
    }

    public void setWaitBeforeExiting(boolean waitBeforeExiting) {
        this.waitBeforeExiting = waitBeforeExiting;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public String getXmx() {
        return this.xmx;
    }

    public void setXmx(String xmx) {
        this.xmx = xmx;
    }

    public String getXms() {
        return this.xms;
    }

    public void setXms(String xms) {
        this.xms = xms;
    }

    static {
        PATH_SEPARATOR = System.getProperty("path.separator");
        JAVA_COMMAND = System.getProperty("os.name").toLowerCase().contains("windows") ? "javaw" : "java";
    }
}

