/*
 * Decompiled with CFR 0.152.
 */
package org.ghost4j.util;

import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import org.ghost4j.display.PageRaster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageUtil {
    public static List<Image> convertPageRastersToImages(List<PageRaster> rasters) {
        ArrayList<Image> result = new ArrayList<Image>();
        for (PageRaster raster : rasters) {
            result.add(ImageUtil.converterPageRasterToImage(raster));
        }
        return result;
    }

    public static Image converterPageRasterToImage(PageRaster raster) {
        DataBufferByte dbb = new DataBufferByte(raster.getData(), raster.getData().length);
        WritableRaster wr = Raster.createInterleavedRaster(dbb, raster.getWidth(), raster.getHeight(), raster.getRaster(), 3, new int[]{0, 1, 2}, null);
        ColorSpace cs = ColorSpace.getInstance(1000);
        ComponentColorModel cm = new ComponentColorModel(cs, false, false, 1, 0);
        return new BufferedImage(cm, wr, false, null);
    }
}

