/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tess4j.util;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.sourceforge.tess4j.TessAPI;
import net.sourceforge.tess4j.util.LoggHelper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadLibs {
    private static final String VFS_PROTOCOL = "vfs";
    private static final String JNA_LIBRARY_PATH = "jna.library.path";
    public static final String TESS4J_TEMP_DIR = new File(System.getProperty("java.io.tmpdir"), "tess4j").getPath();
    public static final String LIB_NAME = "libtesseract410";
    public static final String LIB_NAME_NON_WIN = "tesseract";
    private static final Logger logger = LoggerFactory.getLogger((String)new LoggHelper().toString());

    public static TessAPI getTessAPIInstance() {
        return (TessAPI)Native.loadLibrary((String)LoadLibs.getTesseractLibName(), TessAPI.class);
    }

    public static String getTesseractLibName() {
        return Platform.isWindows() ? LIB_NAME : LIB_NAME_NON_WIN;
    }

    public static synchronized File extractTessResources(String string) {
        File file = null;
        try {
            file = new File(TESS4J_TEMP_DIR, string);
            Enumeration<URL> enumeration = LoadLibs.class.getClassLoader().getResources(string);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                LoadLibs.copyResources(uRL, file);
            }
        }
        catch (IOException | URISyntaxException exception) {
            logger.warn(exception.getMessage(), (Throwable)exception);
        }
        return file;
    }

    static void copyResources(URL uRL, File file) throws IOException, URISyntaxException {
        if (uRL == null) {
            return;
        }
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof JarURLConnection) {
            LoadLibs.copyJarResourceToPath((JarURLConnection)uRLConnection, file);
        } else if (VFS_PROTOCOL.equals(uRL.getProtocol())) {
            VirtualFile virtualFile = VFS.getChild((URI)uRL.toURI());
            LoadLibs.copyFromWarToFolder(virtualFile, file);
        } else {
            File file2 = new File(uRL.getPath());
            if (file2.isDirectory()) {
                for (File file3 : FileUtils.listFiles((File)file2, null, (boolean)true)) {
                    int n = file3.getPath().lastIndexOf(file.getName()) + file.getName().length();
                    File file4 = new File(file, file3.getPath().substring(n));
                    if (file4.exists() && file4.length() == file3.length() || !file3.isFile()) continue;
                    FileUtils.copyFile((File)file3, (File)file4);
                }
            } else if (!file.exists() || file.length() != file2.length()) {
                FileUtils.copyFile((File)file2, (File)file);
            }
        }
    }

    static void copyJarResourceToPath(JarURLConnection jarURLConnection, File file) {
        try (JarFile jarFile = jarURLConnection.getJarFile();){
            String string = jarURLConnection.getEntryName();
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                String string2 = jarEntry.getName();
                if (!string2.startsWith(string)) continue;
                String string3 = string2.substring(string.length());
                File file2 = new File(file, string3);
                if (jarEntry.isDirectory()) {
                    file2.mkdirs();
                    continue;
                }
                if (file2.exists() && file2.length() == jarEntry.getSize()) continue;
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                try {
                    FileOutputStream fileOutputStream = FileUtils.openOutputStream((File)file2);
                    try {
                        IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
                    }
                    finally {
                        if (fileOutputStream == null) continue;
                        ((OutputStream)fileOutputStream).close();
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            logger.warn(iOException.getMessage(), (Throwable)iOException);
        }
    }

    static void copyFromWarToFolder(VirtualFile virtualFile, File file) throws IOException {
        if (virtualFile.isDirectory() && !virtualFile.getName().contains(".")) {
            if (file.getName().equalsIgnoreCase(virtualFile.getName())) {
                for (VirtualFile virtualFile2 : virtualFile.getChildren()) {
                    LoadLibs.copyFromWarToFolder(virtualFile2, file);
                }
            } else {
                File file2 = new File(file, virtualFile.getName());
                file2.mkdir();
                for (VirtualFile virtualFile3 : virtualFile.getChildren()) {
                    LoadLibs.copyFromWarToFolder(virtualFile3, file2);
                }
            }
        } else {
            File file3 = new File(file, virtualFile.getName());
            if (!file3.exists() || file3.length() != virtualFile.getSize()) {
                FileUtils.copyURLToFile((URL)virtualFile.asFileURL(), (File)file3);
            }
        }
    }

    static {
        System.setProperty("jna.encoding", "UTF8");
        String string = System.getProperty("sun.arch.data.model", System.getProperty("com.ibm.vm.bitmode"));
        String string2 = "32".equals(string) ? "win32-x86" : "win32-x86-64";
        File file = LoadLibs.extractTessResources(string2);
        if (file != null && file.exists()) {
            String string3 = System.getProperty(JNA_LIBRARY_PATH);
            if (null == string3 || string3.isEmpty()) {
                System.setProperty(JNA_LIBRARY_PATH, file.getPath());
            } else {
                System.setProperty(JNA_LIBRARY_PATH, string3 + File.pathSeparator + file.getPath());
            }
        }
    }
}

