#!/bin/sh
# postinst script for benno-milter
#
# see: dh_installdeb(1)

set -e

# summary of how this script can be called:
#        * <postinst> `configure' <most-recently-configured-version>
#        * <old-postinst> `abort-upgrade' <new version>
#        * <conflictor's-postinst> `abort-remove' `in-favour' <package>
#          <new-version>
#        * <postinst> `abort-remove'
#        * <deconfigured's-postinst> `abort-deconfigure' `in-favour'
#          <failed-install-package> <version> `removing'
#          <conflicting-package> <version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package

show_hints()
{
    if [ ! -d /var/spool/postfix ];then
        echo "Please install Postfix or set SOCKET_TYPE=inet in /etc/default/benno-milter"
    fi
    echo "Changes settings in /etc/default/benno-milter to match your MTA configuration."
    echo ""
    echo "MILTER_GROUP=benno"
    echo "SOCKET_TYPE=inet"
    echo "SOCKET=22500@127.0.0.1"
    echo ""
    echo ""

    exit 1
}

case "$1" in
    configure)
    ;;

    abort-upgrade|abort-remove|abort-deconfigure)
    ;;

    *)
        echo "postinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac


# dh_installdeb will replace this with shell code automatically
# generated by other debhelper scripts.

# Automatically added by dh_systemd_enable/12.10ubuntu1
if [ "$1" = "configure" ] || [ "$1" = "abort-upgrade" ] || [ "$1" = "abort-deconfigure" ] || [ "$1" = "abort-remove" ] ; then
	# This will only remove masks created by d-s-h on package removal.
	deb-systemd-helper unmask 'benno-milter.service' >/dev/null || true

	# was-enabled defaults to true, so new installations run enable.
	if deb-systemd-helper --quiet was-enabled 'benno-milter.service'; then
		# Enables the unit on first installation, creates new
		# symlinks on upgrades if the unit file has changed.
		deb-systemd-helper enable 'benno-milter.service' >/dev/null || true
	else
		# Update the statefile to add new symlinks (if any), which need to be
		# cleaned up on purge. Also remove old symlinks.
		deb-systemd-helper update-state 'benno-milter.service' >/dev/null || true
	fi
fi
# End automatically added section
# Automatically added by dh_systemd_start/12.10ubuntu1
if [ "$1" = "configure" ] || [ "$1" = "abort-upgrade" ] || [ "$1" = "abort-deconfigure" ] || [ "$1" = "abort-remove" ] ; then
	if [ -d /run/systemd/system ]; then
		systemctl --system daemon-reload >/dev/null || true
		if [ -n "$2" ]; then
			_dh_action=restart
		else
			_dh_action=start
		fi
		deb-systemd-invoke $_dh_action 'benno-milter.service' >/dev/null || true
	fi
fi
# End automatically added section
# Automatically added by dh_installinit/12.10ubuntu1
if [ "$1" = "configure" ] || [ "$1" = "abort-upgrade" ] || [ "$1" = "abort-deconfigure" ] || [ "$1" = "abort-remove" ] ; then
	if [ -x "/etc/init.d/benno-milter" ]; then
		update-rc.d benno-milter defaults >/dev/null
		if [ -n "$2" ]; then
			_dh_action=restart
		else
			_dh_action=start
		fi
		invoke-rc.d benno-milter $_dh_action || exit 1
	fi
fi
# End automatically added section


exit 0
