#!/bin/sh
# preinst script for benno-archive
#

set -e

# summary of how this script can be called:
#        * <new-preinst> `install'
#        * <new-preinst> `install' <old-version>
#        * <new-preinst> `upgrade' <old-version>
#        * <old-preinst> `abort-upgrade' <new-version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package

case "$1" in
    install|upgrade)
        [ -z "$MILTER_PORT" ] && MILTER_PORT=22500@0.0.0.0
        [ -z "$SERVER_USER" ] && SERVER_USER=benno
        [ -z "$SERVER_GROUP" ] && SERVER_GROUP=benno
        [ -z "$INBOX_DIR" ] && INBOX_DIR=/srv/benno/inbox

        if ! getent passwd | grep -q "^$SERVER_USER:"; then
            echo -n "Adding system user $SERVER_USER.."
            adduser --quiet --system \
                    --group \
                    --home /srv/benno \
                    --disabled-password $SERVER_USER 2>/dev/null || true
            adduser --quiet $SERVER_USER $SERVER_GROUP || true
            echo "..done"
        fi

        if [ ! -d $INBOX_DIR ];then
            mkdir -p $INBOX_DIR
            chown $SERVER_USER:$SERVER_USER $INBOX_DIR
            chmod u=rwx,g=rwx,o= $INBOX_DIR
        fi
    ;;

    abort-upgrade)
    ;;

    *)
        echo "preinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac

# dh_installdeb will replace this with shell code automatically
# generated by other debhelper scripts.



exit 0
