#!/bin/sh
# postinst script for benno-oauth2.
#
# See: dh_installdeb(1).

set -e

# Summary of how this script can be called:
#        * <postinst> 'configure' <most-recently-configured-version>
#        * <old-postinst> 'abort-upgrade' <new version>
#        * <conflictor's-postinst> 'abort-remove' 'in-favour' <package>
#          <new-version>
#        * <postinst> 'abort-remove'
#        * <deconfigured's-postinst> 'abort-deconfigure' 'in-favour'
#          <failed-install-package> <version> 'removing'
#          <conflicting-package> <version>
# for details, see https://www.debian.org/doc/debian-policy/ or
# the debian-policy package.

case "$1" in
    configure)
        [ -L /srv/benno/bennoweb/htdocs/ctrl/oauth2_login.php  ]    || ln -s /srv/benno/oauth2/benno-web/oauth2_login.php      /srv/benno/bennoweb/htdocs/ctrl
        [ -L /srv/benno/bennoweb/htdocs/ctrl/oauth2_logout.php ]    || ln -s /srv/benno/oauth2/benno-web/oauth2_logout.php     /srv/benno/bennoweb/htdocs/ctrl

        chown www-data:www-data /var/lib/benno-oauth2/sessions
        if [ -d /etc/apache2/conf-enabled ];then
            if [ ! -L /etc/apache2/conf-available/benno-oauth2.conf ];then
                ln -s /etc/benno-oauth2/apache2.conf /etc/apache2/conf-available/benno-oauth2.conf && a2enconf benno-oauth2
                systemctl reload apache2

                [ -e /etc/benno-oauth2/idpClients.yml ]                 || /bin/cp /usr/share/doc/benno-oauth2/idpClients.yml /etc/benno-oauth2/idpClients.yml
                [ -e /etc/benno-oauth2/issuer.map ]                     || /bin/cp /usr/share/doc/benno-oauth2/issuer.map /etc/benno-oauth2/issuer.map
                [ -L /etc/benno-web/auth.d/20_oauth2_containermapping ] || ln -s /usr/share/benno-oauth2/oauth2_containermapping /etc/benno-web/auth.d/20_oauth2_containermapping
            fi
        else
            echo "Please configure webserver connection manually."
        fi
    ;;

    abort-upgrade|abort-remove|abort-deconfigure)
    ;;

    *)
        echo "postinst called with unknown argument '$1'" >&2
        exit 1
    ;;
esac

# dh_installdeb will replace this with shell code automatically
# generated by other debhelper scripts.



exit 0

