<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

$AppConf = new ApplicationConfig($App->getConfig('OAUTH2_CONFIGDIR','/etc/benno-oauth2'));
$AppConf->load('app.conf');

define('BENNO_OAUTH2_LIBPATH',  $AppConf->getConfig('LIBPATH','/srv/benno/oauth2'));
define('BENNO_URL_BASE',        dirname($_SERVER['SCRIPT_NAME']));

$redirectParam['MSG'] = 'ERR_OAUTH2';

if (!is_readable(BENNO_OAUTH2_LIBPATH)) {
    $App->log('OAUTH2_LIBPATH "'.BENNO_OAUTH2_LIBPATH.'" does not exist. Package benno-oauth2 not installed?');
    $App->redirect('default',$redirectParam, dirname($_SERVER['SCRIPT_NAME']));
    exit ();
}
ini_set('include_path',ini_get('include_path').':'.BENNO_OAUTH2_LIBPATH);

use Symfony\Component\Yaml\Yaml;
use Symfony\Component\Yaml\Exception;

require_once 'vendor/autoload.php';
require_once 'openid/client/ClientSelector.php';
require_once 'openid/SessionState.php';
require_once 'openid/Userinfo.php';
require_once 'model/Filter.php';
require_once 'model/AppState.php';

$redirectParam['MSG'] = 'ERR_OAUTH2';

$bennoPath      = $AppConf->getConfig('BENNO2_PATH', '/index.php?CA=greeting');
$idpClientsYml  = $AppConf->getConfig('IDP_CLIENTS_YML','/etc/benno-oauth2/idpClients.yml');

$idp_client      = $App->getParam('idp-client');


if (!$idp_client) {
    $App->log('Error loading idp-client from GET-Parameter', 0, 'OAUTH2/login');
    $App->redirect('default',$redirectParam,dirname($_SERVER['SCRIPT_NAME']));
}

try {
    $idpYml = Yaml::parseFile($idpClientsYml);
    $clientSelector = new ClientSelector($idpYml, $idp_client);
    $idpClient = $clientSelector->getIdpClient();

    if($idpClient === null){
        $App->log("Client config \"$idp_client\" not found in config file $idpClientsYml", 0, 'OAUTH2/login');
        $App->redirect('default', $redirectParam, BENNO_URL_BASE);
    }
    $App->log('Initialize OAuth2 login request',2,'OAuth2/login');
    $idpData = $idpClient->getData();               // PHASE1 up to here -> redirect to idp
    $App->log('Process OAuth2 id token of '.$idp_client,2,'OAuth2/login');
    $Userinfo = new Userinfo($AppConf,$idpData);    // PHASE2
} catch (\Symfony\Component\Yaml\Exception\ParseException $ex){
    $App->log('Can`t parse idp yaml file : '. $ex->getMessage(), 0, 'OAUTH2/login');
    $App->redirect('default', $redirectParam, BENNO_URL_BASE);
}

// default rest config (will be overridden by user authscript)
$RESTconf = new ApplicationConfig($App->configdir);
$RESTconf->load($App->getConfig('REST_CONFIG', 'rest.conf'), false);

$USER = new User($Userinfo->getId());
$USER->addresses = $Userinfo->getEmail();
$USER->archive   = $Userinfo->getArchives();
$USER->filter    = $Userinfo->getFilter();
$USER->name      = $Userinfo->getName();
$USER->role      = $Userinfo->getRole();

if ($USER->role == '') {
    $App->log("Set default role \"USER\" to $USER->id",2,'OAUTH2/login');
    $USER->role = 'USER';
}
$USER->load_role_permissions();

if (!$USER->restdata = $Userinfo->getRestData()) {
    // defaults: compatibility to deprecated configuration
    $base_url_mainconf = $App->getConfig('BASE_URL', 'http://localhost:21080');
    $rest_data['URL']  = $RESTconf->getConfig('BASE_URL', $base_url_mainconf);
    $rest_data['USER'] = $RESTconf->getConfig('REST_USER', 'benno2');
    $rest_data['PASS'] = $RESTconf->getConfig('SHARED_SECRET', $App->getConfig('SHARED_SECRET'));
    $USER->restdata = $rest_data;
}

if (empty($USER->addresses) || (empty($USER->archive))) {
    // ACCESS NOT ALLOWED
    $err_cause = '';
    if (empty($USER->addresses))    $err_cause .= ' email';
    if (empty($USER->archive))      $err_cause .= ' archive';
    $App->log("Access of $USER->id not possible due missing metadata:$err_cause",0,'OAUTH2/login');
    $App->setSession('ACCESS_LEVEL', 0);
    $redirectParam['MSG'] = 'ERR_AUTHZ';
    $App->redirect('default', $redirectParam, BENNO_URL_BASE);
}
//
// LOGIN SUCCESSFUL
//
// init session data
$App->log('Authentication of '.$USER->id.' successful', 1, 'OAUTH2/login');
$info_disabled = $App->getConfigList('INFO_DISABLED', array());
if (in_array('SYSDATA', $info_disabled)) {
    $USER->unsetPermission('SYSDATA');
}
$App->setSession('DISABLED', $info_disabled);

$session_state_dir = $App->getConfig('SESSION_STATEDIR','/var/lib/benno-oauth2/sessions');
$session_state_val = $App->getParam('session_state');

try {
    SessionState::Save($session_state_dir,$session_state_val);
}
catch (\Exception $e) {
    $App->log('Error save session_state: '.$e->getMessage(), 0, 'OAUTH2/login');
}


// initialize backend
$FilterList = Filter::FetchList($USER);
$filterString = '';
foreach ($FilterList as $Filter) {
    $filterString .= $Filter->getString();
}
if (($USER->getRole() == 'REVISOR') || ($USER->getRole == 'ADMIN')) {
    $filterString = '*';
}

$rest_data = $USER->getRestData();
$Backend = new Backend($rest_data['URL'],$rest_data['USER'],$rest_data['PASS'],$filterString);

// defaults for extended search form
$timerange = $App->getConfig('DEFAULT_TIMERANGE', '30');
$ExtQuery = new Query('empty');
$App->setSession('ExtQuery', $ExtQuery);

$App->setSession('QueryList', StoredQuery::FetchList($USER->id));

// list of assigned archives
$archive_list = $USER->getArchives();
foreach ($archive_list as $archive) { // disable index counter if subarchives available
    @list($cidstring, $scid) = preg_split('/\/+(?=[^\/]+$)/', $archive);
    if ($scid) {
        // disable indexed mails counter always
        $DISABLED = $App->getSession('DISABLED');
        array_push($DISABLED, 'INDEXCOUNT');
        $App->setSession('DISABLED', $DISABLED);
    }
}

// restore state of last session
try {
    // searchMask
    $AppState = new AppState($USER->id);
    $searchMaskState = $AppState->getValue('searchMaskState', 'Simple');
    $App->setSession('searchMaskState', $searchMaskState);
    $App->setSession('resendMailto', $AppState->getValue('resendMailto'));

    // handle deleted archives
    if (!in_array($AppState->getValue('archive'), $archive_list)) {
        $AppState->saveValue('archive', '');
    }
    if (!$archive = $AppState->getValue('archive')) {
        $archive = end($archive_list);
    }

    // search SPAM
    $App->setSession('isSpam', $AppState->getValue('isSpam'));

    // Language
    if ($App->getParam('interfaceLanguage')) {
        $AppState->saveValue('userLanguage', $App->getParam('interfaceLanguage'));
        $App->setLang($App->getParam('interfaceLanguage'));
    } else {
        $userLanguage = $AppState->getValue('userLanguage');
        if ($userLanguage) {
            $App->setLang($userLanguage);
        }
    }
} catch (Exception $e) {
    $App->log('Error loading application state: '.$e->getMessage(), 0, 'OAUTH2/login');
}
// initialize session
$App->setSession('ACCESS_LEVEL', 1);
$App->setSession('USER', $USER);
$App->setSession('Backend', $Backend);   // store backend for this session
$App->setSession('archive', $archive);   // store current archive
$App->setSession('FilterList', $FilterList);

// set language on change and after login for 32 days
// Langage settings
if ($App->getParam('LANG')) {
    $LANG = $App->getParam('LANG');
    $App->setLang($LANG);
    $App->setSession('LANG', $LANG);
    // set language on change and after login for 32 days
    setcookie("BENNO_LANGUAGE", $LANG, time() + 2764800, dirname($_SERVER['REQUEST_URI']));
} elseif ($App->getSession('LANG')) {
    $App->setLang($App->getSession('LANG'));
} else {
    if ($App->getConfig('FORCE_DEFAULT_LANGUAGE', 'false') == 'true') {
        $App->setLang($App->getConfig('DEFAULT_LANGUAGE', 'de'));
    } else {
        require_once 'model/AppUtils.php';
        $App->setLang(AppUtils::GetLocaleFromBrowser($App->getConfig('DEFAULT_LANGUAGE', 'de'), false));
    }
}

setcookie("BENNO_LANGUAGE", $App->lang, time() + 2764800, dirname($_SERVER['REQUEST_URI']));

$login_redirect = 'https://'.$_SERVER['HTTP_HOST'].'/'.preg_replace('/^\//', '', BENNO_URL_BASE).$bennoPath;
$App->log("Redirect to $login_redirect", 1, 'OAUTH2/login');
header('Location: '.$login_redirect);
exit();
?>
