<?php

class SessionStateException extends Exception
{
}

class SessionState
{
    public static function Save($statedir,$session_state)
    {
        $statefile = $statedir.'/'.$session_state;
        if (file_put_contents($statefile, session_id()) === false) {
            throw new SessionStateException("Cannot write session state to $statefile");
        }
    }


    public static function Destroy($statedir,$session_state)
    {
        $statefile = $statedir.'/'.$session_state;
        $statesid = file_get_contents($statefile);

        if ($statesid === false) {
            throw new SessionStateException("Cannot find session state file $statefile");
        }
        if (unlink($statefile) === false) {
            throw new SessionStateException("Cannot remove session state file $statefile");
        }

        return $statesid;
    }

}

?>
