<?php

use Lcobucci\JWT\Encoding\CannotDecodeContent;
use Lcobucci\JWT\Encoding\JoseEncoder;
use Lcobucci\JWT\Token\InvalidTokenStructure;
use Lcobucci\JWT\Token\Parser;
use Lcobucci\JWT\Token\UnsupportedHeaderFound;

class TokenUtilException extends Exception
{
}

class TokenUtil
{
    public static function getTokenClaims($token)
    {
        try {
            $token = (new Parser(new JoseEncoder()))->parse($token);
            return $token->claims()->all();
        } catch (CannotDecodeContent $e) {
            throw new TokenUtilException("Cannot decode token content: " . $e->getMessage(), 0, $e);
        } catch (InvalidTokenStructure $e) {
            throw new TokenUtilException("Invalid token structure: " . $e->getMessage(), 0, $e);
        } catch (UnsupportedHeaderFound $e) {
            throw new TokenUtilException("Unsupported header found in token: " . $e->getMessage(), 0, $e);
        }
    }
}
