<?php
require_once 'openid/client/IIdpClient.php';
require_once 'openid/client/Client.php';
require_once 'openid/TokenUtil.php';

class Azure extends Client implements IIdpClient
{
    private $provider;

    private $selectFields;

    function __construct($clientId, $clientSecret, $scopes, $urlAuthorize, $redirectUri, $urlAccessToken,
                         $urlResourceOwnerDetails, $selectFields, $tenant = "common")
    {
        $this->provider = new TheNetworg\OAuth2\Client\Provider\Azure([
            'clientId' => $clientId,    // The client ID assigned to you by the provider
            'clientSecret' => $clientSecret,    // The client password assigned to you by the provider
            'urlAuthorize' => $urlAuthorize,
            'redirectUri' => $redirectUri,
            'urlAccessToken' => $urlAccessToken,
            'urlResourceOwnerDetails' => $urlResourceOwnerDetails,
            'scopes' => $scopes,
            'tenant' => $tenant
        ]);
        if ($selectFields) {
            $this->selectFields = $selectFields;
        } else {
            $this->selectFields = 'mail,proxyAddresses,displayName,userPrincipalName,otherMails';
        }
    }

    private function authorizationStepOne()
    {
        // Fetch the authorization URL from the provider; this returns the
        // urlAuthorize option and generates and applies any necessary parameters
        // (e.g. state).
        $authorizationUrl = $this->provider->getAuthorizationUrl(['scope' => $this->provider->scope]);

        // Get the state generated for you and store it to the session.
        $_SESSION['oauth2state'] = $this->provider->getState();

        // Redirect the user to the authorization URL.
        header('Location: ' . $authorizationUrl);
        exit;
    }

    private function authorizationStepTwo()
    {
        try {
            // Try to get an access token (using the authorization code grant)
            /** @var AccessToken $token */
            $token = $this->provider->getAccessToken('authorization_code', [
                'scope' => $this->provider->scope,
                'code' => $_GET['code'],
            ]);

            $userinfoData = $this->provider->get($this->provider->getRootMicrosoftGraphUri($token) . "/v1.0/me?\$select=$this->selectFields", $token);
            // Das Access-Token, das Sie von Azure AD erhalten haben
            $idClaims = $token->getIdTokenClaims();
            $idTokenAsJson = TokenUtil::getTokenClaims($token->getIdToken());

            return $this->buildUserinfo($idClaims["email"], "metadata", $idTokenAsJson,
                $userinfoData, $token->getIdToken(), $this->getFurtherMailAddresses($userinfoData));

        } catch (\League\OAuth2\Client\Provider\Exception\IdentityProviderException $e) {

            // Failed to get the access token or user details.
            exit($e->getMessage());
        }
    }

    /**
     * Get further mail addresses from userinfo data
     *
     * @param $userinfoData
     * @return array
     */
    private function getFurtherMailAddresses($userinfoData)
    {
        $mailAddresses = array();
        if (isset($userinfoData['otherMails'])) {
            $mailAddresses = $userinfoData['otherMails'];
        }
        if (isset($userinfoData['proxyAddresses'])) {
            foreach ($userinfoData['proxyAddresses'] as $proxyAddress) {
                if (stripos($proxyAddress, 'SMTP:') === 0) {
                    $mailAddresses[] = substr($proxyAddress, 5);
                }
            }
        }
        return array_unique($mailAddresses);

    }

    /**
     * Get the userinfo data from the idp
     *
     * @return array
     */
    public function getData()
    {
        $this->provider->defaultEndPointVersion = TheNetworg\OAuth2\Client\Provider\Azure::ENDPOINT_VERSION_2_0;

        $baseGraphUri = $this->provider->getRootMicrosoftGraphUri(null);
        $this->provider->scope = 'openid profile email offline_access ' . $baseGraphUri . '/User.Read';

        if (!isset($_GET['code'])) {
            $this->authorizationStepOne();
        } elseif (empty($_GET['state']) || empty($_SESSION['oauth2state']) || $_GET['state'] !== $_SESSION['oauth2state']) {

            if (isset($_SESSION['oauth2state'])) {
                unset($_SESSION['oauth2state']);
            }

            exit('Invalid state');

        } else {
            return $this->authorizationStepTwo();
        }
    }
}
