<?php
require_once 'openid/client/IIdpClient.php';
require_once 'openid/client/Client.php';
require_once 'openid/TokenUtil.php';


class EGroupware extends Client implements IIdpClient
{
    private $provider;

    private $mailAddressesIdentifier = "email_aliases";

    function __construct($clientId, $clientSecret, $scopes, $urlAuthorize, $redirectUri, $urlAccessToken,
                         $urlResourceOwnerDetails)
    {
        $this->provider = new \League\OAuth2\Client\Provider\GenericProvider([
            'clientId' => $clientId,    // The client ID assigned to you by the provider
            'clientSecret' => $clientSecret,    // The client password assigned to you by the provider
            'redirectUri' => $redirectUri,
            'urlAuthorize' => $urlAuthorize,
            'urlAccessToken' => $urlAccessToken,
            'urlResourceOwnerDetails' => $urlResourceOwnerDetails,
            'scopes' => implode(" ", $scopes)
        ]);
    }

    private function authorizationStepOne()
    {
        // Fetch the authorization URL from the provider; this returns the
        // urlAuthorize option and generates and applies any necessary parameters
        // (e.g. state).
        $authorizationUrl = $this->provider->getAuthorizationUrl();

        // Get the state generated for you and store it to the session.
        $_SESSION['oauth2state'] = $this->provider->getState();

        // Redirect the user to the authorization URL.
        header('Location: ' . $authorizationUrl);
        exit;
    }

    private function authorizationStepTwo()
    {
        try {
            // Try to get an access token using the authorization code grant.
            $accessToken = $this->provider->getAccessToken('authorization_code', [
                'code' => $_GET['code']
            ]);
            $idClaims = $accessToken->getValues();

            $resourceOwner = $this->provider->getResourceOwner($accessToken)->toArray();

            $idTokenAsJson = TokenUtil::getTokenClaims($idClaims["id_token"]);

            return $this->buildUserinfo($resourceOwner["email"], "metadata", $idTokenAsJson,
                $resourceOwner, $idClaims["id_token"], $this->getFurtherMailAddresses($resourceOwner));

        } catch (\League\OAuth2\Client\Provider\Exception\IdentityProviderException|TokenUtilException $e) {
            exit($e->getMessage());
        }
    }

    /**
     * Get further mail addresses from userinfo data
     *
     * @param $userinfoData
     * @return array
     */
    private function getFurtherMailAddresses($userinfoData)
    {
        $mailAddresses = array();
        if (isset($userinfoData[$this->mailAddressesIdentifier])) {
            $mailAddresses = $userinfoData[$this->mailAddressesIdentifier];
        }

        return array_unique($mailAddresses);

    }

    /**
     * Get the userinfo data from the idp
     *
     * @return array
     */
    public function getData()
    {
        if (!isset($_GET['code'])) {
            $this->authorizationStepOne();
        } elseif (empty($_GET['state']) || empty($_SESSION['oauth2state']) || $_GET['state'] !== $_SESSION['oauth2state']) {

            if (isset($_SESSION['oauth2state'])) {
                unset($_SESSION['oauth2state']);
            }
            exit('Invalid state');
        } else {
            return $this->authorizationStepTwo();
        }
    }
}
