<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */
$AppConf = new ApplicationConfig($App->getConfig('OAUTH2_CONFIGDIR','/etc/benno-oauth2'));
$AppConf->load('app.conf');

define('BENNO_OAUTH2_LIBPATH',  $AppConf->getConfig('OAUTH2_LIBPATH','/srv/benno/oauth2'));

if (!is_readable(BENNO_OAUTH2_LIBPATH)) {
    $App->log('OAUTH2_LIBPATH "'.BENNO_OAUTH2_LIBPATH.'" does not exist. Package benno-oauth2 not installed?');
    $App->redirect('default', array(MSG => 'ERR_OAUTH2'),dirname($_SERVER['SCRIPT_NAME']));
    exit ();
}
ini_set('include_path',ini_get('include_path').':'.BENNO_OAUTH2_LIBPATH);
require_once 'openid/SessionState.php';

if(ini_get('session.save_handler') != 'files') {
    $App->log('WARNING OAuth2 logout not possible.',0,'OAUTH2/logout');
    exit;
}

$session_state_dir = $App->getConfig('SESSION_STATEDIR','/var/lib/benno-oauth2/sessions');
// MS Azure sends only sid parameter contrary to
// https://openid.net/specs/openid-connect-frontchannel-1_0.html#RPLogout
$session_state_val = $App->getParam('sid');

try {
    $logout_sid = SessionState::Destroy($session_state_dir,$session_state_val);
    $session_file = session_save_path().'/sess_'.$logout_sid;
    unlink($session_file);      // return value evertime void!
}
catch (\Exception $e) {
    $App->log('Error destroy session(_state): '.$e->getMessage(), 0, 'OAUTH2/logout');
}

exit;
?>
