<?php

class Userinfo
{
    public $user;
    public $iss;
    public $attributes;

    public $name;
    public $email;
    public $archive;
    public $role;

    function __construct($AppConfig,$idpData)
    {
        $this->user     = $idpData['user']; 

        $oidcData       = $idpData['external_oidc_token'];
        $this->iss      = $oidcData['iss'];

        $this->attributes['role']     = '';
        $this->attributes['name']     = $oidcData['name'];
        $this->attributes['archive']  = array();
        $this->attributes['email']    = $idpData['mail_addresses'];

        $auth_prg  = $AppConfig->getConfig('AUTHPROGRAM','/usr/sbin/benno_auth.d');
        $auth_data = $this->run_authprg($auth_prg,$this->iss,$this->user);
        foreach ($auth_data as $param => $valarray) {
            switch ($param) {
                case 'ARCHIVE':
                    $this->attributes['archive'] = array_merge($this->attributes['archive'],$valarray);
                    break;
                case 'MAIL':
                    $this->attributes['email'] = array_merge($this->attributes['email'],$valarray);
                    break;
                case 'FILTER':
                    $this->attributes['filter'] = array_merge($this->attributes['filter'],$valarray);
                    break;
                case 'ROLE':
                    $this->attributes['role'] = $valarray[0];
                    break;
                case 'RESTURL':
                    $this->attributes['resturl'] = $valarray[0];
                    break;
                case 'RESTUSER':
                    $this->attributes['restuser'] = $valarray[0];
                    break;
                case 'RESTPASS':
                    $this->attributes['restpass'] = $valarray[0];
                    break;
            }
        }

        return $this;
    }


    public function getId()         { return $this->user; }
    public function getArchives()   { return $this->attributes['archive']; }
    public function getFilter()     { return $this->attributes['filter'];  }
    public function getRole()       { return $this->attributes['role'];  }
    public function getName()       { return $this->attributes['name'];  }


    public function getEmail()      {
        return array_unique($this->attributes['email']);
    }

    public function getRestData()
    {
        if ($this->attributes['resturl'])  $restdata['URL']  = $this->attributes['resturl'];
        if ($this->attributes['restuser']) $restdata['USER'] = $this->attributes['restuser'];
        if ($this->attributes['restpass']) $restdata['PASS'] = $this->attributes['restpass'];

        if ($restdata) return $restdata;
        return '';
    }



    private function run_authprg($authprogram,$iss,$userid)
    {
        global $App;

        $authstring = "$userid\n$iss\nMODE OAUTH2";  // prevent information leak with password == issuer

        $fd = array(
            0 => array('pipe', 'r'),
            1 => array('pipe', 'w'),
            2 => array('pipe', 'w')
        );

        $cmd = escapeshellcmd($authprogram."\n");
        $process = proc_open($cmd, $fd, $pipes);
        $App->log('Call "'.$authprogram.'" for container mapping.',2);

        if (is_resource($process)) {
            fwrite($pipes[0], $authstring);
            fclose($pipes[0]);

            // read stdout from authprogram
            $prg_out = stream_get_contents($pipes[1]);
            fclose($pipes[1]);

            $errvalue = stream_get_contents($pipes[2]);
            fclose($pipes[2]);
            if ($errvalue) {
                $error_lines = '';
                $loglevel = 3;
                foreach (explode("\n", $errvalue) as $error_line) {
                    if (preg_match('/FATAL/',$error_line)) {
                        $loglevel = 0;
                    }
                    $error_lines .= $error_line.'|';
                }
                $error_lines = rtrim($error_lines, '|');
                $App->log('Authentication authprogram error: '.$error_lines,$loglevel,'AuthModules/execute');
            }

            $return_value = proc_close($process);
        }
        else {
            $App->log("ERROR Cannot run $authprogram on $authdir");
        }

        return $this->get_authdata($prg_out);
    }


    private function get_authdata($authlines)
    {
        $retvalues = [];

        $retlines = preg_split('/\R/',$authlines);
        foreach ($retlines as $line) {
            $line = trim($line);
            if (!$line) continue;

            @list($mark,$data) = preg_split('/\s/',$line,2);
            $umark = strtoupper($mark);
            if (!is_array($retvalues[$umark])) {
                $retvalues[$umark] = [];
            }
            array_push($retvalues[$umark], $data);
        }

        return $retvalues;
    }

}
