<?php

$typeDir =  BENNO_OAUTH2_LIBPATH.'/openid/client/type';

foreach (new DirectoryIterator($typeDir) as $file) {
    if ($file->isFile() && $file->getExtension() == 'php') {
        require_once $file->getPathname();
    }
}

class ClientSelector
{
    private $clientKey = "clients";
    private $providerKey = "provider";
    private $clientTypeKey = "type";

    private $idpClient;

    private $client;

    private $provider;

    public function __construct($clientYml, $clientName, $httpPrefix)
    {
        $this->client = $this->determineClient($clientYml, $clientName);
        if (!preg_match('/^https:\/\//',$this->client['redirectUri'])) {
            $redirectPath = ltrim($this->client['redirectUri'],'/');
            $this->client['redirectUri'] = $httpPrefix.'/'.$redirectPath;
        }
        $this->provider = $this->determineProvider($clientYml, $this->client[$this->providerKey]);
        $this->idpClient = $this->createIdpClient();
    }

    private function determineClient($clientYml, $clientName)
    {
        if ($clientYml[$this->clientKey][$clientName] !== null) {
            return $clientYml[$this->clientKey][$clientName];
        } else {
            return null;
        }
    }

    private function determineProvider($client, $provider)
    {
        if ($client[$this->providerKey][$provider] !== null) {
            return $client[$this->providerKey][$provider];
        } else {
            return null;
        }
    }

    /**
     * Get provider settings from client
     *
     * @return array
     */
    public function getProvider()
    {
        return $this->provider;
    }

    private function createIdpClient()
    {
        if ($this->client !== null && $this->provider !== null) {
            if ($this->client[$this->clientTypeKey] === "azure") {
                if (! $this->client['tenant']) {
                    $this->client['tenant'] = 'common';
                }
                return new Azure($this->client["clientId"], $this->client["clientSecret"], $this->client["scopes"],
                    $this->provider["authorizeUri"], $this->client["redirectUri"], $this->provider["tokenUri"], $this->provider["resourceOwnerUri"], $this->client["selectFields"],
                        $this->client["tenant"]);
            } else if ($this->client[$this->clientTypeKey] === "egroupware") {
                return new EGroupware($this->client["clientId"], $this->client["clientSecret"], $this->client["scopes"],
                    $this->provider["authorizeUri"], $this->client["redirectUri"], $this->provider["tokenUri"], $this->provider["resourceOwnerUri"]);
            } else if ($this->client[$this->clientTypeKey] === "generic") {
                return new Generic($this->client["clientId"], $this->client["clientSecret"], $this->client["scopes"],
                    $this->provider["authorizeUri"], $this->client["redirectUri"], $this->provider["tokenUri"], $this->provider["resourceOwnerUri"]);
            }
        }
    }

    /**
     * Get generated client for IDP connection
     *
     * @return Azure|Generic|void
     */
    public function getIdpClient()
    {
        return $this->idpClient;
    }
}
