/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.IBennoApplication;
import de.lwsystems.mailarchive.config.BennoConfig;
import de.lwsystems.mailarchive.rest.servlets.BennoAdminServlet;
import de.lwsystems.mailarchive.rest.servlets.BennoAttachmentServlet;
import de.lwsystems.mailarchive.rest.servlets.BennoLicenseServlet;
import de.lwsystems.mailarchive.rest.servlets.BennoLogoutServlet;
import de.lwsystems.mailarchive.rest.servlets.BennoMailServlet;
import de.lwsystems.mailarchive.rest.servlets.BennoSearchServlet;
import de.lwsystems.mailarchive.utils.License;
import de.lwsystems.mailarchive.utils.LicenseException;
import de.lwsystems.mailarchive.utils.RunUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.Servlet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.eclipse.jetty.http.security.Constraint;
import org.eclipse.jetty.http.security.Credential;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.xml.XmlConfiguration;

public class BennoRest
implements IBennoApplication {
    private static final Logger LOGGER = Logger.getLogger(BennoRest.class);
    private transient Benno benno;
    private String jettyConfig = "/etc/benno/jetty.xml";
    private String bennoConfigFile = "/etc/benno/benno.xml";
    private String bennoLicenseFile = "/etc/benno/benno.lic";
    private boolean licenseStatus = false;
    private License bennoLicense;
    private BennoConfig bennoConfig;
    private int restPort = 0;
    private transient Server jetty = null;

    public static void main(String[] args) throws Exception {
        boolean success = false;
        try {
            Benno.configureLogging();
            BennoRest rest = new BennoRest();
            if (rest.getBenno(args, false)) {
                rest.runJetty();
            }
        }
        catch (Throwable ex) {
            System.err.println(ex.toString());
            LOGGER.fatal((Object)ex.toString());
        }
    }

    private BennoRest() {
    }

    private boolean getBenno(String[] args, boolean readOnly) throws Exception {
        HelpFormatter formatter;
        boolean success = false;
        BennoConfig config = null;
        PosixParser parser = new PosixParser();
        Options options = new Options();
        OptionBuilder.withArgName((String)"PORT");
        OptionBuilder.withLongOpt((String)"port");
        OptionBuilder.withDescription((String)"start rest interface on port PORT");
        OptionBuilder.hasArg();
        OptionBuilder.withType(Integer.class);
        options.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withArgName((String)"CONFIGFILE");
        OptionBuilder.withLongOpt((String)"config");
        OptionBuilder.withDescription((String)"use configuraton from CONFIGFILE");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"print this description");
        options.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.withLongOpt((String)"print-config");
        OptionBuilder.withDescription((String)"print out actual configuration");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"host-info");
        OptionBuilder.withDescription((String)"print out current host info");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"default-config");
        OptionBuilder.withDescription((String)"print out default configuration");
        options.addOption(OptionBuilder.create());
        try {
            CommandLine cmdl = parser.parse(options, args, true);
            if (cmdl.hasOption("h")) {
                formatter = new HelpFormatter();
                formatter.printHelp("java -jar bennorest.jar", options);
                Runtime.getRuntime().exit(0);
            } else {
                File configfile = null;
                if (cmdl.hasOption("default-config")) {
                    config = BennoConfig.getDefault();
                } else {
                    if (cmdl.hasOption("c")) {
                        configfile = new File((String)cmdl.getParsedOptionValue("c"));
                        if (!configfile.exists()) {
                            throw new IllegalArgumentException("configfile \"" + cmdl.getParsedOptionValue("c") + "\" does not exist!");
                        }
                        if (!configfile.isFile()) {
                            throw new IllegalArgumentException("configfile \"" + cmdl.getParsedOptionValue("c") + "\" is not a file!");
                        }
                        if (!configfile.canRead()) {
                            throw new IllegalArgumentException("configfile \"" + cmdl.getParsedOptionValue("c") + "\" cannot be read!");
                        }
                    }
                    if (configfile == null) {
                        configfile = new File("benno.xml");
                        if (configfile != null && !configfile.exists()) {
                            configfile = null;
                        }
                        if (configfile != null && !configfile.isFile()) {
                            configfile = null;
                        }
                        if (configfile != null && !configfile.canRead()) {
                            configfile = null;
                        }
                        if (configfile == null) {
                            configfile = new File("/etc/benno/benno.xml");
                            if (configfile != null && !configfile.exists()) {
                                configfile = null;
                            }
                            if (configfile != null && !configfile.isFile()) {
                                configfile = null;
                            }
                            if (configfile != null && !configfile.canRead()) {
                                configfile = null;
                            }
                        }
                    }
                    if (configfile == null) {
                        System.err.println("No configfile found, exiting");
                        LOGGER.fatal((Object)"No configfile found, exiting");
                        Runtime.getRuntime().exit(99);
                    }
                    config = (BennoConfig)Benno.getPersister().read(BennoConfig.class, configfile);
                    if (cmdl.hasOption("p")) {
                        this.restPort = (Integer)cmdl.getParsedOptionValue("p");
                    }
                }
                if (cmdl.hasOption("print-config")) {
                    Benno.getPersister().write((Object)config, (OutputStream)System.out);
                    Runtime.getRuntime().exit(0);
                }
                if (cmdl.hasOption("host-info")) {
                    InetAddress iaddr = InetAddress.getLocalHost();
                    String hostname = iaddr.getCanonicalHostName();
                    String address = iaddr.getHostAddress();
                    boolean error = false;
                    if (hostname.indexOf(".") == -1) {
                        System.out.println("ERROR: Hostname not fully qualified: " + hostname);
                        LOGGER.error((Object)("No fully-qualified hostname found: " + hostname));
                        error = true;
                    }
                    if (address.startsWith("127.")) {
                        System.out.println("ERROR: Loopback address detected for hostname \"" + hostname + "\": " + address);
                        LOGGER.error((Object)("IP address points to loopback device: " + address));
                        error = true;
                    }
                    if (error) {
                        Runtime.getRuntime().exit(1);
                    }
                    System.out.println("Host-Info: " + address + "/" + hostname);
                    System.out.println("Build-Info: " + RunUtil.buildInfo());
                    Runtime.getRuntime().exit(0);
                }
            }
        }
        catch (Exception exp) {
            formatter = new HelpFormatter();
            StringWriter sWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(sWriter);
            formatter.printHelp(writer, 80, "benno " + Benno.class.getPackage().getImplementationVersion(), "Commandline usage:", options, 1, 1, "Unexpected exception:" + exp.getMessage(), true);
            writer.flush();
            String message = sWriter.toString();
            System.err.println(message);
            LOGGER.fatal((Object)message);
            config = null;
        }
        if (config != null) {
            this.benno = null;
            this.benno = new Benno(config, true, null);
            this.bennoConfig = config;
            if (this.benno != null) {
                success = true;
                this.jettyConfig = config.bennoRestConfig.getJettyConfig();
            }
        }
        String hostInfo = "";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Check license from " + this.bennoLicenseFile));
        }
        try {
            this.bennoLicense = new License(this.bennoLicenseFile);
            try {
                if (this.bennoLicense.getType().equals("Evaluation")) {
                    this.bennoLicense.checkExpire();
                } else {
                    this.bennoLicense.checkBuild();
                }
                hostInfo = this.bennoLicense.getHostInfo();
                this.bennoLicense.checkValid(hostInfo);
                LOGGER.info((Object)("License in " + this.bennoLicenseFile + " is valid"));
                this.licenseStatus = true;
            }
            catch (UnknownHostException ex) {
                LOGGER.warn((Object)"Cannot get hostname", (Throwable)ex);
                throw new LicenseException("HOSTINFO ERROR");
            }
            catch (LicenseException ex) {
                LOGGER.warn((Object)("Benno MailArchive build " + RunUtil.buildInfo()));
                LOGGER.warn((Object)("License error " + ex.getMessage()));
            }
        }
        catch (Exception ex) {
            LOGGER.warn((Object)("Cannot check license file: " + ex));
        }
        return success;
    }

    public void runJetty() {
        LOGGER.info((Object)("Starting Jetty server from file " + this.jettyConfig));
        try {
            if (this.restPort == 0) {
                XmlConfiguration configuration = new XmlConfiguration((InputStream)new FileInputStream(new File(this.jettyConfig)));
                this.jetty = (Server)configuration.configure();
            } else {
                this.jetty = new Server();
                SelectChannelConnector connector = new SelectChannelConnector();
                connector.setPort(this.restPort);
                this.jetty.addConnector((Connector)connector);
            }
            ServletContextHandler bennoContext = new ServletContextHandler(1);
            bennoContext.setContextPath("/");
            this.jetty.setHandler((Handler)bennoContext);
            if (this.bennoConfig.bennoRestConfig.getSharedSecret().equals("notset")) {
                LOGGER.fatal((Object)(" Shared secret in " + this.bennoConfigFile + " not set. Exit."));
                System.err.println("Shared secret in " + this.bennoConfigFile + " not set. Exit.");
                Runtime.getRuntime().exit(254);
            }
            if (this.bennoConfig.bennoRestConfig.getSharedSecret().length() < 8) {
                LOGGER.fatal((Object)(" Shared secret in " + this.bennoConfigFile + " shorter than 8 chars. Exit."));
                System.err.println("Shared secret in " + this.bennoConfigFile + " shorter than 8 chars. Exit.");
                Runtime.getRuntime().exit(254);
            }
            bennoContext.setSecurityHandler(BennoRest.basicAuth("benno2", this.bennoConfig.bennoRestConfig.getSharedSecret(), "benno"));
            bennoContext.addServlet(new ServletHolder((Servlet)new BennoSearchServlet(this, this.benno)), "/search/*");
            bennoContext.addServlet(new ServletHolder((Servlet)new BennoMailServlet(this, this.benno)), "/mail/*");
            bennoContext.addServlet(new ServletHolder((Servlet)new BennoAttachmentServlet(this, this.benno)), "/attachment/*");
            bennoContext.addServlet(new ServletHolder((Servlet)new BennoLogoutServlet(this, this.benno)), "/logout/*");
            bennoContext.addServlet(new ServletHolder((Servlet)new BennoLicenseServlet(this, this.benno, this.bennoLicense)), "/license/*");
            bennoContext.addServlet(new ServletHolder((Servlet)new BennoAdminServlet(this, this.benno)), "/admin/*");
            this.jetty.start();
            this.jetty.join();
        }
        catch (Exception ex) {
            LOGGER.fatal((Object)("Could not open Jetty from file " + this.jettyConfig), (Throwable)ex);
            System.exit(255);
        }
    }

    void stop() {
        try {
            this.jetty.stop();
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Error closing Jetty", (Throwable)ex);
        }
    }

    public void start() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void shutDown() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getIdentifier() {
        return "Bennorest" + (this.benno == null ? "" : " " + this.benno.getIdentifier());
    }

    public BennoConfig getBennoConfig() {
        return this.bennoConfig;
    }

    private static final SecurityHandler basicAuth(String username, String password, String realm) {
        HashLoginService l = new HashLoginService();
        l.putUser(username, Credential.getCredential((String)password), new String[]{"user"});
        l.setName(realm);
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{"user"});
        constraint.setAuthenticate(true);
        ConstraintMapping cm = new ConstraintMapping();
        cm.setConstraint(constraint);
        cm.setPathSpec("/*");
        ConstraintSecurityHandler csh = new ConstraintSecurityHandler();
        csh.setAuthenticator((Authenticator)new BasicAuthenticator());
        csh.setRealmName("myrealm");
        csh.addConstraintMapping(cm);
        csh.setLoginService((LoginService)l);
        return csh;
    }

    public boolean getLicenseStatus() {
        return this.licenseStatus;
    }
}

