/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.servlets;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.IArchiveGenerator;
import de.lwsystems.mailarchive.archive.container.ContainerNotFoundException;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.archive.container.IContainerGenerator;
import de.lwsystems.mailarchive.config.BennoConfig;
import de.lwsystems.mailarchive.rest.BennoRest;
import de.proite.mailarchive.rest.tools.RecipientResolver;
import java.io.IOException;
import java.io.Writer;
import java.rmi.NoSuchObjectException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.ClassicAnalyzer;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.store.Directory;
import org.json.JSONArray;
import org.json.JSONObject;

public class BennoSearchServlet
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger(BennoSearchServlet.class);
    boolean debugEnabled = LOGGER.isDebugEnabled();
    private final BennoRest bennoRest;
    private final Benno benno;

    public BennoSearchServlet(BennoRest bennoRest, Benno benno) {
        this.bennoRest = bennoRest;
        this.benno = benno;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProcess(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProcess(request, response);
    }

    protected void doProcess(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        JSONObject answer = new JSONObject();
        Integer overAll = 0;
        response.setContentType("application/json; charset=UTF-8");
        response.setStatus(200);
        try {
            JSONObject temp;
            Document hitDoc;
            ScoreDoc[] hits;
            IndexSearcher isearcher;
            IndexReader ireader;
            String foundArch;
            int limit;
            int start;
            String sortField = "SortableDate";
            boolean sortAsc = false;
            String filterQuery = "";
            QueryWrapperFilter filter = null;
            boolean documentCounter = false;
            boolean full = false;
            boolean licenseStatus = this.bennoRest.getLicenseStatus();
            long indexCacheTTL = 0L;
            BennoConfig config = this.bennoRest.getBennoConfig();
            IArchiveGenerator archiveGenerator = config.getArchiveGenerator(this.benno, true);
            if (licenseStatus) {
                indexCacheTTL = config.bennoRestConfig.getIndexCacheTTL();
            }
            String searchTerm = request.getPathInfo().substring(1);
            String searchArchive = request.getParameter("archive");
            String queryString = request.getParameter("query");
            if (queryString.contains("Date:[")) {
                queryString = queryString.replaceAll("Date:\\[", "SortableDate:[");
            }
            if (request.getParameter("start") != null) {
                start = Integer.parseInt(request.getParameter("start"));
                if (start < 1) {
                    start = 1;
                }
            } else {
                start = 1;
            }
            if (request.getParameter("limit") != null) {
                limit = Integer.parseInt(request.getParameter("limit"));
                if (limit < 0) {
                    limit = 0;
                }
            } else {
                limit = 20;
            }
            if (request.getParameter("sort") != null && ((sortField = request.getParameter("sort")).equals("Date") || sortField.equals("Subject"))) {
                sortField = "Sortable" + sortField;
            }
            if (request.getParameter("sortAsc") != null && request.getParameter("sortAsc").equals("false")) {
                sortAsc = true;
            }
            if (request.getParameter("full") != null && request.getParameter("full").equals("true")) {
                full = true;
            }
            if (request.getParameter("filterQuery") != null && licenseStatus) {
                filterQuery = request.getParameter("filterQuery");
            }
            answer.put("limit", limit);
            IContainer myContainer = null;
            if (session.getAttribute("myContainer") == null || session.getAttribute("myArchive") == null) {
                for (IArchive aktArchive : config.archiveGenerator.getArchiveGenerator(this.benno, true).getArchives()) {
                    IContainerGenerator containerGen = aktArchive.getContainerGenerator();
                    try {
                        myContainer = containerGen.getContainer(searchArchive);
                        session.setAttribute("myContainer", (Object)myContainer);
                        session.setAttribute("myArchive", (Object)aktArchive);
                        foundArch = aktArchive.getIdentifier();
                        break;
                    }
                    catch (Exception searchEx) {
                    }
                }
            } else {
                myContainer = (IContainer)session.getAttribute("myContainer");
                IArchive aktArchive = (IArchive)session.getAttribute("myArchive");
                foundArch = aktArchive.getIdentifier();
            }
            if (myContainer == null) {
                throw new ContainerNotFoundException(searchArchive);
            }
            if (session.getAttribute("indexTime") != null && new Date().getTime() - (Long)session.getAttribute("indexTime") > indexCacheTTL) {
                ireader = (IndexReader)session.getAttribute("indexReader");
                isearcher = (IndexSearcher)session.getAttribute("indexSearcher");
                isearcher.close();
                ireader.close();
                session.setAttribute("indexReader", null);
                session.setAttribute("indexSearcher", null);
            }
            if (session.getAttribute("indexSearcher") == null) {
                ireader = IndexReader.open((Directory)myContainer.getIndexPath());
                isearcher = new IndexSearcher(ireader);
                session.setAttribute("indexSearcher", (Object)isearcher);
                session.setAttribute("indexReader", (Object)ireader);
                session.setAttribute("indexTime", (Object)new Date().getTime());
                if (this.debugEnabled) {
                    LOGGER.debug((Object)(session.getId() + " opened indexSearcher: " + session.getAttribute("indexTime")));
                }
            } else {
                ireader = (IndexReader)session.getAttribute("indexReader");
                isearcher = (IndexSearcher)session.getAttribute("indexSearcher");
                if (this.debugEnabled) {
                    LOGGER.debug((Object)(session.getId() + " Using cached indexSearcher - Result from: " + session.getAttribute("indexTime")));
                    LOGGER.debug((Object)(session.getId() + " Time-Diff: " + (new Date().getTime() - (Long)session.getAttribute("indexTime"))));
                }
            }
            if (session.getAttribute("lastQuery") != null && session.getAttribute("lastQuery").equals(queryString) && session.getAttribute("lastSortField") != null && session.getAttribute("lastSortField").equals(sortField) && session.getAttribute("lastSortAsc") != null && session.getAttribute("lastSortAsc").equals(sortAsc) && session.getAttribute("lastFilterQuery").equals(filterQuery) && session.getAttribute("lastFirst") != null && new Date().getTime() - (Long)session.getAttribute("lastTime") <= 60000L) {
                overAll = (Integer)session.getAttribute("overAll");
                if (this.debugEnabled) {
                    LOGGER.debug((Object)(session.getId() + " Using cached result - Result from: " + session.getAttribute("lastTime")));
                    LOGGER.debug((Object)(session.getId() + " Time-Diff: " + (new Date().getTime() - (Long)session.getAttribute("lastTime"))));
                }
            } else {
                if (this.debugEnabled) {
                    LOGGER.debug((Object)(session.getId() + " Archive: " + myContainer.getArchive().getIdentifier()));
                    LOGGER.debug((Object)(session.getId() + " Container: " + myContainer.getIdentifier()));
                }
                ClassicAnalyzer analyzer = new ClassicAnalyzer(myContainer.getIndexVersion());
                QueryParser parser = new QueryParser(myContainer.getIndexVersion(), "Subject", (Analyzer)analyzer);
                parser.setAllowLeadingWildcard(true);
                if (this.debugEnabled) {
                    LOGGER.debug((Object)(session.getId() + " Request-Query: " + queryString));
                }
                Query query = parser.parse(queryString);
                if (this.debugEnabled) {
                    LOGGER.debug((Object)(session.getId() + " Parsed-Query: " + query.toString()));
                }
                if (sortField != null && this.debugEnabled) {
                    LOGGER.debug((Object)(session.getId() + " SortField: " + sortField.toString()));
                }
                if (session.getAttribute("filter") == null || !request.getParameter("filterQuery").equals((String)session.getAttribute("filterQuery"))) {
                    if (!filterQuery.isEmpty()) {
                        try {
                            if (this.debugEnabled) {
                                LOGGER.debug((Object)(session.getId() + " Request-Filter: " + filterQuery));
                            }
                            filter = new QueryWrapperFilter(parser.parse(filterQuery));
                            filter = new CachingWrapperFilter((Filter)filter);
                            session.setAttribute("filter", (Object)filter);
                            session.setAttribute("filterQuery", (Object)filterQuery);
                            if (this.debugEnabled) {
                                LOGGER.debug((Object)(session.getId() + " Parsed-Filter: " + filter.toString()));
                            }
                        }
                        catch (ParseException pex) {
                            try {
                                JSONObject errResult = new JSONObject();
                                errResult.put("error", (Object)"Invalid filterQuery");
                                errResult.write((Writer)response.getWriter());
                                LOGGER.warn((Object)(session.getId() + " Invalid filterQuery string: " + request.getParameter("filterQuery")));
                                response.setStatus(400);
                                response.flushBuffer();
                                return;
                            }
                            catch (Exception ex) {
                                LOGGER.warn((Object)"Uncaught Exception", (Throwable)ex);
                            }
                        }
                    }
                } else {
                    if (this.debugEnabled) {
                        LOGGER.debug((Object)(session.getId() + " Using cached filter."));
                    }
                    filter = (CachingWrapperFilter)session.getAttribute("filter");
                }
                int sortType = sortField.equals("SortableDate") ? 6 : 3;
                isearcher.setDefaultFieldSortScoring(false, false);
                TopFieldCollector results = TopFieldCollector.create((Sort)new Sort(new SortField(sortField, sortType, sortAsc)), (int)999999, (boolean)false, (boolean)false, (boolean)false, (boolean)sortAsc);
                if (filter == null) {
                    if (this.debugEnabled) {
                        LOGGER.debug((Object)(session.getId() + " Start searching for documents without filter."));
                    }
                    isearcher.search(query, (Collector)results);
                } else {
                    if (this.debugEnabled) {
                        LOGGER.debug((Object)(session.getId() + " Start searching for documents with filter."));
                    }
                    isearcher.search(query, (Filter)filter, (Collector)results);
                }
                hits = results.topDocs((int)(start - 1)).scoreDocs;
                if (this.debugEnabled) {
                    LOGGER.debug((Object)(session.getId() + " Query returns " + hits.length + " results"));
                }
                overAll = ireader.numDocs();
                session.setAttribute("lastTime", (Object)new Date().getTime());
                session.setAttribute("lastQuery", (Object)queryString);
                session.setAttribute("lastResults", (Object)hits);
                session.setAttribute("lastSortField", (Object)sortField);
                session.setAttribute("lastFilterQuery", (Object)filterQuery);
                session.setAttribute("lastSortAsc", (Object)sortAsc);
                session.setAttribute("overAll", (Object)overAll);
                if (hits.length <= 0) {
                    answer.put("found", (Object)"0");
                    answer.put("count", (Object)"0");
                    answer.put("first", (Object)"-1");
                    answer.put("last", (Object)"-1");
                    answer.put("overall", (Object)overAll);
                    answer.put("licenseValid", licenseStatus);
                    throw new NoSuchObjectException("No results found!");
                }
            }
            hits = (ScoreDoc[])session.getAttribute("lastResults");
            JSONArray results = new JSONArray();
            answer.put("found", hits.length);
            if (start > 1) {
                ++start;
            }
            int countTo = limit > hits.length ? hits.length : start + limit - 1;
            answer.put("first", start - 1);
            if (start + limit > hits.length) {
                countTo = hits.length;
            }
            session.setAttribute("lastFirst", (Object)(start - 1));
            if (!full) {
                for (int i = start - 1; i < countTo; ++i) {
                    hitDoc = isearcher.doc(hits[i].doc);
                    temp = new JSONObject();
                    if (hitDoc.get("Date") != null) {
                        temp.put("Date", (Object)hitDoc.get("Date").toString());
                    } else {
                        temp.put("Date", (Object)"197001010000");
                    }
                    temp.put("Subject", (Object)hitDoc.get("Subject"));
                    temp.put("From", (Object)hitDoc.get("From"));
                    temp.put("id", (Object)hitDoc.get("id"));
                    RecipientResolver rr = new RecipientResolver(hitDoc.getFieldables("To"), hitDoc.getFieldables("Cc"), hitDoc.getFieldables("Recipient"));
                    temp.put("To", (Object)rr.getToJSONArray());
                    temp.put("Cc", (Object)rr.getCcJSONArray());
                    temp.put("Bcc", (Object)rr.getBccJSONArray());
                    if (hitDoc.get("hasAttachment") == null) {
                        temp.put("hasAttachment", (Object)"0");
                    } else {
                        temp.put("hasAttachment", (Object)hitDoc.get("hasAttachment"));
                    }
                    results.put((Object)temp);
                }
            } else {
                for (int i = start - 1; i < countTo; ++i) {
                    hitDoc = isearcher.doc(hits[i].doc);
                    temp = new JSONObject();
                    List fieldList = hitDoc.getFields();
                    for (AbstractField field : fieldList) {
                        temp.put(field.name(), (Object)field.stringValue());
                        results.put((Object)temp);
                    }
                }
            }
            answer.put("overall", (Object)overAll);
            answer.put("count", results.length());
            answer.put("last", countTo - 1);
            answer.put("results", (Object)results);
            answer.put("licenseValid", licenseStatus);
            if (results.length() == 0) {
                answer.put("last", -1);
                answer.put("first", -1);
            }
            answer.write((Writer)response.getWriter());
        }
        catch (NoSuchObjectException nsoe) {
            response.resetBuffer();
            response.getWriter().println(answer.toString());
        }
        catch (ContainerNotFoundException cnfe) {
            LOGGER.warn((Object)cnfe.getMessage());
            response.resetBuffer();
            response.setStatus(404);
            try {
                JSONObject errResult = new JSONObject();
                errResult.put("error", (Object)"container not found");
                errResult.write((Writer)response.getWriter());
            }
            catch (Exception ex) {
                LOGGER.fatal((Object)"Uncaught Excpetion", (Throwable)ex);
            }
        }
        catch (ParseException pex) {
            try {
                JSONObject errResult = new JSONObject();
                errResult.put("error", (Object)"Invalid query");
                errResult.write((Writer)response.getWriter());
                LOGGER.warn((Object)(session.getId() + " Invalid query string: " + request.getParameter("query")));
            }
            catch (Exception ex) {
                LOGGER.warn((Object)"Uncaught Exception", (Throwable)ex);
            }
        }
        catch (Exception e) {
            response.setStatus(503);
            LOGGER.fatal((Object)"Uncaught Exception", (Throwable)e);
        }
    }

    private void sortHits(ScoreDoc[] hits, final IndexSearcher searcher) {
        Comparator<ScoreDoc> cmp = new Comparator<ScoreDoc>(){
            String field = "SortableDate";
            boolean order = false;

            @Override
            public int compare(ScoreDoc h0, ScoreDoc h1) {
                try {
                    String o0 = searcher.doc(h0.doc).get(this.field);
                    String o1 = searcher.doc(h1.doc).get(this.field);
                    if (o0 == null && o1 == null) {
                        return 0;
                    }
                    if (this.order) {
                        if (o0 == null) {
                            return 1;
                        }
                        return o0.compareTo(o1);
                    }
                    if (o1 == null) {
                        return 1;
                    }
                    return o1.compareTo(o0);
                }
                catch (CorruptIndexException ex) {
                }
                catch (IOException ex) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                return 0;
            }
        };
        Arrays.sort(hits, 0, Math.min(hits.length, 100), cmp);
    }
}

