/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.servlets;

import java.security.Principal;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ServletTools {
    private static final Logger LOGGER = Logger.getLogger(ServletTools.class);

    static String getRequestDetails(HttpServletRequest request, boolean html) {
        StringBuilder sRet = new StringBuilder(html ? "<p>" : "");
        String nl = html ? "</p><p>" : "\n";
        sRet.append("session=" + request.getSession(true).getId()).append(nl);
        sRet.append("Authtype=" + request.getAuthType()).append(nl);
        sRet.append("Contenttype=" + request.getContentType()).append(nl);
        sRet.append("ContextPath=" + request.getContextPath()).append(nl);
        sRet.append("Method=" + request.getMethod()).append(nl);
        sRet.append("PathInfo=" + request.getPathInfo()).append(nl);
        sRet.append("PathTranslated=" + request.getPathTranslated()).append(nl);
        sRet.append("Protokoll=" + request.getProtocol()).append(nl);
        sRet.append("RemoteAddr=" + request.getRemoteAddr()).append(nl);
        sRet.append("RemoteUser=" + request.getRemoteUser()).append(nl);
        sRet.append("RemoteHost=" + request.getRemoteHost()).append(nl);
        sRet.append("ServletPath=" + request.getServletPath()).append(nl);
        sRet.append("RequestURL=" + request.getRequestURL().toString()).append(nl);
        sRet.append("CharacterEncoding=" + request.getCharacterEncoding()).append(nl);
        sRet.append("LocalAddr=" + request.getLocalAddr()).append(nl);
        sRet.append("LocalName=" + request.getLocalName()).append(nl);
        sRet.append("PathInfo=" + request.getPathInfo()).append(nl);
        sRet.append("QueryString=" + request.getQueryString()).append(nl);
        sRet.append("RequestURI=" + request.getRequestURI().toString()).append(nl);
        sRet.append("RequestedSessionId=" + request.getRequestedSessionId()).append(nl);
        sRet.append("Scheme=" + request.getScheme()).append(nl);
        sRet.append("ServerName=" + request.getServerName()).append(nl);
        if (request.getCookies() != null) {
            sRet.append("Cookies:").append(nl);
            for (Cookie cookie : request.getCookies()) {
                sRet.append("Name=" + cookie.getName()).append(nl);
                sRet.append("Domain=" + cookie.getDomain()).append(nl);
                sRet.append("Path=" + cookie.getPath()).append(nl);
                sRet.append("Value=" + cookie.getValue()).append(nl);
                sRet.append("Comment=" + cookie.getComment()).append(nl);
                sRet.append("MaxAge=" + Integer.toString(cookie.getMaxAge())).append(nl);
                sRet.append("Version=" + Integer.toString(cookie.getVersion())).append(nl);
                sRet.append("Secure=" + Boolean.toString(cookie.getSecure())).append(nl).append(nl);
            }
            Principal principal = request.getUserPrincipal();
            if (principal != null) {
                sRet.append("Principal:").append(nl);
                sRet.append("Name=" + principal.getName()).append(nl);
                sRet.append("toString=" + ((Object)principal).toString()).append(nl);
                sRet.append("Class=" + principal.getClass().toString()).append(nl);
            }
        }
        sRet.append(html ? "</p>" : "");
        return sRet.toString();
    }
}

