/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.servlets;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.IArchiveGenerator;
import de.lwsystems.mailarchive.archive.container.ContainerNotFoundException;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.archive.container.IContainerGenerator;
import de.lwsystems.mailarchive.config.BennoConfig;
import de.lwsystems.mailarchive.maildocument.Header;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.rest.BennoRest;
import de.proite.mailarchive.rest.tools.MailAttachment;
import de.proite.mailarchive.rest.tools.MimePartResolver;
import de.proite.mailarchive.rest.tools.RecipientResolver;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class BennoMailServlet
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger(BennoMailServlet.class);
    private final BennoRest bennoRest;
    private final Benno benno;
    boolean debugEnabled = LOGGER.isDebugEnabled();

    public BennoMailServlet(BennoRest bennoRest, Benno benno) {
        this.bennoRest = bennoRest;
        this.benno = benno;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProccess(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProccess(request, response);
    }

    private void doProccess(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain;charset=UTF-8");
        response.setStatus(200);
        BennoConfig config = this.bennoRest.getBennoConfig();
        String searchArchive = request.getParameter("archive");
        String searchId = request.getParameter("id");
        String responseFormat = "maildata";
        boolean raw = false;
        boolean skipUtf8Recode = false;
        boolean onlyMailHeaders = false;
        IArchiveGenerator archiveGenerator = config.getArchiveGenerator(this.benno, true);
        if (request.getParameter("format") != null) {
            responseFormat = request.getParameter("format");
            if (responseFormat.equals("raw")) {
                raw = true;
                if (request.getParameter("skipUTF8Recode") != null && request.getParameter("skipUTF8Recode").equals("true")) {
                    skipUtf8Recode = true;
                }
            } else if (responseFormat.equals("headers")) {
                onlyMailHeaders = true;
            }
        }
        try {
            MailDocument myDoc;
            IContainer myContainer = null;
            for (IArchive aktArchive : config.archiveGenerator.getArchiveGenerator(this.benno, true).getArchives()) {
                IContainerGenerator containerGen = aktArchive.getContainerGenerator();
                try {
                    myContainer = containerGen.getContainer(searchArchive);
                    String foundArch = aktArchive.getIdentifier();
                    break;
                }
                catch (Exception searchEx) {
                }
            }
            if (myContainer == null) {
                throw new ContainerNotFoundException(searchArchive);
            }
            if (this.debugEnabled) {
                LOGGER.debug((Object)("Load email from repository " + searchId));
            }
            if ((myDoc = myContainer.getBox().getDocument(searchId)) == null) {
                throw new FileNotFoundException("Mail with id '" + searchId + "' not found!");
            }
            if (raw) {
                CharsetMatch cm = this.detectCharset(myDoc);
                InputStream mailStream = myDoc.getMailStream();
                if (skipUtf8Recode) {
                    if (cm != null) {
                        response.setCharacterEncoding(cm.getName());
                    }
                    IOUtils.copy((InputStream)mailStream, (OutputStream)response.getOutputStream());
                } else {
                    InputStreamReader isr = cm != null ? new InputStreamReader(mailStream, cm.getName()) : new InputStreamReader(mailStream);
                    BufferedReader br = new BufferedReader(isr);
                    while (br.ready()) {
                        response.getWriter().println(br.readLine());
                    }
                }
            } else if (onlyMailHeaders) {
                String[] recipients;
                JSONObject temp = new JSONObject();
                JSONObject result = new JSONObject();
                String ccList = "";
                String toList = "";
                JSONArray bccList = new JSONArray();
                for (Header header : myDoc.getMetaData().getHeaders()) {
                    if (header.getName().equals("Cc")) {
                        ccList = header.getBody();
                        continue;
                    }
                    if (header.getName().equals("To")) {
                        toList = header.getBody();
                        continue;
                    }
                    result.put(header.getName(), (Object)header.getBody());
                }
                for (String aktRecipient : recipients = myDoc.getMetaData().getRecipients()) {
                    if (toList.contains(aktRecipient) || ccList.contains(aktRecipient)) continue;
                    bccList.put((Object)aktRecipient);
                }
                result.put("Bcc", (Object)bccList);
                result.put("Cc", (Object)RecipientResolver.getJSONArrayFromString(ccList));
                result.put("To", (Object)RecipientResolver.getJSONArrayFromString(toList));
                result.put("Size", myDoc.getMetaData().getSize());
                response.setContentType("application/json; charset=UTF-8");
                result.write((Writer)response.getWriter());
            } else {
                String[] recipients;
                JSONArray headers = new JSONArray();
                JSONArray attachments = new JSONArray();
                JSONArray bodies = new JSONArray();
                JSONObject temp = new JSONObject();
                JSONObject file = new JSONObject();
                JSONObject result = new JSONObject();
                String ccList = "";
                String toList = "";
                JSONArray bccList = new JSONArray();
                for (Header header : myDoc.getMetaData().getHeaders()) {
                    if (header.getName().equals("Cc")) {
                        ccList = header.getBody();
                        continue;
                    }
                    if (header.getName().equals("To")) {
                        toList = header.getBody();
                        continue;
                    }
                    temp.put(header.getName(), (Object)header.getBody());
                }
                for (String aktRecipient : recipients = myDoc.getMetaData().getRecipients()) {
                    if (toList.contains(aktRecipient) || ccList.contains(aktRecipient)) continue;
                    bccList.put((Object)aktRecipient);
                }
                temp.put("Bcc", (Object)bccList);
                temp.put("Cc", (Object)RecipientResolver.getJSONArrayFromString(ccList));
                temp.put("To", (Object)RecipientResolver.getJSONArrayFromString(toList));
                temp.put("Size", myDoc.getMetaData().getSize());
                result.put("header", (Object)temp);
                MimeMultipart multipart = null;
                String textPart = null;
                ArrayList<JSONObject> attachmentList = new ArrayList<JSONObject>();
                ArrayList<JSONObject> bodyList = new ArrayList<JSONObject>();
                if (!myDoc.getMimeMesage().getContent().getClass().equals(String.class)) {
                    if (!myDoc.getMimeMesage().getContentType().contains("multipart/") && !myDoc.getMimeMesage().getContentType().contains("text/")) {
                        JSONObject tmpAttach = new JSONObject();
                        MailAttachment tmpAttachment = new MailAttachment(myDoc.getMimeMesage().getContentType(), myDoc.getMimeMesage().getSize());
                        tmpAttach.put("name", (Object)tmpAttachment.getFilename());
                        tmpAttach.put("content-type", (Object)tmpAttachment.getContentType());
                        tmpAttach.put("size", tmpAttachment.getSize());
                        attachmentList.add(tmpAttach);
                    } else {
                        multipart = (MimeMultipart)myDoc.getMimeMesage().getContent();
                    }
                } else {
                    textPart = (String)myDoc.getMimeMesage().getContent();
                }
                if (multipart != null) {
                    MimePartResolver.resolveMimeParts(multipart, attachmentList, bodyList);
                } else {
                    JSONObject tmpFile = new JSONObject();
                    tmpFile.put("content-type", (Object)myDoc.getMimeMesage().getContentType());
                    tmpFile.put("data", (Object)textPart);
                    bodyList.add(tmpFile);
                }
                for (JSONObject jo : attachmentList) {
                    attachments.put((Object)jo);
                }
                result.put("attachments", (Object)attachments);
                for (JSONObject jo : bodyList) {
                    bodies.put((Object)jo);
                }
                result.put("body", (Object)bodies);
                response.setContentType("application/json; charset=UTF-8");
                result.write((Writer)response.getWriter());
            }
            LOGGER.debug((Object)("Client: '" + request.getRemoteAddr() + "' requested Mail '" + searchId + "' Archive: '" + searchArchive + "' Response: " + responseFormat + " and it was successfull!"));
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.debug((Object)("File for ID '" + searchId + "' not found! Continer:" + searchArchive), (Throwable)fnfe);
            response.resetBuffer();
            response.setStatus(404);
            try {
                JSONObject errResult = new JSONObject();
                errResult.put("error", (Object)"file not found");
                errResult.write((Writer)response.getWriter());
            }
            catch (Exception ex) {
                LOGGER.fatal((Object)"Uncaught Excpetion", (Throwable)ex);
            }
        }
        catch (ContainerNotFoundException ex) {
            try {
                JSONObject errResult = new JSONObject();
                errResult.put("error", (Object)"container not found");
                errResult.write((Writer)response.getWriter());
            }
            catch (Exception iex) {
                LOGGER.fatal((Object)"Uncaught Excpetion", (Throwable)iex);
            }
            LOGGER.warn((Object)ex.getMessage());
        }
        catch (ParseException ex) {
            try {
                JSONObject errResult = new JSONObject();
                errResult.put("error", (Object)"Could not parse mailfile");
                errResult.write((Writer)response.getWriter());
            }
            catch (Exception iex) {
                LOGGER.fatal((Object)"Uncaught Excpetion", (Throwable)iex);
            }
            LOGGER.warn((Object)("Could not parse mail with ID: " + searchId));
            LOGGER.warn((Object)ex.getMessage());
        }
        catch (Exception ex) {
            LOGGER.fatal((Object)"Uncaught Excpetion", (Throwable)ex);
        }
    }

    private CharsetMatch detectCharset(MailDocument myDoc) throws MessagingException, IOException {
        CharsetMatch cm;
        CharsetDetector cd = new CharsetDetector();
        myDoc.getMimeMesage().getEncoding();
        cd.setText(myDoc.getMailStream());
        try {
            cm = cd.detect();
        }
        catch (Exception ex) {
            LOGGER.warn((Object)"Cannot detect charset: ", (Throwable)ex);
            cm = null;
        }
        return cm;
    }
}

