/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.servlets;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.archive.container.IContainerGenerator;
import de.lwsystems.mailarchive.config.BennoConfig;
import de.lwsystems.mailarchive.rest.BennoRest;
import de.lwsystems.mailarchive.rest.servlets.BennoAdminServlet;
import de.proite.mailarchive.rest.tools.BennoSearcherManager;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class BennoStatsServlet
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger(BennoAdminServlet.class);
    private final BennoRest bennoRest;
    private final Benno benno;
    private final BennoConfig config;

    public BennoStatsServlet(BennoRest bennoRest, Benno benno) {
        this.bennoRest = bennoRest;
        this.benno = benno;
        this.config = this.bennoRest.getBennoConfig();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProccess(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProccess(request, response);
    }

    protected void doProccess(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!request.getRemoteAddr().equals("127.0.0.1")) {
            LOGGER.info((Object)("Host " + request.getRemoteAddr() + " is not allowed to view stats!"));
            return;
        }
        JSONArray answer = new JSONArray();
        for (IArchive aktArchive : this.config.archiveGenerator.getArchiveGenerator(this.benno, true).getArchives()) {
            JSONObject archive = new JSONObject();
            IContainerGenerator containerGen = aktArchive.getContainerGenerator();
            try {
                archive.putOnce("name", (Object)aktArchive.getIdentifier());
                JSONArray containers = new JSONArray();
                for (IContainer container : containerGen.getContainers()) {
                    JSONObject aktContainer = new JSONObject();
                    aktContainer.putOnce("name", (Object)container.getIdentifier());
                    aktContainer.putOnce("mailCount", (Object)BennoSearcherManager.getInstance(this.config.bennoRestConfig.getIndexCacheTTL()).getSearcher(container).getIndexReader().numDocs());
                    containers.put((Object)aktContainer);
                }
                archive.put("containers", (Object)containers);
                archive.put("containerCount", containers.length());
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Unexcpeted excpetion:  " + ex));
            }
            answer.put((Object)archive);
        }
        try {
            response.setContentType("application/json; charset=UTF-8");
            response.setStatus(200);
            answer.write((Writer)response.getWriter());
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Unexcpeted excpetion:  " + ex));
        }
    }
}

