/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.servlets;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.container.ContainerNotFoundException;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.archive.container.IContainerGenerator;
import de.lwsystems.mailarchive.config.BennoConfig;
import de.proite.mailarchive.rest.tools.RecipientResolver;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.json.JSONException;
import org.json.JSONObject;

public class ServletTools {
    private static final Logger LOGGER = Logger.getLogger(ServletTools.class);

    static String getRequestDetails(HttpServletRequest request, boolean html) {
        StringBuilder sRet = new StringBuilder(html ? "<p>" : "");
        String nl = html ? "</p><p>" : "\n";
        sRet.append("session=" + request.getSession(true).getId()).append(nl);
        sRet.append("Authtype=" + request.getAuthType()).append(nl);
        sRet.append("Contenttype=" + request.getContentType()).append(nl);
        sRet.append("ContextPath=" + request.getContextPath()).append(nl);
        sRet.append("Method=" + request.getMethod()).append(nl);
        sRet.append("PathInfo=" + request.getPathInfo()).append(nl);
        sRet.append("PathTranslated=" + request.getPathTranslated()).append(nl);
        sRet.append("Protokoll=" + request.getProtocol()).append(nl);
        sRet.append("RemoteAddr=" + request.getRemoteAddr()).append(nl);
        sRet.append("RemoteUser=" + request.getRemoteUser()).append(nl);
        sRet.append("RemoteHost=" + request.getRemoteHost()).append(nl);
        sRet.append("ServletPath=" + request.getServletPath()).append(nl);
        sRet.append("RequestURL=" + request.getRequestURL().toString()).append(nl);
        sRet.append("CharacterEncoding=" + request.getCharacterEncoding()).append(nl);
        sRet.append("LocalAddr=" + request.getLocalAddr()).append(nl);
        sRet.append("LocalName=" + request.getLocalName()).append(nl);
        sRet.append("PathInfo=" + request.getPathInfo()).append(nl);
        sRet.append("QueryString=" + request.getQueryString()).append(nl);
        sRet.append("RequestURI=" + request.getRequestURI().toString()).append(nl);
        sRet.append("RequestedSessionId=" + request.getRequestedSessionId()).append(nl);
        sRet.append("Scheme=" + request.getScheme()).append(nl);
        sRet.append("ServerName=" + request.getServerName()).append(nl);
        if (request.getCookies() != null) {
            sRet.append("Cookies:").append(nl);
            for (Cookie cookie : request.getCookies()) {
                sRet.append("Name=" + cookie.getName()).append(nl);
                sRet.append("Domain=" + cookie.getDomain()).append(nl);
                sRet.append("Path=" + cookie.getPath()).append(nl);
                sRet.append("Value=" + cookie.getValue()).append(nl);
                sRet.append("Comment=" + cookie.getComment()).append(nl);
                sRet.append("MaxAge=" + Integer.toString(cookie.getMaxAge())).append(nl);
                sRet.append("Version=" + Integer.toString(cookie.getVersion())).append(nl);
                sRet.append("Secure=" + Boolean.toString(cookie.getSecure())).append(nl).append(nl);
            }
            Principal principal = request.getUserPrincipal();
            if (principal != null) {
                sRet.append("Principal:").append(nl);
                sRet.append("Name=" + principal.getName()).append(nl);
                sRet.append("toString=" + ((Object)principal).toString()).append(nl);
                sRet.append("Class=" + principal.getClass().toString()).append(nl);
            }
        }
        sRet.append(html ? "</p>" : "");
        return sRet.toString();
    }

    public static JSONObject createJson(Document hitDoc) throws JSONException, IOException {
        JSONObject temp = new JSONObject();
        if (hitDoc.get("Date") != null) {
            temp.put("Date", (Object)hitDoc.get("Date").toString());
        } else {
            temp.put("Date", (Object)"197001010000");
        }
        temp.put("Subject", (Object)hitDoc.get("Subject"));
        temp.put("From", (Object)hitDoc.get("From"));
        temp.put("id", (Object)hitDoc.get("id"));
        RecipientResolver rr = new RecipientResolver(hitDoc.getFieldables("To"), hitDoc.getFieldables("Cc"), hitDoc.getFieldables("Recipient"));
        temp.put("To", (Object)rr.getToJSONArray());
        temp.put("Cc", (Object)rr.getCcJSONArray());
        temp.put("Bcc", (Object)rr.getBccJSONArray());
        if (hitDoc.get("hasAttachment") == null) {
            temp.put("hasAttachment", (Object)"0");
        } else {
            temp.put("hasAttachment", (Object)hitDoc.get("hasAttachment"));
        }
        return temp;
    }

    public static IContainer getContainer(String searchArchive, Benno benno) throws ContainerNotFoundException {
        BennoConfig config = benno.getConfig();
        IContainer myContainer = null;
        for (IArchive aktArchive : config.archiveGenerator.getArchiveGenerator(benno, true).getArchives()) {
            IContainerGenerator containerGen = aktArchive.getContainerGenerator();
            try {
                myContainer = containerGen.getContainer(searchArchive);
                break;
            }
            catch (Exception searchEx) {
            }
        }
        if (myContainer == null) {
            throw new ContainerNotFoundException(searchArchive);
        }
        return myContainer;
    }

    public static JSONObject createJson(IndexSearcher isearcher, ScoreDoc scoreDoc) throws CorruptIndexException, IOException, JSONException {
        FieldSelector fds = new FieldSelector(){

            public FieldSelectorResult accept(String fieldName) {
                if (fieldName.equals("Date") || fieldName.equals("Subject") || fieldName.equals("From") || fieldName.equals("id") || fieldName.equals("To") || fieldName.equals("Cc") || fieldName.equals("Recipient") || fieldName.equals("hasAttachment")) {
                    return FieldSelectorResult.LOAD;
                }
                return FieldSelectorResult.NO_LOAD;
            }
        };
        Document hitDoc = isearcher.doc(scoreDoc.doc, fds);
        return ServletTools.createJson(hitDoc);
    }
}

