/*
 * Decompiled with CFR 0.152.
 */
package de.proite.mailarchive.rest.tools;

import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import de.proite.mailarchive.rest.tools.MailAttachment;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.eclipse.jetty.io.WriterOutputStream;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimePartResolver {
    private static final Logger LOGGER = Logger.getLogger(MimePartResolver.class);

    public static void resolveMimeParts(MimeMultipart mm, ArrayList<JSONObject> attachments, ArrayList<JSONObject> bodies) throws MessagingException, IOException {
        for (int i = 0; i < mm.getCount(); ++i) {
            BodyPart bp = mm.getBodyPart(i);
            boolean isMultiPart = false;
            try {
                if (bp.getContent().getClass().equals(MimeMultipart.class)) {
                    isMultiPart = true;
                }
            }
            catch (UnsupportedEncodingException ex) {
                isMultiPart = false;
                bp.setHeader("Content-Type", bp.getContentType().substring(0, bp.getContentType().indexOf(";")) + ";");
                LOGGER.info((Object)("Detected unsupported charset in Content-Type-Header. Force Content-Type to: " + bp.getContentType()));
            }
            if (isMultiPart) {
                MimePartResolver.resolveMimeParts((MimeMultipart)bp.getContent(), attachments, bodies);
                continue;
            }
            JSONObject file = new JSONObject();
            if (bp.getFileName() != null) {
                MailAttachment tmpAttachment = new MailAttachment(bp);
                try {
                    file.put("name", (Object)tmpAttachment.getFilename());
                    file.put("content-type", (Object)tmpAttachment.getContentType());
                    file.put("size", tmpAttachment.getSize());
                }
                catch (Exception ex) {
                    LOGGER.fatal((Object)"Uncaught Excpetion", (Throwable)ex);
                }
                attachments.add(file);
                continue;
            }
            try {
                file.put("content-type", (Object)bp.getContentType().substring(0, bp.getContentType().indexOf(";")));
                Object content = bp.getContent();
                if (content instanceof BASE64DecoderStream) {
                    BASE64DecoderStream stream = (BASE64DecoderStream)content;
                    StringWriter writer = new StringWriter();
                    BASE64EncoderStream base64Stream = new BASE64EncoderStream((OutputStream)new WriterOutputStream((Writer)writer));
                    IOUtils.copy((InputStream)stream, (OutputStream)base64Stream);
                    file.put("data", (Object)writer.getBuffer().toString());
                } else {
                    file.put("data", content);
                }
            }
            catch (Exception ex) {
                LOGGER.fatal((Object)"Uncaught Excpetion", (Throwable)ex);
            }
            bodies.add(file);
        }
    }

    public static void getBodyPartList(MimeMultipart mm, ArrayList<BodyPart> bodyParts) throws MessagingException, IOException {
        ArrayList bodyPart = new ArrayList();
        for (int i = 0; i < mm.getCount(); ++i) {
            BodyPart bp = mm.getBodyPart(i);
            boolean isMultiPart = false;
            try {
                if (bp.getContent().getClass().equals(MimeMultipart.class)) {
                    isMultiPart = true;
                }
            }
            catch (UnsupportedEncodingException ex) {
                isMultiPart = false;
                bp.setHeader("Content-Type", bp.getContentType().substring(0, bp.getContentType().indexOf(";")) + ";");
                LOGGER.info((Object)("Detected unsupported charset in Content-Type-Header. Force Content-Type to: " + bp.getContentType()));
            }
            if (isMultiPart) {
                MimePartResolver.getBodyPartList((MimeMultipart)bp.getContent(), bodyParts);
                continue;
            }
            bodyParts.add(bp);
        }
    }
}

