/*
 * Decompiled with CFR 0.152.
 */
package de.proite.mailarchive.rest.tools;

import javax.mail.BodyPart;

public class MailAttachment {
    private String filename;
    private String contentType;
    private int size;

    public MailAttachment() {
        this.filename = "";
        this.contentType = "";
        this.size = 0;
    }

    public MailAttachment(BodyPart bp) {
        try {
            this.filename = bp.getFileName();
            this.contentType = bp.getContentType().substring(0, bp.getContentType().indexOf(";"));
            this.size = bp.getSize();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MailAttachment(String contentType, int size) {
        this.contentType = contentType.substring(0, contentType.indexOf(";"));
        if (contentType.contains("name=")) {
            this.filename = contentType.replaceAll(this.contentType + ";", "").replaceAll("\\s+", "").replaceAll("name=", "").replaceAll("\"", "");
        } else if (contentType.contains("filename=")) {
            this.filename = contentType.replaceAll(this.contentType + ";", "").replaceAll("\\s+", "").replaceAll("filename=", "").replaceAll("\"", "");
        }
        this.size = size;
    }

    public String getFilename() {
        if (this.filename != null) {
            return this.filename;
        }
        return null;
    }

    public String getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        return null;
    }

    public int getSize() {
        return this.size;
    }
}

