/*
 * Decompiled with CFR 0.152.
 */
package de.proite.mailarchive.rest.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Fieldable;
import org.json.JSONArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecipientResolver {
    List<Fieldable> toList = new ArrayList<Fieldable>();
    List<Fieldable> ccList = new ArrayList<Fieldable>();
    List<Fieldable> bccList = new ArrayList<Fieldable>();

    public RecipientResolver(Fieldable[] to, Fieldable[] cc, Fieldable[] recipients) {
        for (Fieldable toField : to) {
            this.toList.add(toField);
        }
        for (Fieldable ccField : cc) {
            this.ccList.add(ccField);
        }
        for (Fieldable recipientField : recipients) {
            boolean found = false;
            for (Fieldable toField : to) {
                if (!toField.stringValue().contains(recipientField.stringValue())) continue;
                found = true;
            }
            if (!found) {
                for (Fieldable ccField : cc) {
                    if (!ccField.stringValue().contains(recipientField.stringValue())) continue;
                    found = true;
                }
            }
            if (found) continue;
            this.bccList.add(recipientField);
        }
    }

    public List<Fieldable> getToList() {
        return this.toList;
    }

    public JSONArray getToJSONArray() throws IOException {
        JSONArray toArray = new JSONArray();
        for (Fieldable tmp : this.toList) {
            toArray.put((Object)tmp.stringValue());
        }
        return toArray;
    }

    public List<Fieldable> getCcList() {
        return this.ccList;
    }

    public JSONArray getCcJSONArray() {
        JSONArray ccArray = new JSONArray();
        for (Fieldable tmp : this.ccList) {
            ccArray.put((Object)tmp.stringValue());
        }
        return ccArray;
    }

    public List<Fieldable> getBccList() {
        return this.bccList;
    }

    public JSONArray getBccJSONArray() {
        JSONArray bccArray = new JSONArray();
        for (Fieldable tmp : this.bccList) {
            bccArray.put((Object)tmp.stringValue());
        }
        return bccArray;
    }

    public static JSONArray getJSONArrayFromString(String input) {
        JSONArray result = new JSONArray();
        if (input.isEmpty()) {
            return result;
        }
        for (String aktRecipient : input.split(", ")) {
            result.put((Object)aktRecipient);
        }
        return result;
    }
}

