/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.servlets;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.IArchiveGenerator;
import de.lwsystems.mailarchive.archive.container.ContainerNotFoundException;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.config.BennoConfig;
import de.lwsystems.mailarchive.rest.BennoRest;
import de.lwsystems.mailarchive.rest.servlets.ServletTools;
import de.proite.mailarchive.rest.tools.BennoFilterManager;
import de.proite.mailarchive.rest.tools.BennoSearcherManager;
import java.io.IOException;
import java.io.Writer;
import java.rmi.NoSuchObjectException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.ClassicAnalyzer;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopFieldCollector;
import org.json.JSONArray;
import org.json.JSONObject;

public class BennoSearchServlet
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger(BennoSearchServlet.class);
    boolean debugEnabled = LOGGER.isDebugEnabled();
    private final BennoRest bennoRest;
    private final Benno benno;

    public BennoSearchServlet(BennoRest bennoRest, Benno benno) {
        this.bennoRest = bennoRest;
        this.benno = benno;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProcess(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProcess(request, response);
    }

    protected void doProcess(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        Integer TESTTIME = 60;
        JSONObject answer = new JSONObject();
        Integer overAll = 0;
        String sessionId = session.getId();
        response.setContentType("application/json; charset=UTF-8");
        response.setStatus(200);
        try {
            ScoreDoc[] hits;
            IndexReader ireader;
            int limit;
            int start;
            String sortField = "SortableDate";
            boolean sortAsc = false;
            String filterQuery = "";
            CachingWrapperFilter filter = null;
            boolean documentCounter = false;
            boolean full = false;
            long cacheTTL = 0L;
            BennoConfig config = this.bennoRest.getBennoConfig();
            IArchiveGenerator archiveGenerator = config.getArchiveGenerator(this.benno, true);
            String searchArchive = request.getParameter("archive");
            String queryString = request.getParameter("query");
            if (queryString.contains("Date:[")) {
                queryString = queryString.replaceAll("Date:\\[", "SortableDate:[");
            }
            if (request.getParameter("start") != null) {
                try {
                    start = Integer.parseInt(request.getParameter("start"));
                    if (start < 1) {
                        start = 1;
                    }
                }
                catch (Exception ex) {
                    LOGGER.error((Object)(sessionId + " Error reading parameter \"start\": " + ex));
                    start = 1;
                }
            } else {
                start = 1;
            }
            int hitIndex = start - 1;
            if (request.getParameter("limit") != null) {
                try {
                    limit = Integer.parseInt(request.getParameter("limit"));
                    if (limit < 0) {
                        limit = 0;
                    }
                }
                catch (Exception ex) {
                    LOGGER.error((Object)(sessionId + " Error reading parameter \"limit\": " + ex));
                    limit = 20;
                }
            } else {
                limit = 20;
            }
            answer.put("limit", limit);
            if (request.getParameter("sort") != null && ((sortField = request.getParameter("sort")).equals("Date") || sortField.equals("Subject"))) {
                sortField = "Sortable" + sortField;
            }
            if (request.getParameter("sortAsc") != null && request.getParameter("sortAsc").equals("false")) {
                sortAsc = true;
            }
            if (request.getParameter("full") != null && request.getParameter("full").equals("true")) {
                full = true;
            }
            if ((filterQuery = request.getParameter("filterQuery")) == null || filterQuery.equals("")) {
                LOGGER.error((Object)(sessionId + "Parameter \"filterQuery\" empty or not set."));
                BennoSearchServlet.badRequest(response, "Request filter error!", "Parameter \"filterQuery\" empty or not set in request.");
                return;
            }
            cacheTTL = config.bennoRestConfig.getIndexCacheTTL();
            IContainer myContainer = null;
            if (session.getAttribute("myContainer") == null || session.getAttribute("myArchive") == null || session.getAttribute("myContainer") != searchArchive) {
                myContainer = ServletTools.getContainer(searchArchive, this.benno);
                session.setAttribute("myContainer", (Object)myContainer);
                session.setAttribute("lastQuery", null);
                cacheTTL = 0L;
            } else {
                myContainer = (IContainer)session.getAttribute("myContainer");
            }
            IndexSearcher isearcher = BennoSearcherManager.getInstance(cacheTTL).getSearcher(myContainer);
            try {
                ireader = isearcher.getIndexReader();
            }
            catch (NullPointerException e) {
                throw new RuntimeException("Archive \"" + searchArchive + "\"not initialized! Please import some emails");
            }
            String licenseStatus = "LICENSE_STATUS_UNKNOWN";
            licenseStatus = this.bennoRest.getLicenseStatus();
            if (!licenseStatus.equals("LICENSE_VALID")) {
                Calendar endOfTestPeriod = this.endOfTestPeriod(ireader, TESTTIME);
                if (endOfTestPeriod.after(Calendar.getInstance())) {
                    licenseStatus = "LICENSE_VALID_TESTPERIOD";
                    this.bennoRest.setLicenseStatus(licenseStatus);
                    String expireDate = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT).format(endOfTestPeriod.getTime());
                    this.bennoRest.setLicenseExpires(expireDate);
                } else {
                    LOGGER.warn((Object)("The test period has expired at " + endOfTestPeriod.getTime().toString()));
                    filterQuery = "*";
                    LOGGER.warn((Object)"LICENSE NOT VALID");
                }
            }
            if (session.getAttribute("lastQuery") != null && session.getAttribute("lastQuery").equals(queryString) && session.getAttribute("lastSortField") != null && session.getAttribute("lastSortField").equals(sortField) && session.getAttribute("lastSortAsc") != null && session.getAttribute("lastSortAsc").equals(sortAsc) && session.getAttribute("lastFilterQuery").equals(filterQuery) && session.getAttribute("lastFirst") != null && new Date().getTime() - (Long)session.getAttribute("lastTime") <= 120000L) {
                overAll = (Integer)session.getAttribute("overAll");
                this.logDebug(sessionId + " Using cached result - Result from: " + session.getAttribute("lastTime"));
                this.logDebug(sessionId + " Time-Diff: " + (new Date().getTime() - (Long)session.getAttribute("lastTime")));
            } else {
                this.logDebug(sessionId + " Archive: " + myContainer.getArchive().getIdentifier());
                this.logDebug(sessionId + " Container: " + myContainer.getIdentifier());
                ClassicAnalyzer analyzer = new ClassicAnalyzer(myContainer.getIndexVersion());
                QueryParser parser = new QueryParser(myContainer.getIndexVersion(), "Subject", (Analyzer)analyzer);
                parser.setAllowLeadingWildcard(true);
                this.logDebug(sessionId + " Request-Query: " + queryString);
                Query query = parser.parse(queryString);
                this.logDebug(sessionId + " Parsed-Query: " + query.toString());
                if (sortField != null) {
                    this.logDebug(sessionId + " SortField: " + sortField.toString());
                }
                if ((filter = BennoFilterManager.getInstance(parser).getFilter(filterQuery)) == null) {
                    LOGGER.warn((Object)(sessionId + " Invalid filterQuery string: " + request.getParameter("filterQuery")));
                    LOGGER.error((Object)(sessionId + "Invalid \"filterQuery\" string."));
                    BennoSearchServlet.badRequest(response, "Request filter string invalid!", "Syntax error in \"filterQuery\" string.");
                    return;
                }
                this.logDebug(sessionId + " Filter: " + filter.toString());
                int sortType = sortField.equals("SortableDate") ? 6 : 3;
                isearcher.setDefaultFieldSortScoring(false, false);
                TopFieldCollector results = TopFieldCollector.create((Sort)new Sort(new SortField(sortField, sortType, sortAsc)), (int)999999, (boolean)false, (boolean)false, (boolean)false, (boolean)sortAsc);
                if (filter == null) {
                    LOGGER.warn((Object)(sessionId + " Start searching for documents without filter."));
                    isearcher.search(query, (Collector)results);
                } else {
                    this.logDebug(sessionId + " Start searching for documents with filter.");
                    isearcher.search(query, (Filter)filter, (Collector)results);
                }
                hits = results.topDocs((int)0).scoreDocs;
                this.logDebug(sessionId + " Query returns " + hits.length + " results");
                overAll = ireader.numDocs();
                session.setAttribute("lastTime", (Object)new Date().getTime());
                session.setAttribute("lastQuery", (Object)queryString);
                session.setAttribute("lastResults", (Object)hits);
                session.setAttribute("lastSortField", (Object)sortField);
                session.setAttribute("lastFilterQuery", (Object)filterQuery);
                session.setAttribute("lastSortAsc", (Object)sortAsc);
                session.setAttribute("overAll", (Object)overAll);
                if (hits.length <= 0) {
                    answer.put("found", (Object)"0");
                    answer.put("count", (Object)"0");
                    answer.put("first", (Object)"-1");
                    answer.put("last", (Object)"-1");
                    answer.put("overall", (Object)overAll);
                    answer.put("licenseValid", (Object)licenseStatus);
                    throw new NoSuchObjectException("No results found!");
                }
            }
            hits = (ScoreDoc[])session.getAttribute("lastResults");
            JSONArray results = new JSONArray();
            int countTo = limit > hits.length ? hits.length : hitIndex + limit;
            if (hitIndex + limit > hits.length) {
                countTo = hits.length;
            }
            session.setAttribute("lastFirst", (Object)start);
            if (!full) {
                for (int i = hitIndex; i < countTo; ++i) {
                    JSONObject temp = ServletTools.createJson(isearcher, hits[i]);
                    results.put((Object)temp);
                }
            } else {
                for (int i = hitIndex; i < countTo; ++i) {
                    Document hitDoc = isearcher.doc(hits[i].doc);
                    JSONObject temp = new JSONObject();
                    List fieldList = hitDoc.getFields();
                    for (AbstractField field : fieldList) {
                        temp.put(field.name(), (Object)field.stringValue());
                        results.put((Object)temp);
                    }
                }
            }
            answer.put("found", hits.length);
            answer.put("overall", (Object)overAll);
            answer.put("count", results.length());
            answer.put("first", start);
            answer.put("last", countTo);
            answer.put("results", (Object)results);
            answer.put("licenseValid", (Object)licenseStatus);
            if (results.length() == 0) {
                answer.put("last", -1);
                answer.put("first", -1);
            }
            answer.write((Writer)response.getWriter());
        }
        catch (NoSuchObjectException nsoe) {
            response.resetBuffer();
            response.getWriter().println(answer.toString());
        }
        catch (ContainerNotFoundException cnfe) {
            LOGGER.warn((Object)cnfe.getMessage());
            response.resetBuffer();
            response.setStatus(404);
            try {
                JSONObject errResult = new JSONObject();
                errResult.put("error", (Object)"container not found");
                errResult.write((Writer)response.getWriter());
            }
            catch (Exception ex) {
                LOGGER.fatal((Object)"Uncaught Excpetion", (Throwable)ex);
            }
        }
        catch (ParseException pex) {
            try {
                JSONObject errResult = new JSONObject();
                errResult.put("error", (Object)"Invalid query");
                errResult.write((Writer)response.getWriter());
                LOGGER.warn((Object)(sessionId + " Invalid query string: " + request.getParameter("query")));
            }
            catch (Exception ex) {
                LOGGER.warn((Object)"Uncaught Exception", (Throwable)ex);
            }
        }
        catch (Exception e) {
            response.setStatus(503);
            LOGGER.fatal((Object)"Uncaught Exception", (Throwable)e);
        }
    }

    private static void badRequest(HttpServletResponse response, String title, String content) throws IOException {
        response.setStatus(400);
        response.getWriter().print("<html><head>");
        response.getWriter().print("<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>");
        response.getWriter().print("<title>" + title + "</title>");
        response.getWriter().print("<h2>HTTP ERROR: 400</h2>");
        response.getWriter().print("<p>" + content + "</p>");
        response.flushBuffer();
    }

    private Calendar endOfTestPeriod(IndexReader ireader, Integer TESTTIME) throws CorruptIndexException, IOException, java.text.ParseException {
        String indexTS = "";
        indexTS = ireader.document(0).get("IndexTS");
        if (indexTS == null) {
            this.logDebug("Document indexed with Benno < v2.1.5");
            indexTS = "20000101000000000";
        }
        Date indexStart = new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.ROOT).parse(indexTS);
        Calendar indexStartTime = Calendar.getInstance();
        indexStartTime.setTime(indexStart);
        Calendar endOfTestTime = Calendar.getInstance();
        endOfTestTime.setTime(indexStart);
        endOfTestTime.add(5, TESTTIME);
        return endOfTestTime;
    }

    private void logDebug(String msg) {
        Logger LOGGER = Logger.getLogger(BennoSearchServlet.class);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)msg);
        }
    }
}

